/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.StartTLSRequest;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.base.AbstractProcessor;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Mono;

public class StartTLSProcessor
extends AbstractProcessor<StartTLSRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> STARTTLS_CAP = ImmutableList.of((Object)ImapConstants.SUPPORTS_STARTTLS);
    private final StatusResponseFactory factory;

    @Inject
    public StartTLSProcessor(StatusResponseFactory factory) {
        super(StartTLSRequest.class);
        this.factory = factory;
    }

    @Override
    protected Mono<Void> doProcess(StartTLSRequest request, ImapProcessor.Responder responder, ImapSession session) {
        return Mono.fromRunnable(() -> {
            if (session.supportStartTLS()) {
                session.startTLS(() -> {
                    responder.respond(this.factory.taggedOk(request.getTag(), request.getCommand(), HumanReadableText.STARTTLS));
                    responder.flush();
                });
            } else {
                responder.respond(this.factory.taggedBad(request.getTag(), request.getCommand(), HumanReadableText.UNKNOWN_COMMAND));
            }
        });
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        if (session.supportStartTLS()) {
            return STARTTLS_CAP;
        }
        return Collections.emptyList();
    }

    @Override
    protected MDCBuilder mdc(StartTLSRequest message) {
        return MDCBuilder.create().addToContext("action", "START_TLS");
    }
}

