/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.DeleteIndexResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class DeleteIndexRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoIndices;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final Time timeout;
    public static final Endpoint<DeleteIndexRequest, DeleteIndexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteIndexRequest, DeleteIndexResponse>(request -> "DELETE", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", request.clusterManagerTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteIndexResponse._DESERIALIZER);

    private DeleteIndexRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.masterTimeout = builder.masterTimeout;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.timeout = builder.timeout;
    }

    public static DeleteIndexRequest of(Function<Builder, ObjectBuilder<DeleteIndexRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DeleteIndexRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        private List<String> index;
        @Deprecated
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Time timeout;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Deprecated
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public DeleteIndexRequest build() {
            this._checkSingleUse();
            return new DeleteIndexRequest(this);
        }
    }
}

