/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ProxiedAuthorizationV1RequestControl
extends Control {
    @NotNull
    public static final String PROXIED_AUTHORIZATION_V1_REQUEST_OID = "2.16.840.1.113730.3.4.12";
    @NotNull
    private static final String JSON_FIELD_AUTHORIZATION_DN = "authorization-dn";
    private static final long serialVersionUID = 7312632337431962774L;
    @NotNull
    private final String proxyDN;

    public ProxiedAuthorizationV1RequestControl(@NotNull String proxyDN) {
        super(PROXIED_AUTHORIZATION_V1_REQUEST_OID, true, ProxiedAuthorizationV1RequestControl.encodeValue(proxyDN));
        Validator.ensureNotNull(proxyDN);
        this.proxyDN = proxyDN;
    }

    public ProxiedAuthorizationV1RequestControl(@NotNull DN proxyDN) {
        super(PROXIED_AUTHORIZATION_V1_REQUEST_OID, true, ProxiedAuthorizationV1RequestControl.encodeValue(proxyDN.toString()));
        this.proxyDN = proxyDN.toString();
    }

    public ProxiedAuthorizationV1RequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXY_V1_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.proxyDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXYV1_DECODE_ERROR.get(e), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String proxyDN) {
        ASN1Element[] valueElements = new ASN1Element[]{new ASN1OctetString(proxyDN)};
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    @NotNull
    public String getProxyDN() {
        return this.proxyDN;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PROXIED_AUTHZ_V1_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", PROXIED_AUTHORIZATION_V1_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_PROXIED_AUTHZ_V1_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_AUTHORIZATION_DN, this.proxyDN))));
    }

    @NotNull
    public static ProxiedAuthorizationV1RequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new ProxiedAuthorizationV1RequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String authorizationDN = valueObject.getFieldAsString(JSON_FIELD_AUTHORIZATION_DN);
        if (authorizationDN == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXYV1_JSON_MISSING_AUTHZ_DN.get(controlObject.toSingleLineString(), JSON_FIELD_AUTHORIZATION_DN));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_AUTHORIZATION_DN)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXYV1_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new ProxiedAuthorizationV1RequestControl(authorizationDN);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ProxiedAuthorizationV1RequestControl(proxyDN='");
        buffer.append(this.proxyDN);
        buffer.append("')");
    }
}

