/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DIGESTMD5BindRequestProperties
implements Serializable {
    private static final long serialVersionUID = -2000440962628192477L;
    @NotNull
    private ASN1OctetString password;
    @NotNull
    private List<SASLQualityOfProtection> allowedQoP;
    @NotNull
    private String authenticationID;
    @Nullable
    private String authorizationID;
    @Nullable
    private String realm;

    public DIGESTMD5BindRequestProperties(@NotNull String authenticationID, @Nullable String password) {
        this(authenticationID, new ASN1OctetString(password));
    }

    public DIGESTMD5BindRequestProperties(@NotNull String authenticationID, @Nullable byte[] password) {
        this(authenticationID, new ASN1OctetString(password));
    }

    public DIGESTMD5BindRequestProperties(@NotNull String authenticationID, @Nullable ASN1OctetString password) {
        Validator.ensureNotNull(authenticationID);
        this.authenticationID = authenticationID;
        this.password = password == null ? new ASN1OctetString() : password;
        this.authorizationID = null;
        this.realm = null;
        this.allowedQoP = Collections.singletonList(SASLQualityOfProtection.AUTH);
    }

    @NotNull
    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public void setAuthenticationID(@NotNull String authenticationID) {
        Validator.ensureNotNull(authenticationID);
        this.authenticationID = authenticationID;
    }

    @Nullable
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public void setAuthorizationID(@Nullable String authorizationID) {
        this.authorizationID = authorizationID;
    }

    @NotNull
    public ASN1OctetString getPassword() {
        return this.password;
    }

    public void setPassword(@NotNull String password) {
        this.setPassword(new ASN1OctetString(password));
    }

    public void setPassword(@NotNull byte[] password) {
        this.setPassword(new ASN1OctetString(password));
    }

    public void setPassword(@Nullable ASN1OctetString password) {
        this.password = password == null ? new ASN1OctetString() : password;
    }

    @Nullable
    public String getRealm() {
        return this.realm;
    }

    public void setRealm(@Nullable String realm) {
        this.realm = realm;
    }

    @NotNull
    public List<SASLQualityOfProtection> getAllowedQoP() {
        return this.allowedQoP;
    }

    public void setAllowedQoP(@Nullable List<SASLQualityOfProtection> allowedQoP) {
        this.allowedQoP = allowedQoP == null || allowedQoP.isEmpty() ? Collections.singletonList(SASLQualityOfProtection.AUTH) : Collections.unmodifiableList(new ArrayList<SASLQualityOfProtection>(allowedQoP));
    }

    public void setAllowedQoP(SASLQualityOfProtection ... allowedQoP) {
        this.setAllowedQoP(StaticUtils.toList(allowedQoP));
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("DIGESTMD5BindRequestProperties(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.realm != null) {
            buffer.append(", realm='");
            buffer.append(this.realm);
            buffer.append('\'');
        }
        buffer.append(", qop='");
        buffer.append(SASLQualityOfProtection.toString(this.allowedQoP));
        buffer.append("')");
    }
}

