/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve;

import org.apache.jsieve.exception.CommandException;
import org.apache.jsieve.exception.SyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptCoordinate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptCoordinate.class);
    private final int startLineNumber;
    private final int startColumnNumber;
    private final int endLineNumber;
    private final int endColumnNumber;

    public ScriptCoordinate(int startLineNumber, int startColumnNumber, int endLineNumber, int endColumnNumber) {
        this.startLineNumber = startLineNumber;
        this.startColumnNumber = startColumnNumber;
        this.endLineNumber = endLineNumber;
        this.endColumnNumber = endColumnNumber;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public int getStartColumnNumber() {
        return this.startColumnNumber;
    }

    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    public SyntaxException syntaxException(String message) {
        LOGGER.warn(message);
        this.logDiagnosticsInfo();
        String fullMessage = this.addStartLineAndColumn(message);
        return new SyntaxException(fullMessage);
    }

    public CommandException commandException(String message) {
        LOGGER.warn(message);
        this.logDiagnosticsInfo();
        String fullMessage = this.addStartLineAndColumn(message);
        return new CommandException(fullMessage);
    }

    public String addStartLineAndColumn(CharSequence message) {
        StringBuilder buffer = message instanceof StringBuilder ? (StringBuilder)message : new StringBuilder(message.toString());
        buffer.append(" Line ");
        buffer.append(this.startLineNumber);
        buffer.append(" column ");
        buffer.append(this.startColumnNumber);
        buffer.append(".");
        return buffer.toString();
    }

    public void logDiagnosticsInfo() {
        LOGGER.info("Expression starts line {} column {}", (Object)this.startLineNumber, (Object)this.startColumnNumber);
        LOGGER.info("Expression ends line {} column {}", (Object)this.endLineNumber, (Object)this.endColumnNumber);
    }

    public void debugDiagnostics() {
        LOGGER.debug("Expression starts line {} column {}", (Object)this.startLineNumber, (Object)this.startColumnNumber);
        LOGGER.debug("Expression ends line {} column {}", (Object)this.endLineNumber, (Object)this.endColumnNumber);
    }
}

