/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.crypto;

import com.google.common.base.Preconditions;
import java.time.chrono.ChronoZonedDateTime;
import javax.inject.Inject;
import org.apache.james.jmap.draft.api.SimpleTokenManager;
import org.apache.james.jmap.draft.crypto.SignatureHandler;
import org.apache.james.jmap.draft.model.SignedExpiringToken;
import org.apache.james.util.date.ZonedDateTimeProvider;

public class SignedTokenManager
implements SimpleTokenManager {
    private final SignatureHandler signatureHandler;
    private final ZonedDateTimeProvider zonedDateTimeProvider;

    @Inject
    public SignedTokenManager(SignatureHandler signatureHandler, ZonedDateTimeProvider zonedDateTimeProvider) {
        this.signatureHandler = signatureHandler;
        this.zonedDateTimeProvider = zonedDateTimeProvider;
    }

    @Override
    public SimpleTokenManager.TokenStatus getValidity(SignedExpiringToken token) {
        Preconditions.checkNotNull((Object)token);
        if (!this.isCorrectlySigned(token)) {
            return SimpleTokenManager.TokenStatus.INVALID;
        }
        if (this.isExpired(token)) {
            return SimpleTokenManager.TokenStatus.EXPIRED;
        }
        return SimpleTokenManager.TokenStatus.OK;
    }

    @Override
    public boolean isValid(SignedExpiringToken token) {
        Preconditions.checkNotNull((Object)token);
        return SimpleTokenManager.TokenStatus.OK.equals((Object)this.getValidity(token));
    }

    private boolean isCorrectlySigned(SignedExpiringToken token) {
        return this.signatureHandler.verify(token.getSignedContent(), token.getSignature());
    }

    private boolean isExpired(SignedExpiringToken token) {
        return token.getExpirationDate().isBefore((ChronoZonedDateTime)this.zonedDateTimeProvider.get());
    }
}

