/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.EventsourcingConfigurationManagement;

public class CassandraMailQueueViewStartUpCheck
implements StartUpCheck {
    private static final String NAME = "cassandra-mail-queue-view-startup-check";
    private final EventsourcingConfigurationManagement eventsourcingConfigurationManagement;
    private final CassandraMailQueueViewConfiguration configuration;

    @Inject
    @VisibleForTesting
    public CassandraMailQueueViewStartUpCheck(EventsourcingConfigurationManagement eventsourcingConfigurationManagement, CassandraMailQueueViewConfiguration configuration) {
        this.eventsourcingConfigurationManagement = eventsourcingConfigurationManagement;
        this.configuration = configuration;
    }

    public StartUpCheck.CheckResult check() {
        try {
            this.eventsourcingConfigurationManagement.registerConfiguration(this.configuration);
            return StartUpCheck.CheckResult.builder().checkName(NAME).resultType(StartUpCheck.ResultType.GOOD).build();
        }
        catch (IllegalArgumentException e) {
            return StartUpCheck.CheckResult.builder().checkName(NAME).resultType(StartUpCheck.ResultType.BAD).description(e.getMessage()).build();
        }
    }

    public String checkName() {
        return NAME;
    }
}

