/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.james.jspf.core.IPAddr;
import org.apache.james.jspf.core.MacroData;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.exceptions.PermErrorException;

public class SPFSession
implements MacroData {
    private String ipAddress = "";
    private String mailFrom = "";
    private String hostName = "";
    private String currentSenderPart = "";
    private String currentDomain = "";
    private String inAddress = "in-addr";
    private String clientDomain = null;
    private String senderDomain = "";
    private String readableIP = null;
    private String receivingDomain = null;
    private int currentDepth = 0;
    public static final int MAX_DEPTH = 10;
    private String explanation = null;
    private String currentResult = null;
    private boolean ignoreExplanation = false;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Stack<SPFChecker> checkers = new Stack();
    private String currentResultExpanded;

    public SPFSession(String mailFrom, String heloDomain, String clientIP) {
        this.mailFrom = mailFrom.trim();
        this.hostName = heloDomain.trim();
        try {
            this.ipAddress = IPAddr.getProperIpAddress(clientIP.trim());
            this.inAddress = IPAddr.getInAddress(clientIP);
        }
        catch (PermErrorException e) {
            this.setCurrentResultExpanded(e.getResult());
        }
        if (mailFrom.equals("")) {
            this.currentSenderPart = "postmaster";
            this.senderDomain = this.hostName;
            this.mailFrom = this.currentSenderPart + "@" + this.hostName;
        } else {
            String[] fromParts = mailFrom.split("@");
            if (fromParts.length > 1) {
                this.senderDomain = fromParts[fromParts.length - 1];
                this.currentSenderPart = mailFrom.substring(0, mailFrom.length() - this.senderDomain.length() - 1);
                if (this.currentSenderPart.length() == 0) {
                    this.currentSenderPart = "postmaster";
                }
            } else {
                this.currentSenderPart = "postmaster";
                this.senderDomain = mailFrom;
            }
        }
        this.currentDomain = this.senderDomain;
    }

    public String getCurrentSenderPart() {
        return this.currentSenderPart;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getCurrentDomain() {
        return this.currentDomain;
    }

    public String getInAddress() {
        return this.inAddress;
    }

    public String getClientDomain() {
        return this.clientDomain;
    }

    public void setClientDomain(String clientDomain) {
        this.clientDomain = clientDomain;
    }

    public String getSenderDomain() {
        return this.senderDomain;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getMacroIpAddress() {
        if (IPAddr.isIPV6(this.ipAddress)) {
            try {
                return IPAddr.getAddress(this.ipAddress).getNibbleFormat();
            }
            catch (PermErrorException permErrorException) {
                // empty catch block
            }
        }
        return this.ipAddress;
    }

    public long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public String getReadableIP() {
        if (this.readableIP == null) {
            this.readableIP = IPAddr.getReadableIP(this.ipAddress);
        }
        return this.readableIP;
    }

    public String getReceivingDomain() {
        return this.receivingDomain;
    }

    public void setReceivingDomain(String receivingDomain) {
        this.receivingDomain = receivingDomain;
    }

    public void increaseCurrentDepth() throws PermErrorException {
        ++this.currentDepth;
        if (this.currentDepth > 10) {
            throw new PermErrorException("Maximum mechanism/modifiers calls done: " + this.currentDepth);
        }
    }

    public void setCurrentDomain(String domain) {
        this.currentDomain = domain;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setCurrentResult(String result) {
        this.currentResult = result;
    }

    public String getCurrentResult() {
        return this.currentResult;
    }

    public void setIgnoreExplanation(boolean ignoreExplanation) {
        this.ignoreExplanation = ignoreExplanation;
    }

    public boolean ignoreExplanation() {
        return this.ignoreExplanation;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public void pushChecker(SPFChecker checker) {
        this.checkers.push(checker);
    }

    public SPFChecker popChecker() {
        if (this.checkers.isEmpty()) {
            return null;
        }
        SPFChecker checker = this.checkers.pop();
        return checker;
    }

    public void setCurrentResultExpanded(String result) {
        this.currentResultExpanded = result;
    }

    public String getCurrentResultExpanded() {
        return this.currentResultExpanded;
    }
}

