/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.spamassassin;

import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.mailbox.spamassassin.SpamAssassinConfiguration;
import org.apache.james.util.Host;

public class SpamAssassinConfigurationLoader {
    private static final String SPAMASSASSIN_HOST = "spamassassin.host";
    private static final String SPAMASSASSIN_PORT = "spamassassin.port";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 783;

    public static SpamAssassinConfiguration disable() {
        return new SpamAssassinConfiguration(Optional.empty());
    }

    public static SpamAssassinConfiguration fromProperties(Configuration configuration) {
        Host host = SpamAssassinConfigurationLoader.getHost(configuration);
        return new SpamAssassinConfiguration(Optional.of(host));
    }

    private static Host getHost(Configuration propertiesReader) {
        return Host.from((String)propertiesReader.getString(SPAMASSASSIN_HOST, DEFAULT_HOST), (int)propertiesReader.getInteger(SPAMASSASSIN_PORT, Integer.valueOf(783)));
    }
}

