/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersTask;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;

public class RecomputeMailboxCountersTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final long processedMailboxes;
    private final ImmutableList<String> failedMailboxes;
    private final Instant timestamp;

    private static RecomputeMailboxCountersTaskAdditionalInformationDTO fromDomainObject(RecomputeMailboxCountersTask.Details details, String type) {
        return new RecomputeMailboxCountersTaskAdditionalInformationDTO(type, details.getProcessedMailboxes(), details.getFailedMailboxes(), details.timestamp());
    }

    public static final AdditionalInformationDTOModule<RecomputeMailboxCountersTask.Details, RecomputeMailboxCountersTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(RecomputeMailboxCountersTask.Details.class).convertToDTO(RecomputeMailboxCountersTaskAdditionalInformationDTO.class).toDomainObjectConverter(RecomputeMailboxCountersTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(RecomputeMailboxCountersTaskAdditionalInformationDTO::fromDomainObject).typeName(RecomputeMailboxCountersTask.RECOMPUTE_MAILBOX_COUNTERS.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public RecomputeMailboxCountersTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="processedMailboxes") long processedMailboxes, @JsonProperty(value="failedMailboxes") ImmutableList<String> failedMailboxes, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.processedMailboxes = processedMailboxes;
        this.failedMailboxes = failedMailboxes;
        this.timestamp = timestamp;
    }

    public long getProcessedMailboxes() {
        return this.processedMailboxes;
    }

    public ImmutableList<String> getFailedMailboxes() {
        return this.failedMailboxes;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    private RecomputeMailboxCountersTask.Details toDomainObject() {
        return new RecomputeMailboxCountersTask.Details(this.timestamp, this.processedMailboxes, this.failedMailboxes);
    }
}

