/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeAuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeAuthUtils.class);

    private DataNodeAuthUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getPasswordChangeTimeMillis(String username, String password) {
        long queryId = -1L;
        try {
            Statement statement = StatementGenerator.createStatement("SELECT password from root.__system.password_history.`_" + username + "` where oldPassword='" + AuthUtils.encryptPassword((String)password) + "' order by time desc limit 1", ZoneId.systemDefault());
            SessionInfo sessionInfo = new SessionInfo(0L, AuthorityChecker.SUPER_USER, ZoneId.systemDefault());
            queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().executeForTreeModel(statement, queryId, sessionInfo, "", ClusterPartitionFetcher.getInstance(), ClusterSchemaFetcher.getInstance());
            if (result.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Fail to get password change time: {}", (Object)result.status);
                long l = -1L;
                return l;
            }
            IQueryExecution queryExecution = Coordinator.getInstance().getQueryExecution(queryId);
            Optional<TsBlock> batchResult = queryExecution.getBatchResult();
            TsBlock lastTsBlock = batchResult.orElse(null);
            if (lastTsBlock != null) {
                if (lastTsBlock.getPositionCount() <= 0) {
                    long l = -1L;
                    return l;
                }
                long timeByIndex = lastTsBlock.getTimeByIndex(lastTsBlock.getPositionCount() - 1);
                long l = CommonDateTimeUtils.convertIoTDBTimeToMillis((long)timeByIndex);
                return l;
            }
        }
        catch (IoTDBException e) {
            LOGGER.warn("Cannot generate query for checking password reuse interval", (Throwable)e);
        }
        finally {
            if (queryId != -1L) {
                Coordinator.getInstance().cleanupQueryExecution(queryId);
            }
        }
        return -1L;
    }

    public static void verifyPasswordReuse(String username, String password) {
        long reuseIntervalMillis;
        long passwordReuseIntervalDays = CommonDescriptor.getInstance().getConfig().getPasswordReuseIntervalDays();
        if (password == null || passwordReuseIntervalDays <= 0L) {
            return;
        }
        long passwordChangeTime = DataNodeAuthUtils.getPasswordChangeTimeMillis(username, password);
        long currentTimeMillis = System.currentTimeMillis();
        long elapsedTime = currentTimeMillis - passwordChangeTime;
        long l = reuseIntervalMillis = passwordReuseIntervalDays * 1000L * 86400L > 0L ? passwordReuseIntervalDays * 1000L * 86400L : Long.MAX_VALUE;
        if (elapsedTime <= reuseIntervalMillis) {
            throw new SemanticException(String.format("The password has been used recently, and it cannot be reused before %s", new Date(passwordChangeTime + reuseIntervalMillis)));
        }
        LOGGER.info("It has been {}ms, since the password was changed {} -> {}", new Object[]{elapsedTime, passwordChangeTime, currentTimeMillis});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TSStatus recordPassword(String username, String password, String oldPassword, long timeToRecord) {
        InsertRowStatement insertRowStatement = new InsertRowStatement();
        try {
            insertRowStatement.setDevicePath(new PartialPath("root.__system.password_history.`_" + username + "`"));
            insertRowStatement.setTime(CommonDateTimeUtils.currentTime());
            insertRowStatement.setMeasurements(new String[]{"password", "oldPassword"});
            insertRowStatement.setValues(new Object[]{new Binary(AuthUtils.encryptPassword((String)password), StandardCharsets.UTF_8), oldPassword == null ? null : new Binary(oldPassword, StandardCharsets.UTF_8)});
            insertRowStatement.setDataTypes(new TSDataType[]{TSDataType.STRING, TSDataType.STRING});
        }
        catch (IllegalPathException ignored) {
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()).setMessage("Cannot create password history for " + username + " because the path will be illegal");
        }
        long queryId = -1L;
        try {
            SessionInfo sessionInfo = new SessionInfo(0L, AuthorityChecker.SUPER_USER, ZoneId.systemDefault());
            queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().executeForTreeModel(insertRowStatement, queryId, sessionInfo, "", ClusterPartitionFetcher.getInstance(), ClusterSchemaFetcher.getInstance());
            TSStatus tSStatus = result.status;
            return tSStatus;
        }
        catch (Exception e) {
            if (CommonDescriptor.getInstance().getConfig().isMayBypassPasswordCheckInException()) {
                TSStatus tSStatus = StatusUtils.OK;
                return tSStatus;
            }
            LOGGER.error("Cannot create password history for {} because {}", (Object)username, (Object)e.getMessage());
            TSStatus tSStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()).setMessage("The server is not ready for login, please check the server log for details");
            return tSStatus;
        }
        finally {
            if (queryId != -1L) {
                Coordinator.getInstance().cleanupQueryExecution(queryId);
            }
        }
    }
}

