/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.parser;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.cache.CacheClearOptions;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinScalarFunction;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AddColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AliasedRelation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AllColumns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AllRows;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AnchorPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AsofJoinOn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ClearCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ColumnDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Columns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CountDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CountStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateIndex;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateModel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTraining;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateView;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentTime;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataTypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DeleteDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DescribeTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropIndex;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropModel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropSubscription;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.EmptyPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Except;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExcludedPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Explain;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExplainAnalyze;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExtendRegion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Extract;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Fill;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Flush;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FrameBound;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericDataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupingElement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupingSets;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Insert;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertRows;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Intersect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Join;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinCriteria;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinOn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinUsing;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.KillQuery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Limit;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadConfiguration;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadModel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.MeasureDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.MigrateRegion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NaturalJoin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NumericParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OneOrMoreQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternAlternation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternConcatenation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternPermutation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternRecognitionRelation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternVariable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ProcessingMode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QueryBody;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuerySpecification;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RangeQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ReconstructRegion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RelationalAuthorStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RemoveAINode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RemoveConfigNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RemoveDataNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RemoveRegion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Select;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SelectItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetColumnComment;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetConfiguration;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetProperties;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetSqlDialect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetSystemStatus;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetTableComment;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowAIDevices;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowAINodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCluster;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowClusterId;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowConfigNodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentSqlDialect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentTimestamp;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDataNodes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowFunctions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowIndex;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowLoadedModels;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowModels;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipePlugins;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowQueriesStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowRegions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowSubscriptions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTopics;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowVariables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowVersion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleGroupBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SingleColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SkipTo;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SortItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StartPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StartRepairData;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StopPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StopRepairData;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubsetDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableFunctionArgument;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableFunctionInvocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableFunctionTableArgument;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableSubquery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Union;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.UnloadModel;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Update;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.UpdateAssignment;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Use;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Values;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.VariableDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ViewFieldDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Window;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowFrame;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowSpecification;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.With;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WithQuery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ZeroOrMoreQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ZeroOrOneQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.ParsingException;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.AstUtil;
import org.apache.iotdb.db.queryengine.plan.relational.type.AuthorRType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.FlushStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.LoadConfigurationStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.SetConfigurationStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.SetSystemStatusStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.StartRepairDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.StopRepairDataStatement;
import org.apache.iotdb.db.relational.grammar.sql.RelationalSqlBaseVisitor;
import org.apache.iotdb.db.relational.grammar.sql.RelationalSqlParser;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.storageengine.load.config.LoadTsFileConfigurator;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.TimeDuration;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class AstBuilder
extends RelationalSqlBaseVisitor<Node> {
    private int parameterPosition;
    @Nullable
    private final NodeLocation baseLocation;
    private final ZoneId zoneId;
    private final IClientSession clientSession;

    AstBuilder(@Nullable NodeLocation baseLocation, ZoneId zoneId, IClientSession clientSession) {
        this.baseLocation = baseLocation;
        this.zoneId = zoneId;
        this.clientSession = clientSession;
    }

    public Node visitSingleStatement(RelationalSqlParser.SingleStatementContext ctx) {
        return (Node)this.visit((ParseTree)ctx.statement());
    }

    public Node visitStandaloneExpression(RelationalSqlParser.StandaloneExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    public Node visitStandaloneType(RelationalSqlParser.StandaloneTypeContext context) {
        return (Node)this.visit((ParseTree)context.type());
    }

    public Node visitStandaloneRowPattern(RelationalSqlParser.StandaloneRowPatternContext context) {
        return (Node)this.visit((ParseTree)context.rowPattern());
    }

    public Node visitUseDatabaseStatement(RelationalSqlParser.UseDatabaseStatementContext ctx) {
        return new Use(this.getLocation((ParserRuleContext)ctx), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.database)));
    }

    public static Identifier lowerIdentifier(Identifier identifier) {
        if (identifier.getLocation().isPresent()) {
            return new Identifier(identifier.getLocation().get(), QualifiedName.mapIdentifier(identifier), identifier.isDelimited());
        }
        return new Identifier(QualifiedName.mapIdentifier(identifier), identifier.isDelimited());
    }

    public Node visitShowDatabasesStatement(RelationalSqlParser.ShowDatabasesStatementContext ctx) {
        return new ShowDB(this.getLocation((ParserRuleContext)ctx), Objects.nonNull(ctx.DETAILS()));
    }

    public Node visitCreateDbStatement(RelationalSqlParser.CreateDbStatementContext ctx) {
        Object properties = ImmutableList.of();
        if (ctx.properties() != null) {
            properties = this.visit(ctx.properties().propertyAssignments().property(), Property.class);
        }
        return new CreateDB(this.getLocation((ParserRuleContext)ctx), ctx.EXISTS() != null, ((Identifier)this.visit((ParseTree)ctx.database)).getValue(), (List<Property>)properties);
    }

    public Node visitAlterDbStatement(RelationalSqlParser.AlterDbStatementContext ctx) {
        Object properties = ImmutableList.of();
        if (ctx.propertyAssignments() != null) {
            properties = this.visit(ctx.propertyAssignments().property(), Property.class);
        }
        return new AlterDB(this.getLocation((ParserRuleContext)ctx), ctx.EXISTS() != null, ((Identifier)this.visit((ParseTree)ctx.database)).getValue(), (List<Property>)properties);
    }

    public Node visitDropDbStatement(RelationalSqlParser.DropDbStatementContext ctx) {
        return new DropDB(this.getLocation((ParserRuleContext)ctx), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.database)), ctx.EXISTS() != null);
    }

    public Node visitCreateTableStatement(RelationalSqlParser.CreateTableStatementContext ctx) {
        Object properties = ImmutableList.of();
        if (ctx.properties() != null) {
            properties = this.visit(ctx.properties().propertyAssignments().property(), Property.class);
        }
        return new CreateTable(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), this.visit(ctx.columnDefinition(), ColumnDefinition.class), ctx.EXISTS() != null, ctx.charsetDesc() == null ? null : ((Identifier)this.visit((ParseTree)ctx.charsetDesc().identifierOrString())).getValue(), ctx.comment() == null ? null : ((StringLiteral)this.visit((ParseTree)ctx.comment().string())).getValue(), (List<Property>)properties);
    }

    public Node visitColumnDefinition(RelationalSqlParser.ColumnDefinitionContext ctx) {
        return new ColumnDefinition(this.getLocation((ParserRuleContext)ctx), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.identifier())), Objects.nonNull(ctx.type()) ? (DataType)this.visit((ParseTree)ctx.type()) : null, AstBuilder.getColumnCategory(ctx.columnCategory), ctx.charsetName() == null ? null : ((Identifier)this.visit((ParseTree)ctx.charsetName().identifier())).getValue(), ctx.comment() == null ? null : ((StringLiteral)this.visit((ParseTree)ctx.comment().string())).getValue());
    }

    public Node visitDropTableStatement(RelationalSqlParser.DropTableStatementContext ctx) {
        return new DropTable(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), ctx.EXISTS() != null, false);
    }

    public Node visitShowTableStatement(RelationalSqlParser.ShowTableStatementContext ctx) {
        return Objects.nonNull(ctx.database) ? new ShowTables(this.getLocation((ParserRuleContext)ctx), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.database)), Objects.nonNull(ctx.DETAILS())) : new ShowTables(this.getLocation((ParserRuleContext)ctx), Objects.nonNull(ctx.DETAILS()));
    }

    public Node visitDescTableStatement(RelationalSqlParser.DescTableStatementContext ctx) {
        return new DescribeTable(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.table), Objects.nonNull(ctx.DETAILS()), null);
    }

    public Node visitRenameTable(RelationalSqlParser.RenameTableContext ctx) {
        return new RenameTable(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.from), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.to)), Objects.nonNull(ctx.EXISTS()), false);
    }

    public Node visitAddColumn(RelationalSqlParser.AddColumnContext ctx) {
        return new AddColumn(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.tableName), (ColumnDefinition)this.visit((ParseTree)ctx.column), ctx.EXISTS().size() == (Objects.nonNull(ctx.NOT()) ? 2 : 1), Objects.nonNull(ctx.NOT()), false);
    }

    public Node visitRenameColumn(RelationalSqlParser.RenameColumnContext ctx) {
        return new RenameColumn(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.tableName), (Identifier)this.visit((ParseTree)ctx.from), (Identifier)this.visit((ParseTree)ctx.to), ctx.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() < ctx.COLUMN().getSymbol().getTokenIndex()), ctx.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() > ctx.COLUMN().getSymbol().getTokenIndex()), false);
    }

    public Node visitDropColumn(RelationalSqlParser.DropColumnContext ctx) {
        return new DropColumn(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.tableName), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.column)), ctx.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() < ctx.COLUMN().getSymbol().getTokenIndex()), ctx.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() > ctx.COLUMN().getSymbol().getTokenIndex()), false);
    }

    public Node visitSetTableProperties(RelationalSqlParser.SetTablePropertiesContext ctx) {
        Object properties = ImmutableList.of();
        if (ctx.propertyAssignments() != null) {
            properties = this.visit(ctx.propertyAssignments().property(), Property.class);
        }
        return new SetProperties(this.getLocation((ParserRuleContext)ctx), SetProperties.Type.TABLE, this.getQualifiedName(ctx.qualifiedName()), (List<Property>)properties, Objects.nonNull(ctx.EXISTS()));
    }

    public Node visitShowCreateTableStatement(RelationalSqlParser.ShowCreateTableStatementContext ctx) {
        return new DescribeTable(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), false, Boolean.FALSE);
    }

    public Node visitCommentTable(RelationalSqlParser.CommentTableContext ctx) {
        return new SetTableComment(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), false, Objects.nonNull(ctx.string()) ? ((StringLiteral)this.visit((ParseTree)ctx.string())).getValue() : null, false);
    }

    public Node visitCommentView(RelationalSqlParser.CommentViewContext ctx) {
        return new SetTableComment(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), false, Objects.nonNull(ctx.string()) ? ((StringLiteral)this.visit((ParseTree)ctx.string())).getValue() : null, true);
    }

    public Node visitCommentColumn(RelationalSqlParser.CommentColumnContext ctx) {
        return new SetColumnComment(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.column)), false, false, Objects.nonNull(ctx.string()) ? ((StringLiteral)this.visit((ParseTree)ctx.string())).getValue() : null);
    }

    public Node visitCreateViewStatement(RelationalSqlParser.CreateViewStatementContext ctx) {
        Object properties = ImmutableList.of();
        if (ctx.properties() != null) {
            properties = this.visit(ctx.properties().propertyAssignments().property(), Property.class);
        }
        return new CreateView(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), this.visit(ctx.viewColumnDefinition(), ColumnDefinition.class), null, ctx.comment() == null ? null : ((StringLiteral)this.visit((ParseTree)ctx.comment().string())).getValue(), (List<Property>)properties, this.parsePrefixPath(ctx.prefixPath()), Objects.nonNull(ctx.REPLACE()), Objects.nonNull(ctx.RESTRICT()));
    }

    public Node visitRenameTableView(RelationalSqlParser.RenameTableViewContext ctx) {
        return new RenameTable(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.from), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.to)), Objects.nonNull(ctx.EXISTS()), true);
    }

    public Node visitAddViewColumn(RelationalSqlParser.AddViewColumnContext ctx) {
        return new AddColumn(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.viewName), (ColumnDefinition)this.visit((ParseTree)ctx.viewColumnDefinition()), ctx.EXISTS().size() == (Objects.nonNull(ctx.NOT()) ? 2 : 1), Objects.nonNull(ctx.NOT()), true);
    }

    public Node visitRenameViewColumn(RelationalSqlParser.RenameViewColumnContext ctx) {
        return new RenameColumn(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.viewName), (Identifier)this.visit((ParseTree)ctx.from), (Identifier)this.visit((ParseTree)ctx.to), ctx.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() < ctx.COLUMN().getSymbol().getTokenIndex()), ctx.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() > ctx.COLUMN().getSymbol().getTokenIndex()), true);
    }

    public Node visitDropViewColumn(RelationalSqlParser.DropViewColumnContext ctx) {
        return new DropColumn(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.viewName), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.column)), ctx.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() < ctx.COLUMN().getSymbol().getTokenIndex()), ctx.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() > ctx.COLUMN().getSymbol().getTokenIndex()), true);
    }

    public Node visitSetTableViewProperties(RelationalSqlParser.SetTableViewPropertiesContext ctx) {
        Object properties = ImmutableList.of();
        if (ctx.propertyAssignments() != null) {
            properties = this.visit(ctx.propertyAssignments().property(), Property.class);
        }
        return new SetProperties(this.getLocation((ParserRuleContext)ctx), SetProperties.Type.TREE_VIEW, this.getQualifiedName(ctx.qualifiedName()), (List<Property>)properties, Objects.nonNull(ctx.EXISTS()));
    }

    public Node visitViewColumnDefinition(RelationalSqlParser.ViewColumnDefinitionContext ctx) {
        Identifier rawColumnName = (Identifier)this.visit((ParseTree)ctx.identifier().get(0));
        Identifier columnName = AstBuilder.lowerIdentifier(rawColumnName);
        TsTableColumnCategory columnCategory = AstBuilder.getColumnCategory(ctx.columnCategory);
        Identifier originalMeasurement = null;
        if (Objects.nonNull(ctx.FROM())) {
            originalMeasurement = (Identifier)this.visit((ParseTree)ctx.original_measurement);
        } else if (columnCategory == TsTableColumnCategory.FIELD && !columnName.equals(rawColumnName)) {
            originalMeasurement = rawColumnName;
        }
        return columnCategory == TsTableColumnCategory.FIELD ? new ViewFieldDefinition(this.getLocation((ParserRuleContext)ctx), columnName, Objects.nonNull(ctx.type()) ? (DataType)this.visit((ParseTree)ctx.type()) : null, null, ctx.comment() == null ? null : ((StringLiteral)this.visit((ParseTree)ctx.comment().string())).getValue(), originalMeasurement) : new ColumnDefinition(this.getLocation((ParserRuleContext)ctx), columnName, Objects.nonNull(ctx.type()) ? (DataType)this.visit((ParseTree)ctx.type()) : null, columnCategory, null, ctx.comment() == null ? null : ((StringLiteral)this.visit((ParseTree)ctx.comment().string())).getValue());
    }

    private PartialPath parsePrefixPath(RelationalSqlParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = ASTVisitor.parseNodeString(((RelationalSqlParser.NodeNameContext)nodeNames.get(i)).nodeNameWithoutWildcard() != null ? ((Identifier)this.visit((ParseTree)((RelationalSqlParser.NodeNameContext)nodeNames.get(i)).nodeNameWithoutWildcard().identifier())).getValue() : ((RelationalSqlParser.NodeNameContext)nodeNames.get(i)).getText());
        }
        return new PartialPath(path);
    }

    public Node visitDropViewStatement(RelationalSqlParser.DropViewStatementContext ctx) {
        return new DropTable(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), ctx.EXISTS() != null, true);
    }

    public Node visitShowCreateViewStatement(RelationalSqlParser.ShowCreateViewStatementContext ctx) {
        return new DescribeTable(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()), false, Boolean.TRUE);
    }

    public Node visitCreateIndexStatement(RelationalSqlParser.CreateIndexStatementContext ctx) {
        return new CreateIndex(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.tableName), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.indexName)), this.visit(ctx.identifierList().identifier(), Identifier.class));
    }

    public Node visitDropIndexStatement(RelationalSqlParser.DropIndexStatementContext ctx) {
        return new DropIndex(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.tableName), AstBuilder.lowerIdentifier((Identifier)this.visit((ParseTree)ctx.indexName)));
    }

    public Node visitShowIndexStatement(RelationalSqlParser.ShowIndexStatementContext ctx) {
        return new ShowIndex(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.tableName));
    }

    public Node visitInsertStatement(RelationalSqlParser.InsertStatementContext ctx) {
        QualifiedName qualifiedName = this.getQualifiedName(ctx.tableName);
        String tableName = qualifiedName.getSuffix();
        String databaseName = qualifiedName.getPrefix().map(QualifiedName::toString).orElse(this.clientSession.getDatabaseName());
        if (databaseName == null) {
            throw new SemanticException("database is not specified");
        }
        tableName = tableName.toLowerCase();
        databaseName = databaseName.toLowerCase();
        Query query = (Query)this.visit((ParseTree)ctx.query());
        if (ctx.columnAliases() != null) {
            List<Identifier> identifiers = this.visit(ctx.columnAliases().identifier(), Identifier.class);
            if (query.getQueryBody() instanceof Values) {
                return this.visitInsertValues(databaseName, tableName, identifiers, (Values)query.getQueryBody());
            }
            return new Insert(new Table(qualifiedName), identifiers, query);
        }
        return query.getQueryBody() instanceof Values ? this.visitInsertValues(databaseName, DataNodeTableCache.getInstance().getTable(databaseName, tableName), (Values)query.getQueryBody()) : new Insert(new Table(qualifiedName), query);
    }

    private Node visitInsertValues(String databaseName, TsTable table, Values queryBody) {
        List<Expression> rows = queryBody.getRows();
        List<InsertRowStatement> rowStatements = rows.stream().map(r -> {
            List<Expression> expressions;
            if (r instanceof Row) {
                expressions = ((Row)r).getItems();
            } else if (r instanceof Literal) {
                expressions = Collections.singletonList(r);
            } else {
                throw new SemanticException("unexpected expression: " + r);
            }
            return this.toInsertRowStatement(expressions, table, databaseName);
        }).collect(Collectors.toList());
        InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
        insertRowsStatement.setInsertRowStatementList(rowStatements);
        insertRowsStatement.setWriteToTable(true);
        return new InsertRows(insertRowsStatement, null);
    }

    private Node visitInsertValues(String databaseName, String tableName, List<Identifier> identifiers, Values queryBody) {
        List columnNames = identifiers.stream().map(Identifier::getValue).collect(Collectors.toList());
        int timeColumnIndex = -1;
        for (int i = 0; i < columnNames.size(); ++i) {
            if (!"time".equalsIgnoreCase((String)columnNames.get(i))) continue;
            if (timeColumnIndex == -1) {
                timeColumnIndex = i;
                continue;
            }
            throw new SemanticException("One row should only have one time value");
        }
        if (timeColumnIndex != -1) {
            columnNames.remove(timeColumnIndex);
        }
        List<Expression> rows = queryBody.getRows();
        if (timeColumnIndex == -1 && rows.size() > 1) {
            throw new SemanticException("need timestamps when insert multi rows");
        }
        int finalTimeColumnIndex = timeColumnIndex;
        List<InsertRowStatement> rowStatements = rows.stream().map(r -> {
            List<Expression> expressions;
            if (r instanceof Row) {
                expressions = ((Row)r).getItems();
            } else if (r instanceof Literal) {
                expressions = Collections.singletonList(r);
            } else {
                throw new SemanticException("unexpected expression: " + r);
            }
            String[] columnNameArray = columnNames.toArray(new String[0]);
            return this.toInsertRowStatement(expressions, finalTimeColumnIndex, columnNameArray, tableName, databaseName, columnNames.size());
        }).collect(Collectors.toList());
        InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
        insertRowsStatement.setInsertRowStatementList(rowStatements);
        insertRowsStatement.setWriteToTable(true);
        return new InsertRows(insertRowsStatement, null);
    }

    private InsertRowStatement toInsertRowStatement(List<Expression> expressions, TsTable table, String databaseName) {
        InsertRowStatement insertRowStatement = new InsertRowStatement();
        insertRowStatement.setWriteToTable(true);
        insertRowStatement.setDevicePath(new PartialPath(new String[]{table.getTableName()}));
        List columnList = table.getColumnList();
        if (expressions.size() != columnList.size()) {
            throw new SemanticException("expressions and columns do not match, expressions size: " + expressions.size() + ", columns size: " + columnList.size());
        }
        String[] nonTimeColumnNames = new String[columnList.size() - 1];
        Object[] nonTimeValues = new Object[columnList.size() - 1];
        TsTableColumnCategory[] nonTimeColumnCategories = new TsTableColumnCategory[columnList.size() - 1];
        MeasurementSchema[] columnSchemas = new MeasurementSchema[columnList.size() - 1];
        TSDataType[] dataTypes = new TSDataType[columnList.size() - 1];
        int nonTimeColumnIndex = 0;
        long timestamp = -1L;
        for (int i = 0; i < columnList.size(); ++i) {
            Object value;
            TsTableColumnSchema columnSchema = (TsTableColumnSchema)columnList.get(i);
            Expression expression = expressions.get(i);
            if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TIME)) {
                timestamp = AstUtil.expressionToTimestamp(expression, this.zoneId);
                continue;
            }
            nonTimeValues[nonTimeColumnIndex] = value = AstUtil.expressionToTsValue(expression);
            nonTimeColumnNames[nonTimeColumnIndex] = columnSchema.getColumnName();
            dataTypes[nonTimeColumnIndex] = columnSchema.getDataType();
            nonTimeColumnCategories[nonTimeColumnIndex] = columnSchema.getColumnCategory();
            columnSchemas[nonTimeColumnIndex] = new MeasurementSchema(columnSchema.getColumnName(), columnSchema.getDataType());
            ++nonTimeColumnIndex;
        }
        TimestampPrecisionUtils.checkTimestampPrecision(timestamp);
        insertRowStatement.setTime(timestamp);
        insertRowStatement.setMeasurements(nonTimeColumnNames);
        insertRowStatement.setDataTypes(dataTypes);
        insertRowStatement.setMeasurementSchemas(columnSchemas);
        insertRowStatement.setValues(nonTimeValues);
        insertRowStatement.setColumnCategories(nonTimeColumnCategories);
        insertRowStatement.setNeedInferType(false);
        insertRowStatement.setDatabaseName(databaseName);
        try {
            insertRowStatement.transferType(this.zoneId);
        }
        catch (QueryProcessException e) {
            throw new SemanticException((Throwable)((Object)e));
        }
        return insertRowStatement;
    }

    private InsertRowStatement toInsertRowStatement(List<Expression> expressions, int timeColumnIndex, String[] nonTimeColumnNames, String tableName, String databaseName, int columnSize) {
        int nonTimeColCnt;
        long timestamp;
        InsertRowStatement insertRowStatement = new InsertRowStatement();
        insertRowStatement.setWriteToTable(true);
        insertRowStatement.setDevicePath(new PartialPath(new String[]{tableName}));
        if (timeColumnIndex == -1) {
            timestamp = CommonDateTimeUtils.currentTime();
            nonTimeColCnt = expressions.size();
        } else {
            if (timeColumnIndex >= expressions.size()) {
                throw new SemanticException(String.format("TimeColumnIndex out of bound: %d-%d", timeColumnIndex, expressions.size()));
            }
            Expression timeExpression = expressions.get(timeColumnIndex);
            timestamp = timeExpression instanceof LongLiteral ? ((LongLiteral)timeExpression).getParsedValue() : ASTVisitor.parseDateTimeFormat(((StringLiteral)timeExpression).getValue(), CommonDateTimeUtils.currentTime(), this.zoneId);
            nonTimeColCnt = expressions.size() - 1;
        }
        if (nonTimeColCnt != nonTimeColumnNames.length) {
            throw new SemanticException(String.format("Inconsistent numbers of non-time column names and values: %d-%d", nonTimeColumnNames.length, nonTimeColCnt));
        }
        TimestampPrecisionUtils.checkTimestampPrecision(timestamp);
        insertRowStatement.setTime(timestamp);
        insertRowStatement.setMeasurements(nonTimeColumnNames);
        Object[] values = new Object[nonTimeColumnNames.length];
        int valuePos = 0;
        for (int i = 0; i < expressions.size(); ++i) {
            if (i == timeColumnIndex) continue;
            values[valuePos++] = AstUtil.expressionToTsValue(expressions.get(i));
        }
        insertRowStatement.setValues(values);
        insertRowStatement.setNeedInferType(true);
        insertRowStatement.setDatabaseName(databaseName);
        return insertRowStatement;
    }

    public Node visitDeleteStatement(RelationalSqlParser.DeleteStatementContext ctx) {
        if (ctx.booleanExpression() != null) {
            return new Delete(this.getLocation((ParserRuleContext)ctx), new Table(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.tableName)), (Expression)this.visit((ParseTree)ctx.booleanExpression()));
        }
        return new Delete(this.getLocation((ParserRuleContext)ctx), new Table(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.tableName)));
    }

    public Node visitUpdateStatement(RelationalSqlParser.UpdateStatementContext ctx) {
        return new Update(this.getLocation((ParserRuleContext)ctx), new Table(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName())), this.visit(ctx.updateAssignment(), UpdateAssignment.class), Objects.nonNull(ctx.booleanExpression()) ? (Expression)this.visit((ParseTree)ctx.booleanExpression()) : null);
    }

    public Node visitDeleteDeviceStatement(RelationalSqlParser.DeleteDeviceStatementContext ctx) {
        return new DeleteDevice(this.getLocation((ParserRuleContext)ctx), new Table(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName())), Objects.nonNull(ctx.booleanExpression()) ? (Expression)this.visit((ParseTree)ctx.booleanExpression()) : null);
    }

    public Node visitUpdateAssignment(RelationalSqlParser.UpdateAssignmentContext ctx) {
        return new UpdateAssignment((Identifier)this.visit((ParseTree)ctx.identifier()), (Expression)this.visit((ParseTree)ctx.expression()));
    }

    public Node visitCreateFunctionStatement(RelationalSqlParser.CreateFunctionStatementContext ctx) {
        String udfName = ((Identifier)this.visit((ParseTree)ctx.udfName)).getValue();
        String className = ((Identifier)this.visit((ParseTree)ctx.className)).getValue();
        if (ctx.uriClause() == null) {
            return new CreateFunction(this.getLocation((ParserRuleContext)ctx), udfName, className);
        }
        String uriString = this.parseAndValidateURI(ctx.uriClause());
        return new CreateFunction(this.getLocation((ParserRuleContext)ctx), udfName, className, uriString);
    }

    public Node visitUriClause(RelationalSqlParser.UriClauseContext ctx) {
        return (Node)super.visitUriClause(ctx);
    }

    public Node visitDropFunctionStatement(RelationalSqlParser.DropFunctionStatementContext ctx) {
        String udfName = ((Identifier)this.visit((ParseTree)ctx.udfName)).getValue();
        return new DropFunction(this.getLocation((ParserRuleContext)ctx), udfName);
    }

    public Node visitShowFunctionsStatement(RelationalSqlParser.ShowFunctionsStatementContext ctx) {
        return new ShowFunctions();
    }

    public Node visitLoadTsFileStatement(RelationalSqlParser.LoadTsFileStatementContext ctx) {
        HashMap<String, String> withAttributes = ctx.loadFileWithAttributesClause() != null ? this.parseLoadFileWithAttributeClauses(ctx.loadFileWithAttributesClause().loadFileWithAttributeClause()) : new HashMap<String, String>();
        withAttributes.forEach(LoadTsFileConfigurator::validateParameters);
        LoadTsFileConfigurator.validateSynonymParameters(withAttributes);
        return new LoadTsFile(this.getLocation((ParserRuleContext)ctx), ((StringLiteral)this.visit((ParseTree)ctx.fileName)).getValue(), withAttributes);
    }

    private Map<String, String> parseLoadFileWithAttributeClauses(List<RelationalSqlParser.LoadFileWithAttributeClauseContext> contexts) {
        HashMap<String, String> withAttributesMap = new HashMap<String, String>();
        for (RelationalSqlParser.LoadFileWithAttributeClauseContext context : contexts) {
            withAttributesMap.put(((StringLiteral)this.visit((ParseTree)context.loadFileWithKey)).getValue(), ((StringLiteral)this.visit((ParseTree)context.loadFileWithValue)).getValue());
        }
        return withAttributesMap;
    }

    public Node visitCreatePipeStatement(RelationalSqlParser.CreatePipeStatementContext ctx) {
        String pipeName = ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue();
        boolean hasIfNotExistsCondition = ctx.IF() != null && ctx.NOT() != null && ctx.EXISTS() != null;
        HashMap<String, String> extractorAttributes = ctx.extractorAttributesClause() != null ? this.parseExtractorAttributesClause(ctx.extractorAttributesClause().extractorAttributeClause()) : new HashMap<String, String>();
        HashMap<String, String> processorAttributes = ctx.processorAttributesClause() != null ? this.parseProcessorAttributesClause(ctx.processorAttributesClause().processorAttributeClause()) : new HashMap<String, String>();
        Map<String, String> connectorAttributes = ctx.connectorAttributesClause() != null ? this.parseConnectorAttributesClause(ctx.connectorAttributesClause().connectorAttributeClause()) : this.parseConnectorAttributesClause(ctx.connectorAttributesWithoutWithSinkClause().connectorAttributeClause());
        return new CreatePipe(pipeName, hasIfNotExistsCondition, extractorAttributes, processorAttributes, connectorAttributes);
    }

    private Map<String, String> parseExtractorAttributesClause(List<RelationalSqlParser.ExtractorAttributeClauseContext> contexts) {
        HashMap<String, String> extractorMap = new HashMap<String, String>();
        for (RelationalSqlParser.ExtractorAttributeClauseContext context : contexts) {
            extractorMap.put(((StringLiteral)this.visit((ParseTree)context.extractorKey)).getValue(), ((StringLiteral)this.visit((ParseTree)context.extractorValue)).getValue());
        }
        return extractorMap;
    }

    private Map<String, String> parseProcessorAttributesClause(List<RelationalSqlParser.ProcessorAttributeClauseContext> contexts) {
        HashMap<String, String> processorMap = new HashMap<String, String>();
        for (RelationalSqlParser.ProcessorAttributeClauseContext context : contexts) {
            processorMap.put(((StringLiteral)this.visit((ParseTree)context.processorKey)).getValue(), ((StringLiteral)this.visit((ParseTree)context.processorValue)).getValue());
        }
        return processorMap;
    }

    private Map<String, String> parseConnectorAttributesClause(List<RelationalSqlParser.ConnectorAttributeClauseContext> contexts) {
        HashMap<String, String> connectorMap = new HashMap<String, String>();
        for (RelationalSqlParser.ConnectorAttributeClauseContext context : contexts) {
            connectorMap.put(((StringLiteral)this.visit((ParseTree)context.connectorKey)).getValue(), ((StringLiteral)this.visit((ParseTree)context.connectorValue)).getValue());
        }
        return connectorMap;
    }

    public Node visitAlterPipeStatement(RelationalSqlParser.AlterPipeStatementContext ctx) {
        boolean isReplaceAllConnectorAttributes;
        HashMap<String, String> connectorAttributes;
        boolean isReplaceAllProcessorAttributes;
        HashMap<String, String> processorAttributes;
        boolean isReplaceAllExtractorAttributes;
        HashMap<String, String> extractorAttributes;
        boolean hasIfExistsCondition;
        String pipeName = ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue();
        boolean bl = hasIfExistsCondition = ctx.IF() != null && ctx.EXISTS() != null;
        if (ctx.alterExtractorAttributesClause() != null) {
            extractorAttributes = this.parseExtractorAttributesClause(ctx.alterExtractorAttributesClause().extractorAttributeClause());
            isReplaceAllExtractorAttributes = Objects.nonNull(ctx.alterExtractorAttributesClause().REPLACE());
        } else {
            extractorAttributes = new HashMap();
            isReplaceAllExtractorAttributes = false;
        }
        if (ctx.alterProcessorAttributesClause() != null) {
            processorAttributes = this.parseProcessorAttributesClause(ctx.alterProcessorAttributesClause().processorAttributeClause());
            isReplaceAllProcessorAttributes = Objects.nonNull(ctx.alterProcessorAttributesClause().REPLACE());
        } else {
            processorAttributes = new HashMap();
            isReplaceAllProcessorAttributes = false;
        }
        if (ctx.alterConnectorAttributesClause() != null) {
            connectorAttributes = this.parseConnectorAttributesClause(ctx.alterConnectorAttributesClause().connectorAttributeClause());
            isReplaceAllConnectorAttributes = Objects.nonNull(ctx.alterConnectorAttributesClause().REPLACE());
        } else {
            connectorAttributes = new HashMap();
            isReplaceAllConnectorAttributes = false;
        }
        return new AlterPipe(pipeName, hasIfExistsCondition, extractorAttributes, processorAttributes, connectorAttributes, isReplaceAllExtractorAttributes, isReplaceAllProcessorAttributes, isReplaceAllConnectorAttributes);
    }

    public Node visitDropPipeStatement(RelationalSqlParser.DropPipeStatementContext ctx) {
        String pipeName = ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue();
        boolean hasIfExistsCondition = ctx.IF() != null && ctx.EXISTS() != null;
        return new DropPipe(pipeName, hasIfExistsCondition);
    }

    public Node visitStartPipeStatement(RelationalSqlParser.StartPipeStatementContext ctx) {
        return new StartPipe(((Identifier)this.visit((ParseTree)ctx.identifier())).getValue());
    }

    public Node visitStopPipeStatement(RelationalSqlParser.StopPipeStatementContext ctx) {
        return new StopPipe(((Identifier)this.visit((ParseTree)ctx.identifier())).getValue());
    }

    public Node visitShowPipesStatement(RelationalSqlParser.ShowPipesStatementContext ctx) {
        String pipeName = this.getIdentifierIfPresent((ParserRuleContext)ctx.identifier()).map(Identifier::getValue).orElse(null);
        boolean hasWhereClause = ctx.WHERE() != null;
        return new ShowPipes(pipeName, hasWhereClause);
    }

    public Node visitCreatePipePluginStatement(RelationalSqlParser.CreatePipePluginStatementContext ctx) {
        String pluginName = ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue();
        boolean hasIfNotExistsCondition = ctx.IF() != null && ctx.NOT() != null && ctx.EXISTS() != null;
        String className = ((StringLiteral)this.visit((ParseTree)ctx.className)).getValue();
        String uriString = this.parseAndValidateURI(ctx.uriClause());
        return new CreatePipePlugin(pluginName, hasIfNotExistsCondition, className, uriString);
    }

    private String parseAndValidateURI(RelationalSqlParser.UriClauseContext ctx) {
        String uriString = ctx.uri.identifier() != null ? ((Identifier)this.visit((ParseTree)ctx.uri.identifier())).getValue() : ((StringLiteral)this.visit((ParseTree)ctx.uri.string())).getValue();
        try {
            new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new SemanticException(String.format("Invalid URI: %s", uriString));
        }
        return uriString;
    }

    public Node visitDropPipePluginStatement(RelationalSqlParser.DropPipePluginStatementContext ctx) {
        String pluginName = ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue();
        boolean hasIfExistsCondition = ctx.IF() != null && ctx.EXISTS() != null;
        return new DropPipePlugin(pluginName, hasIfExistsCondition);
    }

    public Node visitShowPipePluginsStatement(RelationalSqlParser.ShowPipePluginsStatementContext ctx) {
        return new ShowPipePlugins();
    }

    public Node visitCreateTopicStatement(RelationalSqlParser.CreateTopicStatementContext ctx) {
        String topicName = ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue();
        boolean hasIfNotExistsCondition = ctx.IF() != null && ctx.NOT() != null && ctx.EXISTS() != null;
        HashMap<String, String> topicAttributes = ctx.topicAttributesClause() != null ? this.parseTopicAttributesClause(ctx.topicAttributesClause().topicAttributeClause()) : new HashMap<String, String>();
        return new CreateTopic(topicName, hasIfNotExistsCondition, topicAttributes);
    }

    private Map<String, String> parseTopicAttributesClause(List<RelationalSqlParser.TopicAttributeClauseContext> contexts) {
        HashMap<String, String> tppicMap = new HashMap<String, String>();
        for (RelationalSqlParser.TopicAttributeClauseContext context : contexts) {
            tppicMap.put(((StringLiteral)this.visit((ParseTree)context.topicKey)).getValue(), ((StringLiteral)this.visit((ParseTree)context.topicValue)).getValue());
        }
        return tppicMap;
    }

    public Node visitDropTopicStatement(RelationalSqlParser.DropTopicStatementContext ctx) {
        String topicName = ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue();
        boolean hasIfExistsCondition = ctx.IF() != null && ctx.EXISTS() != null;
        return new DropTopic(topicName, hasIfExistsCondition);
    }

    public Node visitShowTopicsStatement(RelationalSqlParser.ShowTopicsStatementContext ctx) {
        String topicName = this.getIdentifierIfPresent((ParserRuleContext)ctx.identifier()).map(Identifier::getValue).orElse(null);
        return new ShowTopics(topicName);
    }

    public Node visitShowSubscriptionsStatement(RelationalSqlParser.ShowSubscriptionsStatementContext ctx) {
        String topicName = this.getIdentifierIfPresent((ParserRuleContext)ctx.identifier()).map(Identifier::getValue).orElse(null);
        return new ShowSubscriptions(topicName);
    }

    public Node visitDropSubscriptionStatement(RelationalSqlParser.DropSubscriptionStatementContext ctx) {
        String subscriptionId = ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue();
        boolean hasIfExistsCondition = ctx.IF() != null && ctx.EXISTS() != null;
        return new DropSubscription(subscriptionId, hasIfExistsCondition);
    }

    public Node visitShowDevicesStatement(RelationalSqlParser.ShowDevicesStatementContext ctx) {
        QualifiedName name = this.getQualifiedName(ctx.tableName);
        return "information_schema".equals(name.getPrefix().map(QualifiedName::toString).orElse(this.clientSession.getDatabaseName())) ? new ShowStatement(this.getLocation((ParserRuleContext)ctx), name.getSuffix(), this.visitIfPresent((ParserRuleContext)ctx.where, Expression.class), Optional.empty(), this.visitIfPresent((ParserRuleContext)ctx.limitOffsetClause().offset, Offset.class), this.visitIfPresent((ParserRuleContext)ctx.limitOffsetClause().limit, Node.class)) : new ShowDevice(this.getLocation((ParserRuleContext)ctx), new Table(this.getLocation((ParserRuleContext)ctx), name), this.visitIfPresent((ParserRuleContext)ctx.where, Expression.class).orElse(null), this.visitIfPresent((ParserRuleContext)ctx.limitOffsetClause().offset, Offset.class).orElse(null), this.visitIfPresent((ParserRuleContext)ctx.limitOffsetClause().limit, Node.class).orElse(null));
    }

    public Node visitCountDevicesStatement(RelationalSqlParser.CountDevicesStatementContext ctx) {
        QualifiedName name = this.getQualifiedName(ctx.tableName);
        return "information_schema".equals(name.getPrefix().map(QualifiedName::toString).orElse(this.clientSession.getDatabaseName())) ? new CountStatement(this.getLocation((ParserRuleContext)ctx), name.getSuffix(), this.visitIfPresent((ParserRuleContext)ctx.where, Expression.class)) : new CountDevice(this.getLocation((ParserRuleContext)ctx), new Table(this.getLocation((ParserRuleContext)ctx), name), this.visitIfPresent((ParserRuleContext)ctx.where, Expression.class).orElse(null));
    }

    public Node visitShowClusterStatement(RelationalSqlParser.ShowClusterStatementContext ctx) {
        boolean details = ctx.DETAILS() != null;
        return new ShowCluster(details);
    }

    public Node visitShowRegionsStatement(RelationalSqlParser.ShowRegionsStatementContext ctx) {
        TConsensusGroupType regionType = null;
        if (ctx.DATA() != null) {
            regionType = TConsensusGroupType.DataRegion;
        } else if (ctx.SCHEMA() != null) {
            regionType = TConsensusGroupType.SchemaRegion;
        }
        return new ShowRegions(regionType, Objects.nonNull(ctx.identifier()) ? ((Identifier)this.visit((ParseTree)ctx.identifier())).getValue() : null, null);
    }

    public Node visitShowDataNodesStatement(RelationalSqlParser.ShowDataNodesStatementContext ctx) {
        return new ShowDataNodes();
    }

    public Node visitShowConfigNodesStatement(RelationalSqlParser.ShowConfigNodesStatementContext ctx) {
        return new ShowConfigNodes();
    }

    public Node visitShowAINodesStatement(RelationalSqlParser.ShowAINodesStatementContext ctx) {
        return new ShowAINodes();
    }

    public Node visitShowClusterIdStatement(RelationalSqlParser.ShowClusterIdStatementContext ctx) {
        return new ShowClusterId(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitShowRegionIdStatement(RelationalSqlParser.ShowRegionIdStatementContext ctx) {
        throw new SemanticException("SHOW REGION ID is not supported yet.");
    }

    public Node visitShowTimeSlotListStatement(RelationalSqlParser.ShowTimeSlotListStatementContext ctx) {
        throw new SemanticException("SHOW TIME SLOT is not supported yet.");
    }

    public Node visitCountTimeSlotListStatement(RelationalSqlParser.CountTimeSlotListStatementContext ctx) {
        throw new SemanticException("COUNT TIME SLOT is not supported yet.");
    }

    public Node visitShowSeriesSlotListStatement(RelationalSqlParser.ShowSeriesSlotListStatementContext ctx) {
        throw new SemanticException("SHOW SERIES SLOT is not supported yet.");
    }

    public Node visitMigrateRegionStatement(RelationalSqlParser.MigrateRegionStatementContext ctx) {
        return new MigrateRegion(Integer.parseInt(ctx.regionId.getText()), Integer.parseInt(ctx.fromId.getText()), Integer.parseInt(ctx.toId.getText()));
    }

    public Node visitReconstructRegionStatement(RelationalSqlParser.ReconstructRegionStatementContext ctx) {
        int dataNodeId = Integer.parseInt(ctx.targetDataNodeId.getText());
        List<Integer> regionIds = ctx.regionIds.stream().map(Token::getText).map(Integer::parseInt).collect(Collectors.toList());
        return new ReconstructRegion(dataNodeId, regionIds);
    }

    public Node visitExtendRegionStatement(RelationalSqlParser.ExtendRegionStatementContext ctx) {
        return new ExtendRegion(Integer.parseInt(ctx.regionId.getText()), Integer.parseInt(ctx.targetDataNodeId.getText()));
    }

    public Node visitRemoveRegionStatement(RelationalSqlParser.RemoveRegionStatementContext ctx) {
        return new RemoveRegion(Integer.parseInt(ctx.regionId.getText()), Integer.parseInt(ctx.targetDataNodeId.getText()));
    }

    public Node visitRemoveDataNodeStatement(RelationalSqlParser.RemoveDataNodeStatementContext ctx) {
        List<Integer> nodeIds = Collections.singletonList(Integer.parseInt(ctx.INTEGER_VALUE().getText()));
        return new RemoveDataNode(nodeIds);
    }

    public Node visitRemoveConfigNodeStatement(RelationalSqlParser.RemoveConfigNodeStatementContext ctx) {
        Integer nodeId = Integer.parseInt(ctx.INTEGER_VALUE().getText());
        return new RemoveConfigNode(nodeId);
    }

    public Node visitRemoveAINodeStatement(RelationalSqlParser.RemoveAINodeStatementContext ctx) {
        return new RemoveAINode();
    }

    public Node visitFlushStatement(RelationalSqlParser.FlushStatementContext ctx) {
        FlushStatement flushStatement = new FlushStatement(StatementType.FLUSH);
        List storageGroups = null;
        if (ctx.booleanValue() != null) {
            flushStatement.setSeq(Boolean.parseBoolean(ctx.booleanValue().getText()));
        }
        flushStatement.setOnCluster(ctx.localOrClusterMode() == null || ctx.localOrClusterMode().LOCAL() == null);
        if (ctx.identifier() != null) {
            storageGroups = this.getIdentifiers(ctx.identifier()).stream().map(Identifier::getValue).collect(Collectors.toList());
        }
        flushStatement.setDatabases(storageGroups);
        return new Flush(flushStatement, null);
    }

    public Node visitClearCacheStatement(RelationalSqlParser.ClearCacheStatementContext ctx) {
        RelationalSqlParser.ClearCacheOptionsContext context = ctx.clearCacheOptions();
        Set<CacheClearOptions> options = Objects.isNull(context) ? Collections.singleton(CacheClearOptions.DEFAULT) : (context.ATTRIBUTE() != null ? Collections.singleton(CacheClearOptions.TABLE_ATTRIBUTE) : (context.QUERY() != null ? Collections.singleton(CacheClearOptions.QUERY) : new HashSet<CacheClearOptions>(Arrays.asList(CacheClearOptions.TABLE_ATTRIBUTE, CacheClearOptions.TREE_SCHEMA, CacheClearOptions.QUERY))));
        return new ClearCache(Objects.isNull(ctx.localOrClusterMode()) || Objects.nonNull(ctx.localOrClusterMode().CLUSTER()), options);
    }

    public Node visitSetSystemStatusStatement(RelationalSqlParser.SetSystemStatusStatementContext ctx) {
        SetSystemStatusStatement setSystemStatusStatement = new SetSystemStatusStatement();
        setSystemStatusStatement.setOnCluster(ctx.localOrClusterMode() == null || ctx.localOrClusterMode().LOCAL() == null);
        if (ctx.RUNNING() != null) {
            setSystemStatusStatement.setStatus(NodeStatus.Running);
        } else if (ctx.READONLY() != null) {
            setSystemStatusStatement.setStatus(NodeStatus.ReadOnly);
        } else {
            throw new SemanticException("Unknown system status in set system command.");
        }
        return new SetSystemStatus(setSystemStatusStatement, null);
    }

    public Node visitShowVersionStatement(RelationalSqlParser.ShowVersionStatementContext ctx) {
        return new ShowVersion(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitShowCurrentSqlDialectStatement(RelationalSqlParser.ShowCurrentSqlDialectStatementContext ctx) {
        return new ShowCurrentSqlDialect(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitSetSqlDialectStatement(RelationalSqlParser.SetSqlDialectStatementContext ctx) {
        return new SetSqlDialect(ctx.TABLE() == null ? IClientSession.SqlDialect.TREE : IClientSession.SqlDialect.TABLE, this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitShowCurrentDatabaseStatement(RelationalSqlParser.ShowCurrentDatabaseStatementContext ctx) {
        return new ShowCurrentDatabase(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitShowCurrentUserStatement(RelationalSqlParser.ShowCurrentUserStatementContext ctx) {
        return new ShowCurrentUser(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitShowVariablesStatement(RelationalSqlParser.ShowVariablesStatementContext ctx) {
        return new ShowVariables(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitShowCurrentTimestampStatement(RelationalSqlParser.ShowCurrentTimestampStatementContext ctx) {
        return new ShowCurrentTimestamp(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitShowQueriesStatement(RelationalSqlParser.ShowQueriesStatementContext ctx) {
        Optional<OrderBy> orderBy = Optional.empty();
        if (ctx.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.getLocation(ctx.ORDER()), this.visit(ctx.sortItem(), SortItem.class)));
        }
        Optional<Offset> offset = Optional.empty();
        if (ctx.limitOffsetClause().OFFSET() != null) {
            offset = this.visitIfPresent((ParserRuleContext)ctx.limitOffsetClause().offset, Offset.class);
        }
        Optional<Node> limit = Optional.empty();
        if (ctx.limitOffsetClause().LIMIT() != null) {
            if (ctx.limitOffsetClause().limit == null) {
                throw new IllegalStateException("Missing LIMIT value");
            }
            limit = this.visitIfPresent((ParserRuleContext)ctx.limitOffsetClause().limit, Node.class);
        }
        return new ShowQueriesStatement(this.getLocation((ParserRuleContext)ctx), "queries", this.visitIfPresent((ParserRuleContext)ctx.where, Expression.class), orderBy, offset, limit);
    }

    public Node visitKillQueryStatement(RelationalSqlParser.KillQueryStatementContext ctx) {
        if (ctx.queryId == null) {
            return new KillQuery(null, this.getLocation((ParserRuleContext)ctx));
        }
        return new KillQuery(((StringLiteral)this.visit((ParseTree)ctx.queryId)).getValue(), this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitLoadConfigurationStatement(RelationalSqlParser.LoadConfigurationStatementContext ctx) {
        LoadConfigurationStatement loadConfigurationStatement = new LoadConfigurationStatement(StatementType.LOAD_CONFIGURATION);
        loadConfigurationStatement.setOnCluster(ctx.localOrClusterMode() == null || ctx.localOrClusterMode().LOCAL() == null);
        return new LoadConfiguration(loadConfigurationStatement, null);
    }

    public Node visitSetConfigurationStatement(RelationalSqlParser.SetConfigurationStatementContext ctx) {
        SetConfigurationStatement setConfigurationStatement = new SetConfigurationStatement(StatementType.SET_CONFIGURATION);
        int nodeId = Integer.parseInt(ctx.INTEGER_VALUE() == null ? "-1" : ctx.INTEGER_VALUE().getText());
        HashMap<String, String> configItems = new HashMap<String, String>();
        Object properties = ImmutableList.of();
        if (ctx.propertyAssignments() != null) {
            properties = this.visit(ctx.propertyAssignments().property(), Property.class);
        }
        for (Property property : properties) {
            String key = property.getName().getValue();
            Expression propertyValue = property.getNonDefaultValue();
            if (!propertyValue.getExpressionType().equals((Object)TableExpressionType.STRING_LITERAL)) {
                throw new SemanticException((Object)((Object)propertyValue.getExpressionType()) + " is not supported for property value of 'set configuration'. Note that the syntax for 'set configuration' in the tree model is not exactly the same as that in the table model.");
            }
            String value = ((StringLiteral)propertyValue).getValue();
            configItems.put(key.trim(), value.trim());
        }
        setConfigurationStatement.setNodeId(nodeId);
        setConfigurationStatement.setConfigItems(configItems);
        return new SetConfiguration(setConfigurationStatement, null);
    }

    public Node visitStartRepairDataStatement(RelationalSqlParser.StartRepairDataStatementContext ctx) {
        StartRepairDataStatement startRepairDataStatement = new StartRepairDataStatement(StatementType.START_REPAIR_DATA);
        startRepairDataStatement.setOnCluster(ctx.localOrClusterMode() == null || ctx.localOrClusterMode().LOCAL() == null);
        return new StartRepairData(startRepairDataStatement, null);
    }

    public Node visitStopRepairDataStatement(RelationalSqlParser.StopRepairDataStatementContext ctx) {
        StopRepairDataStatement stopRepairDataStatement = new StopRepairDataStatement(StatementType.STOP_REPAIR_DATA);
        stopRepairDataStatement.setOnCluster(ctx.localOrClusterMode() == null || ctx.localOrClusterMode().LOCAL() == null);
        return new StopRepairData(stopRepairDataStatement, null);
    }

    public Node visitLocalOrClusterMode(RelationalSqlParser.LocalOrClusterModeContext ctx) {
        return (Node)super.visitLocalOrClusterMode(ctx);
    }

    public Node visitStatementDefault(RelationalSqlParser.StatementDefaultContext ctx) {
        return (Node)super.visitStatementDefault(ctx);
    }

    public Node visitExplain(RelationalSqlParser.ExplainContext ctx) {
        return new Explain(this.getLocation((ParserRuleContext)ctx), (Statement)this.visit((ParseTree)ctx.query()));
    }

    public Node visitExplainAnalyze(RelationalSqlParser.ExplainAnalyzeContext ctx) {
        return new ExplainAnalyze(this.getLocation((ParserRuleContext)ctx), ctx.VERBOSE() != null, (Statement)this.visit((ParseTree)ctx.query()));
    }

    public Node visitCreateUserStatement(RelationalSqlParser.CreateUserStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.CREATE_USER);
        stmt.setUserName(((Identifier)this.visit((ParseTree)ctx.userName)).getValue());
        String password = ((StringLiteral)this.visit((ParseTree)ctx.password)).getValue();
        stmt.setPassword(password);
        return stmt;
    }

    public Node visitCreateRoleStatement(RelationalSqlParser.CreateRoleStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.CREATE_ROLE);
        stmt.setRoleName(((Identifier)this.visit((ParseTree)ctx.roleName)).getValue());
        return stmt;
    }

    public Node visitDropUserStatement(RelationalSqlParser.DropUserStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.DROP_USER);
        stmt.setUserName(((Identifier)this.visit((ParseTree)ctx.userName)).getValue());
        return stmt;
    }

    public Node visitDropRoleStatement(RelationalSqlParser.DropRoleStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.DROP_ROLE);
        stmt.setRoleName(((Identifier)this.visit((ParseTree)ctx.roleName)).getValue());
        return stmt;
    }

    public Node visitAlterUserStatement(RelationalSqlParser.AlterUserStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.UPDATE_USER);
        stmt.setUserName(((Identifier)this.visit((ParseTree)ctx.userName)).getValue());
        String password = ((StringLiteral)this.visit((ParseTree)ctx.password)).getValue();
        stmt.setPassword(password);
        return stmt;
    }

    public Node visitGrantUserRoleStatement(RelationalSqlParser.GrantUserRoleStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.GRANT_USER_ROLE);
        stmt.setUserName(((Identifier)this.visit((ParseTree)ctx.userName)).getValue());
        stmt.setRoleName(((Identifier)this.visit((ParseTree)ctx.roleName)).getValue());
        return stmt;
    }

    public Node visitRevokeUserRoleStatement(RelationalSqlParser.RevokeUserRoleStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.REVOKE_USER_ROLE);
        stmt.setUserName(((Identifier)this.visit((ParseTree)ctx.userName)).getValue());
        stmt.setRoleName(((Identifier)this.visit((ParseTree)ctx.roleName)).getValue());
        return stmt;
    }

    public Node visitListUserPrivilegeStatement(RelationalSqlParser.ListUserPrivilegeStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.LIST_USER_PRIV);
        stmt.setUserName(((Identifier)this.visit((ParseTree)ctx.userName)).getValue());
        return stmt;
    }

    public Node visitListRolePrivilegeStatement(RelationalSqlParser.ListRolePrivilegeStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.LIST_ROLE_PRIV);
        stmt.setRoleName(((Identifier)this.visit((ParseTree)ctx.roleName)).getValue());
        return stmt;
    }

    public Node visitListUserStatement(RelationalSqlParser.ListUserStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.LIST_USER);
        if (ctx.OF() != null) {
            stmt.setRoleName(((Identifier)this.visit((ParseTree)ctx.roleName)).getValue());
        }
        return stmt;
    }

    public Node visitListRoleStatement(RelationalSqlParser.ListRoleStatementContext ctx) {
        RelationalAuthorStatement stmt = new RelationalAuthorStatement(AuthorRType.LIST_ROLE);
        if (ctx.OF() != null) {
            stmt.setUserName(((Identifier)this.visit((ParseTree)ctx.userName)).getValue());
        }
        return stmt;
    }

    private Set<PrivilegeType> parseSystemPrivilege(RelationalSqlParser.SystemPrivilegesContext ctx) {
        List privilegeContexts = ctx.systemPrivilege();
        HashSet<PrivilegeType> privileges = new HashSet<PrivilegeType>();
        for (RelationalSqlParser.SystemPrivilegeContext privilege : privilegeContexts) {
            privileges.add(PrivilegeType.valueOf((String)privilege.getText().toUpperCase()));
        }
        return privileges;
    }

    private Set<PrivilegeType> parseRelationalPrivilege(RelationalSqlParser.ObjectPrivilegesContext ctx) {
        HashSet<PrivilegeType> privileges = new HashSet<PrivilegeType>();
        if (ctx.ALL() != null) {
            for (PrivilegeType privilegeType : PrivilegeType.values()) {
                if (!privilegeType.isRelationalPrivilege()) continue;
                privileges.add(privilegeType);
            }
        } else {
            List privilegeContexts = ctx.objectPrivilege();
            for (RelationalSqlParser.ObjectPrivilegeContext privilege : privilegeContexts) {
                privileges.add(PrivilegeType.valueOf((String)privilege.getText().toUpperCase()));
            }
        }
        return privileges;
    }

    public Node visitGrantStatement(RelationalSqlParser.GrantStatementContext ctx) {
        boolean grantOption;
        boolean toUser = ctx.holderType().getText().equalsIgnoreCase("user");
        String name = ((Identifier)this.visit((ParseTree)ctx.holderName)).getValue();
        boolean bl = grantOption = ctx.grantOpt() != null;
        if (ctx.privilegeObjectScope().ON() == null) {
            if (ctx.privilegeObjectScope().ALL() != null) {
                return new RelationalAuthorStatement(toUser ? AuthorRType.GRANT_USER_ALL : AuthorRType.GRANT_ROLE_ALL, toUser ? name : "", toUser ? "" : name, grantOption);
            }
            Set<PrivilegeType> privileges = this.parseSystemPrivilege(ctx.privilegeObjectScope().systemPrivileges());
            return new RelationalAuthorStatement(toUser ? AuthorRType.GRANT_USER_SYS : AuthorRType.GRANT_ROLE_SYS, privileges, toUser ? name : "", toUser ? "" : name, grantOption);
        }
        Set<PrivilegeType> privileges = this.parseRelationalPrivilege(ctx.privilegeObjectScope().objectPrivileges());
        if (ctx.privilegeObjectScope().objectType() != null) {
            boolean toTable = ctx.privilegeObjectScope().objectType().getText().equalsIgnoreCase("table");
            String databaseName = "";
            if (toTable && (databaseName = this.clientSession.getDatabaseName()) == null) {
                throw new SemanticException("Database is not set yet.");
            }
            String obj = ((Identifier)this.visit((ParseTree)ctx.privilegeObjectScope().objectName)).getValue();
            return new RelationalAuthorStatement(toUser ? (toTable ? AuthorRType.GRANT_USER_TB : AuthorRType.GRANT_USER_DB) : (toTable ? AuthorRType.GRANT_ROLE_TB : AuthorRType.GRANT_ROLE_DB), toUser ? name : "", toUser ? "" : name, toTable ? databaseName.toLowerCase() : obj.toLowerCase(), toTable ? obj.toLowerCase() : "", privileges, grantOption, null);
        }
        if (ctx.privilegeObjectScope().objectScope() != null) {
            String db = ((Identifier)this.visit((ParseTree)ctx.privilegeObjectScope().objectScope().dbname)).getValue().toLowerCase();
            String tb = ((Identifier)this.visit((ParseTree)ctx.privilegeObjectScope().objectScope().tbname)).getValue().toLowerCase();
            return new RelationalAuthorStatement(toUser ? AuthorRType.GRANT_USER_TB : AuthorRType.GRANT_ROLE_TB, toUser ? name : "", toUser ? "" : name, db, tb, privileges, grantOption, null);
        }
        if (ctx.privilegeObjectScope().ANY() != null) {
            return new RelationalAuthorStatement(toUser ? AuthorRType.GRANT_USER_ANY : AuthorRType.GRANT_ROLE_ANY, privileges, toUser ? name : "", toUser ? "" : name, grantOption);
        }
        throw new SemanticException("author statement parser error");
    }

    public Node visitRevokeStatement(RelationalSqlParser.RevokeStatementContext ctx) {
        boolean fromUser = ctx.holderType().getText().equalsIgnoreCase("user");
        String name = ((Identifier)this.visit((ParseTree)ctx.holderName)).getValue();
        boolean grantOption = ctx.revokeGrantOpt() != null;
        boolean fromTable = false;
        HashSet<PrivilegeType> privileges = new HashSet();
        if (ctx.privilegeObjectScope().ON() == null) {
            if (ctx.privilegeObjectScope().ALL() != null) {
                return new RelationalAuthorStatement(fromUser ? AuthorRType.REVOKE_USER_ALL : AuthorRType.REVOKE_ROLE_ALL, fromUser ? name : "", fromUser ? "" : name, grantOption);
            }
            privileges = this.parseSystemPrivilege(ctx.privilegeObjectScope().systemPrivileges());
            return new RelationalAuthorStatement(fromUser ? AuthorRType.REVOKE_USER_SYS : AuthorRType.REVOKE_ROLE_SYS, privileges, fromUser ? name : "", fromUser ? "" : name, grantOption);
        }
        privileges = this.parseRelationalPrivilege(ctx.privilegeObjectScope().objectPrivileges());
        boolean revokeAll = ctx.privilegeObjectScope().objectPrivileges().ALL() != null;
        String databaseName = "";
        String tableName = "";
        if (ctx.privilegeObjectScope().objectType() != null) {
            fromTable = ctx.privilegeObjectScope().objectType().getText().equalsIgnoreCase("table");
            if (fromTable) {
                databaseName = this.clientSession.getDatabaseName();
                if (databaseName == null) {
                    throw new SemanticException("Database is not set yet.");
                }
                tableName = ((Identifier)this.visit((ParseTree)ctx.privilegeObjectScope().objectName)).getValue().toLowerCase();
            } else {
                databaseName = ((Identifier)this.visit((ParseTree)ctx.privilegeObjectScope().objectName)).getValue().toLowerCase();
            }
        } else if (ctx.privilegeObjectScope().objectScope() != null) {
            fromTable = true;
            databaseName = ((Identifier)this.visit((ParseTree)ctx.privilegeObjectScope().objectScope().dbname)).getValue().toLowerCase();
            tableName = ((Identifier)this.visit((ParseTree)ctx.privilegeObjectScope().objectScope().tbname)).getValue().toLowerCase();
        }
        if (revokeAll && ctx.privilegeObjectScope().ANY() == null) {
            return new RelationalAuthorStatement(fromUser ? AuthorRType.REVOKE_USER_ALL : AuthorRType.REVOKE_ROLE_ALL, fromUser ? name : "", fromUser ? "" : name, databaseName, tableName, Collections.emptySet(), grantOption, null);
        }
        if (ctx.privilegeObjectScope().ANY() != null) {
            return new RelationalAuthorStatement(fromUser ? AuthorRType.REVOKE_USER_ANY : AuthorRType.REVOKE_ROLE_ANY, privileges, fromUser ? name : "", fromUser ? "" : name, grantOption);
        }
        return new RelationalAuthorStatement(fromUser ? (fromTable ? AuthorRType.REVOKE_USER_TB : AuthorRType.REVOKE_USER_DB) : (fromTable ? AuthorRType.REVOKE_ROLE_TB : AuthorRType.REVOKE_ROLE_DB), fromUser ? name : "", fromUser ? "" : name, databaseName, tableName, privileges, grantOption, null);
    }

    public Node visitQuery(RelationalSqlParser.QueryContext ctx) {
        Query body = (Query)this.visit((ParseTree)ctx.queryNoWith());
        return new Query(this.getLocation((ParserRuleContext)ctx), this.visitIfPresent((ParserRuleContext)ctx.with(), With.class), body.getQueryBody(), body.getFill(), body.getOrderBy(), body.getOffset(), body.getLimit());
    }

    public Node visitWith(RelationalSqlParser.WithContext ctx) {
        return new With(this.getLocation((ParserRuleContext)ctx), ctx.RECURSIVE() != null, this.visit(ctx.namedQuery(), WithQuery.class));
    }

    public Node visitNamedQuery(RelationalSqlParser.NamedQueryContext ctx) {
        if (ctx.columnAliases() != null) {
            List<Identifier> columns = this.visit(ctx.columnAliases().identifier(), Identifier.class);
            return new WithQuery(this.getLocation((ParserRuleContext)ctx), (Identifier)this.visit((ParseTree)ctx.name), (Query)this.visit((ParseTree)ctx.query()), columns);
        }
        return new WithQuery(this.getLocation((ParserRuleContext)ctx), (Identifier)this.visit((ParseTree)ctx.name), (Query)this.visit((ParseTree)ctx.query()));
    }

    public Node visitQueryNoWith(RelationalSqlParser.QueryNoWithContext ctx) {
        QueryBody term = (QueryBody)this.visit((ParseTree)ctx.queryTerm());
        Optional<Fill> fill = Optional.empty();
        if (ctx.fillClause() != null) {
            fill = this.visitIfPresent((ParserRuleContext)ctx.fillClause().fillMethod(), Fill.class);
        }
        Optional<OrderBy> orderBy = Optional.empty();
        if (ctx.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.getLocation(ctx.ORDER()), this.visit(ctx.sortItem(), SortItem.class)));
        }
        Optional<Offset> offset = Optional.empty();
        if (ctx.limitOffsetClause().OFFSET() != null) {
            offset = this.visitIfPresent((ParserRuleContext)ctx.limitOffsetClause().offset, Offset.class);
        }
        Optional<Node> limit = Optional.empty();
        if (ctx.limitOffsetClause().LIMIT() != null) {
            if (ctx.limitOffsetClause().limit == null) {
                throw new IllegalStateException("Missing LIMIT value");
            }
            limit = this.visitIfPresent((ParserRuleContext)ctx.limitOffsetClause().limit, Node.class);
        }
        if (term instanceof QuerySpecification) {
            QuerySpecification query = (QuerySpecification)term;
            return new Query(this.getLocation((ParserRuleContext)ctx), Optional.empty(), new QuerySpecification(this.getLocation((ParserRuleContext)ctx), query.getSelect(), query.getFrom(), query.getWhere(), query.getGroupBy(), query.getHaving(), fill, query.getWindows(), orderBy, offset, limit), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }
        return new Query(this.getLocation((ParserRuleContext)ctx), Optional.empty(), term, fill, orderBy, offset, limit);
    }

    public Node visitPreviousFill(RelationalSqlParser.PreviousFillContext ctx) {
        TimeDuration timeBound = null;
        LongLiteral timeColumn = null;
        List<LongLiteral> fillGroupingElements = null;
        if (ctx.timeBoundClause() != null) {
            timeBound = DateTimeUtils.constructTimeDuration(ctx.timeBoundClause().timeDuration().getText());
            if (timeBound.monthDuration != 0 && timeBound.nonMonthDuration != 0L) {
                throw new SemanticException("Simultaneous setting of monthly and non-monthly intervals is not supported.");
            }
        }
        if (ctx.timeColumnClause() != null) {
            timeColumn = new LongLiteral(this.getLocation(ctx.timeColumnClause().INTEGER_VALUE()), ctx.timeColumnClause().INTEGER_VALUE().getText());
        }
        if (ctx.fillGroupClause() != null) {
            fillGroupingElements = ctx.fillGroupClause().INTEGER_VALUE().stream().map(index -> new LongLiteral(this.getLocation((TerminalNode)index), index.getText())).collect(Collectors.toList());
        }
        if (timeColumn != null && timeBound == null && fillGroupingElements == null) {
            throw new SemanticException("Don't need to specify TIME_COLUMN while either TIME_BOUND or FILL_GROUP parameter is not specified");
        }
        return new Fill(this.getLocation((ParserRuleContext)ctx), timeBound, timeColumn, fillGroupingElements);
    }

    public Node visitLinearFill(RelationalSqlParser.LinearFillContext ctx) {
        LongLiteral timeColumn = null;
        List fillGroupingElements = null;
        if (ctx.timeColumnClause() != null) {
            timeColumn = new LongLiteral(this.getLocation(ctx.timeColumnClause().INTEGER_VALUE()), ctx.timeColumnClause().INTEGER_VALUE().getText());
        }
        if (ctx.fillGroupClause() != null) {
            fillGroupingElements = ctx.fillGroupClause().INTEGER_VALUE().stream().map(index -> new LongLiteral(this.getLocation((TerminalNode)index), index.getText())).collect(Collectors.toList());
        }
        return new Fill(this.getLocation((ParserRuleContext)ctx), timeColumn, fillGroupingElements);
    }

    public Node visitValueFill(RelationalSqlParser.ValueFillContext ctx) {
        return new Fill(this.getLocation((ParserRuleContext)ctx), (Literal)this.visit((ParseTree)ctx.literalExpression()));
    }

    public Node visitLimitRowCount(RelationalSqlParser.LimitRowCountContext ctx) {
        Expression rowCount;
        if (ctx.ALL() != null) {
            rowCount = new AllRows(this.getLocation(ctx.ALL()));
        } else if (ctx.rowCount().INTEGER_VALUE() != null) {
            rowCount = new LongLiteral(this.getLocation(ctx.rowCount().INTEGER_VALUE()), ctx.getText());
        } else {
            rowCount = new Parameter(this.getLocation(ctx.rowCount().QUESTION_MARK()), this.parameterPosition);
            ++this.parameterPosition;
        }
        return new Limit(this.getLocation((ParserRuleContext)ctx), rowCount);
    }

    public Node visitRowCount(RelationalSqlParser.RowCountContext ctx) {
        Expression rowCount;
        if (ctx.INTEGER_VALUE() != null) {
            rowCount = new LongLiteral(this.getLocation(ctx.INTEGER_VALUE()), ctx.getText());
        } else {
            rowCount = new Parameter(this.getLocation(ctx.QUESTION_MARK()), this.parameterPosition);
            ++this.parameterPosition;
        }
        return new Offset(this.getLocation((ParserRuleContext)ctx), rowCount);
    }

    public Node visitQuerySpecification(RelationalSqlParser.QuerySpecificationContext ctx) {
        Optional<Relation> from = Optional.empty();
        List<SelectItem> selectItems = this.visit(ctx.selectItem(), SelectItem.class);
        List<Relation> relations = this.visit(ctx.relation(), Relation.class);
        if (!relations.isEmpty()) {
            Iterator<Relation> iterator = relations.iterator();
            Relation relation = iterator.next();
            while (iterator.hasNext()) {
                relation = new Join(this.getLocation((ParserRuleContext)ctx), Join.Type.IMPLICIT, relation, iterator.next());
            }
            from = Optional.of(relation);
        }
        return new QuerySpecification(this.getLocation((ParserRuleContext)ctx), new Select(this.getLocation(ctx.SELECT()), AstBuilder.isDistinct(ctx.setQuantifier()), selectItems), from, this.visitIfPresent((ParserRuleContext)ctx.where, Expression.class), this.visitIfPresent((ParserRuleContext)ctx.groupBy(), GroupBy.class), this.visitIfPresent((ParserRuleContext)ctx.having, Expression.class), Optional.empty(), this.visit(ctx.windowDefinition(), WindowDefinition.class), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Node visitSelectSingle(RelationalSqlParser.SelectSingleContext ctx) {
        if (ctx.identifier() != null) {
            return new SingleColumn(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.expression()), (Identifier)this.visit((ParseTree)ctx.identifier()));
        }
        return new SingleColumn(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.expression()));
    }

    public Node visitSelectAll(RelationalSqlParser.SelectAllContext ctx) {
        Object aliases = ImmutableList.of();
        if (ctx.columnAliases() != null) {
            aliases = this.visit(ctx.columnAliases().identifier(), Identifier.class);
        }
        if (ctx.primaryExpression() != null) {
            return new AllColumns(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.primaryExpression()), (List<Identifier>)aliases);
        }
        return new AllColumns(this.getLocation((ParserRuleContext)ctx), (List<Identifier>)aliases);
    }

    public Node visitGroupBy(RelationalSqlParser.GroupByContext ctx) {
        return new GroupBy(this.getLocation((ParserRuleContext)ctx), AstBuilder.isDistinct(ctx.setQuantifier()), this.visit(ctx.groupingElement(), GroupingElement.class));
    }

    public Node visitSingleGroupingSet(RelationalSqlParser.SingleGroupingSetContext ctx) {
        return new SimpleGroupBy(this.getLocation((ParserRuleContext)ctx), this.visit(ctx.groupingSet().expression(), Expression.class));
    }

    public Node visitRollup(RelationalSqlParser.RollupContext ctx) {
        return new GroupingSets(this.getLocation((ParserRuleContext)ctx), GroupingSets.Type.ROLLUP, ctx.groupingSet().stream().map(groupingSet -> this.visit(groupingSet.expression(), Expression.class)).collect(Collectors.toList()));
    }

    public Node visitCube(RelationalSqlParser.CubeContext ctx) {
        return new GroupingSets(this.getLocation((ParserRuleContext)ctx), GroupingSets.Type.CUBE, ctx.groupingSet().stream().map(groupingSet -> this.visit(groupingSet.expression(), Expression.class)).collect(Collectors.toList()));
    }

    public Node visitMultipleGroupingSets(RelationalSqlParser.MultipleGroupingSetsContext ctx) {
        return new GroupingSets(this.getLocation((ParserRuleContext)ctx), GroupingSets.Type.EXPLICIT, ctx.groupingSet().stream().map(groupingSet -> this.visit(groupingSet.expression(), Expression.class)).collect(Collectors.toList()));
    }

    public Node visitSetOperation(RelationalSqlParser.SetOperationContext ctx) {
        QueryBody left = (QueryBody)this.visit((ParseTree)ctx.left);
        QueryBody right = (QueryBody)this.visit((ParseTree)ctx.right);
        boolean distinct = ctx.setQuantifier() == null || ctx.setQuantifier().DISTINCT() != null;
        switch (ctx.operator.getType()) {
            case 375: {
                return new Union(this.getLocation(ctx.UNION()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
            case 165: {
                return new Intersect(this.getLocation(ctx.INTERSECT()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
            case 118: {
                return new Except(this.getLocation(ctx.EXCEPT()), left, right, distinct);
            }
        }
        throw new IllegalArgumentException("Unsupported set operation: " + ctx.operator.getText());
    }

    public Node visitProperty(RelationalSqlParser.PropertyContext ctx) {
        NodeLocation location = this.getLocation((ParserRuleContext)ctx);
        Identifier name = (Identifier)this.visit((ParseTree)ctx.identifier());
        RelationalSqlParser.PropertyValueContext valueContext = ctx.propertyValue();
        if (valueContext instanceof RelationalSqlParser.DefaultPropertyValueContext) {
            return new Property(location, name);
        }
        Expression value = (Expression)this.visit((ParseTree)((RelationalSqlParser.NonDefaultPropertyValueContext)valueContext).expression());
        return new Property(location, name, value);
    }

    public Node visitTable(RelationalSqlParser.TableContext ctx) {
        return new Table(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()));
    }

    public Node visitInlineTable(RelationalSqlParser.InlineTableContext ctx) {
        return new Values(this.getLocation((ParserRuleContext)ctx), this.visit(ctx.expression(), Expression.class));
    }

    public Node visitSubquery(RelationalSqlParser.SubqueryContext ctx) {
        return new TableSubquery(this.getLocation((ParserRuleContext)ctx), (Query)this.visit((ParseTree)ctx.queryNoWith()));
    }

    public Node visitSortItem(RelationalSqlParser.SortItemContext ctx) {
        return new SortItem(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.expression()), Optional.ofNullable(ctx.ordering).map(AstBuilder::getOrderingType).orElse(SortItem.Ordering.ASCENDING), Optional.ofNullable(ctx.nullOrdering).map(AstBuilder::getNullOrderingType).orElse(SortItem.NullOrdering.UNDEFINED));
    }

    public Node visitUnquotedIdentifier(RelationalSqlParser.UnquotedIdentifierContext ctx) {
        return new Identifier(this.getLocation((ParserRuleContext)ctx), ctx.getText(), false);
    }

    public Node visitQuotedIdentifier(RelationalSqlParser.QuotedIdentifierContext ctx) {
        String token = ctx.getText();
        String identifier = token.substring(1, token.length() - 1).replace("\"\"", "\"");
        return new Identifier(this.getLocation((ParserRuleContext)ctx), identifier, true);
    }

    public Node visitLogicalNot(RelationalSqlParser.LogicalNotContext ctx) {
        return new NotExpression(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.booleanExpression()));
    }

    public Node visitOr(RelationalSqlParser.OrContext ctx) {
        List<ParserRuleContext> terms = AstBuilder.flatten((ParserRuleContext)ctx, element -> {
            if (element instanceof RelationalSqlParser.OrContext) {
                RelationalSqlParser.OrContext or = (RelationalSqlParser.OrContext)element;
                return Optional.of(or.booleanExpression());
            }
            return Optional.empty();
        });
        return new LogicalExpression(this.getLocation((ParserRuleContext)ctx), LogicalExpression.Operator.OR, this.visit(terms, Expression.class));
    }

    public Node visitAnd(RelationalSqlParser.AndContext ctx) {
        List<ParserRuleContext> terms = AstBuilder.flatten((ParserRuleContext)ctx, element -> {
            if (element instanceof RelationalSqlParser.AndContext) {
                RelationalSqlParser.AndContext and = (RelationalSqlParser.AndContext)element;
                return Optional.of(and.booleanExpression());
            }
            return Optional.empty();
        });
        return new LogicalExpression(this.getLocation((ParserRuleContext)ctx), LogicalExpression.Operator.AND, this.visit(terms, Expression.class));
    }

    private static List<ParserRuleContext> flatten(ParserRuleContext root, Function<ParserRuleContext, Optional<List<? extends ParserRuleContext>>> extractChildren) {
        ArrayList<ParserRuleContext> result = new ArrayList<ParserRuleContext>();
        ArrayDeque<ParserRuleContext> pending = new ArrayDeque<ParserRuleContext>();
        pending.push(root);
        while (!pending.isEmpty()) {
            ParserRuleContext next = (ParserRuleContext)pending.pop();
            Optional<List<? extends ParserRuleContext>> children = extractChildren.apply(next);
            if (!children.isPresent()) {
                result.add(next);
                continue;
            }
            for (int i = children.get().size() - 1; i >= 0; --i) {
                pending.push(children.get().get(i));
            }
        }
        return result;
    }

    public Node visitJoinRelation(RelationalSqlParser.JoinRelationContext ctx) {
        JoinCriteria criteria;
        Relation right;
        Relation left = (Relation)this.visit((ParseTree)ctx.left);
        if (ctx.CROSS() != null) {
            Relation right2 = (Relation)this.visit((ParseTree)ctx.right);
            return new Join(this.getLocation((ParserRuleContext)ctx), Join.Type.CROSS, left, right2);
        }
        TimeDuration timeDuration = null;
        if (ctx.NATURAL() != null) {
            right = (Relation)this.visit((ParseTree)ctx.right);
            criteria = new NaturalJoin();
        } else {
            right = (Relation)this.visit((ParseTree)ctx.rightRelation);
            if (ctx.joinCriteria().ON() != null) {
                if (ctx.ASOF() != null) {
                    if (ctx.timeDuration() != null) {
                        timeDuration = DateTimeUtils.constructTimeDuration(ctx.timeDuration().getText());
                        if (timeDuration.monthDuration != 0) {
                            throw new SemanticException("Month or year interval in tolerance is not supported now.");
                        }
                    }
                    criteria = AsofJoinOn.constructAsofJoinOn((Expression)this.visit((ParseTree)ctx.joinCriteria().booleanExpression()), timeDuration);
                } else {
                    criteria = new JoinOn((Expression)this.visit((ParseTree)ctx.joinCriteria().booleanExpression()));
                }
            } else if (ctx.joinCriteria().USING() != null) {
                criteria = new JoinUsing(this.visit(ctx.joinCriteria().identifier(), Identifier.class));
            } else {
                throw new IllegalArgumentException("Unsupported join criteria");
            }
        }
        Join.Type joinType = ctx.joinType().LEFT() != null ? Join.Type.LEFT : (ctx.joinType().RIGHT() != null ? Join.Type.RIGHT : (ctx.joinType().FULL() != null ? Join.Type.FULL : Join.Type.INNER));
        if (criteria instanceof AsofJoinOn) {
            if (joinType == Join.Type.RIGHT || joinType == Join.Type.FULL) {
                throw new SemanticException(String.format("ASOF JOIN does not support %s type now", new Object[]{joinType}));
            }
            if (joinType != Join.Type.INNER && timeDuration != null) {
                throw new SemanticException("Tolerance in ASOF JOIN only supports INNER type now");
            }
        }
        return new Join(this.getLocation((ParserRuleContext)ctx), joinType, left, right, criteria);
    }

    public Node visitPatternRecognition(RelationalSqlParser.PatternRecognitionContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.aliasedRelation());
        if (context.MATCH_RECOGNIZE() == null) {
            return child;
        }
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.getLocation(context.ORDER()), this.visit(context.sortItem(), SortItem.class)));
        }
        PatternRecognitionRelation relation = new PatternRecognitionRelation(this.getLocation((ParserRuleContext)context), child, this.visit(context.partition, Expression.class), orderBy, this.visit(context.measureDefinition(), MeasureDefinition.class), this.getRowsPerMatch(context.rowsPerMatch()), this.visitIfPresent((ParserRuleContext)context.skipTo(), SkipTo.class), (RowPattern)this.visit((ParseTree)context.rowPattern()), this.visit(context.subsetDefinition(), SubsetDefinition.class), this.visit(context.variableDefinition(), VariableDefinition.class));
        if (context.identifier() == null) {
            return relation;
        }
        List<Identifier> aliases = null;
        if (context.columnAliases() != null) {
            aliases = this.visit(context.columnAliases().identifier(), Identifier.class);
        }
        return new AliasedRelation(this.getLocation((ParserRuleContext)context), relation, (Identifier)this.visit((ParseTree)context.identifier()), aliases);
    }

    public Node visitMeasureDefinition(RelationalSqlParser.MeasureDefinitionContext context) {
        return new MeasureDefinition(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    private Optional<PatternRecognitionRelation.RowsPerMatch> getRowsPerMatch(RelationalSqlParser.RowsPerMatchContext context) {
        if (context == null) {
            return Optional.empty();
        }
        if (context.ONE() != null) {
            return Optional.of(PatternRecognitionRelation.RowsPerMatch.ONE);
        }
        if (context.emptyMatchHandling() == null) {
            return Optional.of(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY);
        }
        if (context.emptyMatchHandling().SHOW() != null) {
            return Optional.of(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY);
        }
        if (context.emptyMatchHandling().OMIT() != null) {
            return Optional.of(PatternRecognitionRelation.RowsPerMatch.ALL_OMIT_EMPTY);
        }
        return Optional.of(PatternRecognitionRelation.RowsPerMatch.ALL_WITH_UNMATCHED);
    }

    public Node visitSkipTo(RelationalSqlParser.SkipToContext context) {
        if (context.PAST() != null) {
            return SkipTo.skipPastLastRow(this.getLocation((ParserRuleContext)context));
        }
        if (context.NEXT() != null) {
            return SkipTo.skipToNextRow(this.getLocation((ParserRuleContext)context));
        }
        if (context.FIRST() != null) {
            return SkipTo.skipToFirst(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
        }
        return SkipTo.skipToLast(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitSubsetDefinition(RelationalSqlParser.SubsetDefinitionContext context) {
        return new SubsetDefinition(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.name), this.visit(context.union, Identifier.class));
    }

    public Node visitVariableDefinition(RelationalSqlParser.VariableDefinitionContext context) {
        return new VariableDefinition(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (Expression)this.visit((ParseTree)context.expression()));
    }

    public Node visitAliasedRelation(RelationalSqlParser.AliasedRelationContext ctx) {
        Relation child = (Relation)this.visit((ParseTree)ctx.relationPrimary());
        if (ctx.identifier() == null) {
            return child;
        }
        List<Identifier> aliases = null;
        if (ctx.columnAliases() != null) {
            aliases = this.visit(ctx.columnAliases().identifier(), Identifier.class);
        }
        return new AliasedRelation(this.getLocation((ParserRuleContext)ctx), child, (Identifier)this.visit((ParseTree)ctx.identifier()), aliases);
    }

    public Node visitTableName(RelationalSqlParser.TableNameContext ctx) {
        return new Table(this.getLocation((ParserRuleContext)ctx), this.getQualifiedName(ctx.qualifiedName()));
    }

    public Node visitSubqueryRelation(RelationalSqlParser.SubqueryRelationContext ctx) {
        return new TableSubquery(this.getLocation((ParserRuleContext)ctx), (Query)this.visit((ParseTree)ctx.query()));
    }

    public Node visitParenthesizedRelation(RelationalSqlParser.ParenthesizedRelationContext ctx) {
        return (Node)this.visit((ParseTree)ctx.relation());
    }

    public Node visitTableFunctionInvocation(RelationalSqlParser.TableFunctionInvocationContext context) {
        return (Node)this.visit((ParseTree)context.tableFunctionCall());
    }

    public Node visitTableFunctionInvocationWithTableKeyWord(RelationalSqlParser.TableFunctionInvocationWithTableKeyWordContext ctx) {
        return (Node)this.visit((ParseTree)ctx.tableFunctionCall());
    }

    public Node visitTableFunctionCall(RelationalSqlParser.TableFunctionCallContext context) {
        QualifiedName name = this.getQualifiedName(context.qualifiedName());
        List<TableFunctionArgument> arguments = this.visit(context.tableFunctionArgument(), TableFunctionArgument.class);
        return new TableFunctionInvocation(this.getLocation((ParserRuleContext)context), name, arguments);
    }

    public Node visitTableFunctionArgument(RelationalSqlParser.TableFunctionArgumentContext context) {
        Optional<Identifier> name = this.visitIfPresent((ParserRuleContext)context.identifier(), Identifier.class);
        Node value = context.tableArgument() != null ? (Node)this.visit((ParseTree)context.tableArgument()) : (Node)this.visit((ParseTree)context.scalarArgument());
        return new TableFunctionArgument(this.getLocation((ParserRuleContext)context), name, value);
    }

    public Node visitTableArgument(RelationalSqlParser.TableArgumentContext context) {
        Relation table = (Relation)this.visit((ParseTree)context.tableArgumentRelation());
        Optional<List<Expression>> partitionBy = Optional.empty();
        if (context.PARTITION() != null) {
            partitionBy = Optional.of(this.visit(context.expression(), Expression.class));
        }
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.getLocation(context.ORDER()), this.visit(context.sortItem(), SortItem.class)));
        }
        return new TableFunctionTableArgument(this.getLocation((ParserRuleContext)context), table, partitionBy, orderBy);
    }

    private Node visitTableArgumentAlias(NodeLocation nodeLocation, Relation relation, RelationalSqlParser.IdentifierContext identifierContext, TerminalNode as, RelationalSqlParser.ColumnAliasesContext columnAliasesContext) {
        if (identifierContext != null) {
            Identifier alias = (Identifier)this.visit((ParseTree)identifierContext);
            if (as == null) {
                AstBuilder.validateArgumentAlias(alias, (ParserRuleContext)identifierContext);
            }
            List<Identifier> columnNames = null;
            if (columnAliasesContext != null) {
                columnNames = this.visit(columnAliasesContext.identifier(), Identifier.class);
            }
            relation = new AliasedRelation(nodeLocation, relation, alias, columnNames);
        }
        return relation;
    }

    public Node visitTableArgumentTableWithTableKeyWord(RelationalSqlParser.TableArgumentTableWithTableKeyWordContext context) {
        Table relation = new Table(this.getLocation(context.TABLE()), this.getQualifiedName(context.qualifiedName()));
        return this.visitTableArgumentAlias(this.getLocation(context.TABLE()), relation, context.identifier(), context.AS(), context.columnAliases());
    }

    public Node visitTableArgumentTable(RelationalSqlParser.TableArgumentTableContext context) {
        Table relation = new Table(this.getLocation((ParserRuleContext)context.qualifiedName()), this.getQualifiedName(context.qualifiedName()));
        return this.visitTableArgumentAlias(this.getLocation((ParserRuleContext)context.qualifiedName()), relation, context.identifier(), context.AS(), context.columnAliases());
    }

    public Node visitTableArgumentQueryWithTableKeyWord(RelationalSqlParser.TableArgumentQueryWithTableKeyWordContext context) {
        TableSubquery relation = new TableSubquery(this.getLocation(context.TABLE()), (Query)this.visit((ParseTree)context.query()));
        return this.visitTableArgumentAlias(this.getLocation(context.TABLE()), relation, context.identifier(), context.AS(), context.columnAliases());
    }

    public Node visitTableArgumentQuery(RelationalSqlParser.TableArgumentQueryContext context) {
        TableSubquery relation = new TableSubquery(this.getLocation((ParserRuleContext)context.query()), (Query)this.visit((ParseTree)context.query()));
        return this.visitTableArgumentAlias(this.getLocation((ParserRuleContext)context.query()), relation, context.identifier(), context.AS(), context.columnAliases());
    }

    public Node visitScalarArgument(RelationalSqlParser.ScalarArgumentContext ctx) {
        if (ctx.expression() != null) {
            return (Node)this.visit((ParseTree)ctx.expression());
        }
        TimeDuration timeDuration = DateTimeUtils.constructTimeDuration(ctx.timeDuration().getText());
        if (timeDuration.monthDuration != 0) {
            throw new SemanticException("Setting monthly intervals is not supported.");
        }
        return new LongLiteral(this.getLocation((ParserRuleContext)ctx.timeDuration()), String.valueOf(timeDuration.getTotalDuration(TimestampPrecisionUtils.currPrecision)));
    }

    public Node visitPredicated(RelationalSqlParser.PredicatedContext ctx) {
        if (ctx.predicate() != null) {
            return (Node)this.visit((ParseTree)ctx.predicate());
        }
        return (Node)this.visit((ParseTree)ctx.valueExpression);
    }

    public Node visitComparison(RelationalSqlParser.ComparisonContext ctx) {
        return new ComparisonExpression(this.getLocation((ParserRuleContext)ctx.comparisonOperator()), AstBuilder.getComparisonOperator(((TerminalNode)ctx.comparisonOperator().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)ctx.value), (Expression)this.visit((ParseTree)ctx.right));
    }

    public Node visitQuantifiedComparison(RelationalSqlParser.QuantifiedComparisonContext ctx) {
        return new QuantifiedComparisonExpression(this.getLocation((ParserRuleContext)ctx.comparisonOperator()), AstBuilder.getComparisonOperator(((TerminalNode)ctx.comparisonOperator().getChild(0)).getSymbol()), AstBuilder.getComparisonQuantifier(((TerminalNode)ctx.comparisonQuantifier().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)ctx.value), new SubqueryExpression(this.getLocation((ParserRuleContext)ctx.query()), (Query)this.visit((ParseTree)ctx.query())));
    }

    public Node visitBetween(RelationalSqlParser.BetweenContext ctx) {
        Expression expression = new BetweenPredicate(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.value), (Expression)this.visit((ParseTree)ctx.lower), (Expression)this.visit((ParseTree)ctx.upper));
        if (ctx.NOT() != null) {
            expression = new NotExpression(this.getLocation((ParserRuleContext)ctx), expression);
        }
        return expression;
    }

    public Node visitInList(RelationalSqlParser.InListContext ctx) {
        Expression result = new InPredicate(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.value), new InListExpression(this.getLocation((ParserRuleContext)ctx), this.visit(ctx.expression(), Expression.class)));
        if (ctx.NOT() != null) {
            result = new NotExpression(this.getLocation((ParserRuleContext)ctx), result);
        }
        return result;
    }

    public Node visitInSubquery(RelationalSqlParser.InSubqueryContext ctx) {
        Expression result = new InPredicate(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.value), new SubqueryExpression(this.getLocation((ParserRuleContext)ctx), (Query)this.visit((ParseTree)ctx.query())));
        if (ctx.NOT() != null) {
            result = new NotExpression(this.getLocation((ParserRuleContext)ctx), result);
        }
        return result;
    }

    public Node visitLike(RelationalSqlParser.LikeContext ctx) {
        Expression result = ctx.escape != null ? new LikePredicate(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.value), (Expression)this.visit((ParseTree)ctx.pattern), (Expression)this.visit((ParseTree)ctx.escape)) : new LikePredicate(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.value), (Expression)this.visit((ParseTree)ctx.pattern));
        if (ctx.NOT() != null) {
            result = new NotExpression(this.getLocation((ParserRuleContext)ctx), result);
        }
        return result;
    }

    public Node visitNullPredicate(RelationalSqlParser.NullPredicateContext ctx) {
        Expression child = (Expression)this.visit((ParseTree)ctx.value);
        if (ctx.NOT() == null) {
            return new IsNullPredicate(this.getLocation((ParserRuleContext)ctx), child);
        }
        return new IsNotNullPredicate(this.getLocation((ParserRuleContext)ctx), child);
    }

    public Node visitDistinctFrom(RelationalSqlParser.DistinctFromContext ctx) {
        Expression expression = new ComparisonExpression(this.getLocation((ParserRuleContext)ctx), ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)ctx.value), (Expression)this.visit((ParseTree)ctx.right));
        if (ctx.NOT() != null) {
            expression = new NotExpression(this.getLocation((ParserRuleContext)ctx), expression);
        }
        return expression;
    }

    public Node visitExists(RelationalSqlParser.ExistsContext ctx) {
        return new ExistsPredicate(this.getLocation((ParserRuleContext)ctx), new SubqueryExpression(this.getLocation((ParserRuleContext)ctx), (Query)this.visit((ParseTree)ctx.query())));
    }

    public Node visitArithmeticUnary(RelationalSqlParser.ArithmeticUnaryContext ctx) {
        Expression child = (Expression)this.visit((ParseTree)ctx.valueExpression());
        switch (ctx.operator.getType()) {
            case 419: {
                return ArithmeticUnaryExpression.negative(this.getLocation((ParserRuleContext)ctx), child);
            }
            case 418: {
                return ArithmeticUnaryExpression.positive(this.getLocation((ParserRuleContext)ctx), child);
            }
        }
        throw new UnsupportedOperationException("Unsupported sign: " + ctx.operator.getText());
    }

    public Node visitArithmeticBinary(RelationalSqlParser.ArithmeticBinaryContext ctx) {
        return new ArithmeticBinaryExpression(this.getLocation(ctx.operator), AstBuilder.getArithmeticBinaryOperator(ctx.operator), (Expression)this.visit((ParseTree)ctx.left), (Expression)this.visit((ParseTree)ctx.right));
    }

    public Node visitConcatenation(RelationalSqlParser.ConcatenationContext ctx) {
        return new FunctionCall(this.getLocation(ctx.CONCAT()), QualifiedName.of(TableBuiltinScalarFunction.CONCAT.getFunctionName()), (List<Expression>)ImmutableList.of((Object)((Expression)this.visit((ParseTree)ctx.left)), (Object)((Expression)this.visit((ParseTree)ctx.right))));
    }

    public Node visitOver(RelationalSqlParser.OverContext ctx) {
        if (ctx.windowName != null) {
            return new WindowReference(this.getLocation((ParserRuleContext)ctx), (Identifier)this.visit((ParseTree)ctx.windowName));
        }
        return (Node)this.visit((ParseTree)ctx.windowSpecification());
    }

    public Node visitWindowDefinition(RelationalSqlParser.WindowDefinitionContext ctx) {
        return new WindowDefinition(this.getLocation((ParserRuleContext)ctx), (Identifier)this.visit((ParseTree)ctx.name), (WindowSpecification)this.visit((ParseTree)ctx.windowSpecification()));
    }

    public Node visitWindowSpecification(RelationalSqlParser.WindowSpecificationContext ctx) {
        Optional<Identifier> existingWindowName = this.getIdentifierIfPresent((ParserRuleContext)ctx.existingWindowName);
        List<Expression> partitionBy = this.visit(ctx.partition, Expression.class);
        Optional<OrderBy> orderBy = Optional.empty();
        if (ctx.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.getLocation(ctx.ORDER()), this.visit(ctx.sortItem(), SortItem.class)));
        }
        Optional<WindowFrame> frame = Optional.empty();
        if (ctx.windowFrame() != null) {
            frame = Optional.of((WindowFrame)this.visitFrameExtent(ctx.windowFrame().frameExtent()));
        }
        return new WindowSpecification(this.getLocation((ParserRuleContext)ctx), existingWindowName, partitionBy, orderBy, frame);
    }

    public Node visitFrameExtent(RelationalSqlParser.FrameExtentContext ctx) {
        WindowFrame.Type frameType = AstBuilder.toWindowFrameType(ctx.frameType);
        FrameBound start = (FrameBound)this.visit((ParseTree)ctx.start);
        Optional<FrameBound> end = this.visitIfPresent((ParserRuleContext)ctx.end, FrameBound.class);
        return new WindowFrame(this.getLocation((ParserRuleContext)ctx), frameType, start, end);
    }

    private static WindowFrame.Type toWindowFrameType(Token token) {
        switch (token.getType()) {
            case 312: {
                return WindowFrame.Type.ROWS;
            }
            case 283: {
                return WindowFrame.Type.RANGE;
            }
            case 149: {
                return WindowFrame.Type.GROUPS;
            }
        }
        throw new IllegalArgumentException("Unsupported window frame type: " + token.getText());
    }

    public Node visitUnboundedFrame(RelationalSqlParser.UnboundedFrameContext ctx) {
        switch (ctx.boundType.getType()) {
            case 271: {
                return new FrameBound(this.getLocation((ParserRuleContext)ctx), FrameBound.Type.UNBOUNDED_PRECEDING);
            }
            case 135: {
                return new FrameBound(this.getLocation((ParserRuleContext)ctx), FrameBound.Type.UNBOUNDED_FOLLOWING);
            }
        }
        throw new IllegalArgumentException("Unsupported unbounded type: " + ctx.boundType.getText());
    }

    public Node visitCurrentRowBound(RelationalSqlParser.CurrentRowBoundContext ctx) {
        return new FrameBound(this.getLocation((ParserRuleContext)ctx), FrameBound.Type.CURRENT_ROW);
    }

    public Node visitBoundedFrame(RelationalSqlParser.BoundedFrameContext ctx) {
        Expression value = (Expression)this.visit((ParseTree)ctx.expression());
        switch (ctx.boundType.getType()) {
            case 271: {
                return new FrameBound(this.getLocation((ParserRuleContext)ctx), FrameBound.Type.PRECEDING, value);
            }
            case 135: {
                return new FrameBound(this.getLocation((ParserRuleContext)ctx), FrameBound.Type.FOLLOWING, value);
            }
        }
        throw new IllegalArgumentException("Unsupported bounded type: " + ctx.boundType.getText());
    }

    public Node visitParenthesizedExpression(RelationalSqlParser.ParenthesizedExpressionContext ctx) {
        return (Node)this.visit((ParseTree)ctx.expression());
    }

    public Node visitRowConstructor(RelationalSqlParser.RowConstructorContext context) {
        return new Row(this.getLocation((ParserRuleContext)context), this.visit(context.expression(), Expression.class));
    }

    public Node visitCast(RelationalSqlParser.CastContext ctx) {
        boolean isTryCast = ctx.TRY_CAST() != null;
        return new Cast(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.expression()), (DataType)this.visit((ParseTree)ctx.type()), isTryCast);
    }

    public Node visitSpecialDateTimeFunction(RelationalSqlParser.SpecialDateTimeFunctionContext ctx) {
        CurrentTime.Function function = AstBuilder.getDateTimeFunctionType(ctx.name);
        return new CurrentTime(this.getLocation((ParserRuleContext)ctx), function);
    }

    public Node visitDateTimeExpression(RelationalSqlParser.DateTimeExpressionContext ctx) {
        return new LongLiteral(this.getLocation((ParserRuleContext)ctx), String.valueOf(this.parseDateExpression(ctx.dateExpression(), CommonDateTimeUtils.currentTime())));
    }

    private Long parseDateExpression(RelationalSqlParser.DateExpressionContext ctx, long currentTime) {
        long time = ASTVisitor.parseDateTimeFormat(ctx.getChild(0).getText(), currentTime, this.zoneId);
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText(), false);
                continue;
            }
            time -= DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText(), false);
        }
        return time;
    }

    public Node visitTrim(RelationalSqlParser.TrimContext ctx) {
        Trim.Specification specification;
        if (ctx.FROM() != null && ctx.trimsSpecification() == null && ctx.trimChar == null) {
            throw AstBuilder.parseError("The 'trim' function must have specification, char or both arguments when it takes FROM", (ParserRuleContext)ctx);
        }
        Trim.Specification specification2 = specification = ctx.trimsSpecification() == null ? Trim.Specification.BOTH : AstBuilder.toTrimSpecification((Token)ctx.trimsSpecification().getChild(0).getPayload());
        if (ctx.trimChar != null) {
            return new Trim(this.getLocation((ParserRuleContext)ctx), specification, (Expression)this.visit((ParseTree)ctx.trimSource), (Expression)this.visit((ParseTree)ctx.trimChar));
        }
        return new Trim(this.getLocation((ParserRuleContext)ctx), specification, (Expression)this.visit((ParseTree)ctx.trimSource));
    }

    private static Trim.Specification toTrimSpecification(Token token) {
        switch (token.getType()) {
            case 37: {
                return Trim.Specification.BOTH;
            }
            case 188: {
                return Trim.Specification.LEADING;
            }
            case 363: {
                return Trim.Specification.TRAILING;
            }
        }
        throw new IllegalArgumentException("Unsupported trim specification: " + token.getText());
    }

    public Node visitSubstring(RelationalSqlParser.SubstringContext ctx) {
        return new FunctionCall(this.getLocation((ParserRuleContext)ctx), QualifiedName.of("substring"), this.visit(ctx.valueExpression(), Expression.class));
    }

    public Node visitCurrentDatabase(RelationalSqlParser.CurrentDatabaseContext ctx) {
        return new CurrentDatabase(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitCurrentUser(RelationalSqlParser.CurrentUserContext ctx) {
        return new CurrentUser(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitExtract(RelationalSqlParser.ExtractContext context) {
        Extract.Field field;
        String fieldString = context.identifier().getText();
        try {
            field = Extract.Field.valueOf(fieldString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw AstBuilder.parseError("Invalid EXTRACT field: " + fieldString, (ParserRuleContext)context);
        }
        return new Extract(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.valueExpression()), field);
    }

    public Node visitSubqueryExpression(RelationalSqlParser.SubqueryExpressionContext ctx) {
        return new SubqueryExpression(this.getLocation((ParserRuleContext)ctx), (Query)this.visit((ParseTree)ctx.query()));
    }

    public Node visitDereference(RelationalSqlParser.DereferenceContext ctx) {
        return new DereferenceExpression(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.base), (Identifier)this.visit((ParseTree)ctx.fieldName));
    }

    public Node visitColumnReference(RelationalSqlParser.ColumnReferenceContext ctx) {
        return (Node)this.visit((ParseTree)ctx.identifier());
    }

    public Node visitSimpleCase(RelationalSqlParser.SimpleCaseContext ctx) {
        if (ctx.elseExpression != null) {
            return new SimpleCaseExpression(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.operand), this.visit(ctx.whenClause(), WhenClause.class), (Expression)this.visit((ParseTree)ctx.elseExpression));
        }
        return new SimpleCaseExpression(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.operand), this.visit(ctx.whenClause(), WhenClause.class));
    }

    public Node visitSearchedCase(RelationalSqlParser.SearchedCaseContext ctx) {
        if (ctx.elseExpression != null) {
            return new SearchedCaseExpression(this.getLocation((ParserRuleContext)ctx), this.visit(ctx.whenClause(), WhenClause.class), (Expression)this.visit((ParseTree)ctx.elseExpression));
        }
        return new SearchedCaseExpression(this.getLocation((ParserRuleContext)ctx), this.visit(ctx.whenClause(), WhenClause.class));
    }

    public Node visitWhenClause(RelationalSqlParser.WhenClauseContext ctx) {
        return new WhenClause(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.condition), (Expression)this.visit((ParseTree)ctx.result));
    }

    public Node visitFunctionCall(RelationalSqlParser.FunctionCallContext ctx) {
        Optional<Window> window = this.visitIfPresent((ParserRuleContext)ctx.over(), Window.class);
        QualifiedName name = this.getQualifiedName(ctx.qualifiedName());
        boolean distinct = AstBuilder.isDistinct(ctx.setQuantifier());
        RelationalSqlParser.ProcessingModeContext processingMode = ctx.processingMode();
        RelationalSqlParser.NullTreatmentContext nullTreatment = ctx.nullTreatment();
        if (name.toString().equalsIgnoreCase("if")) {
            AstBuilder.check(ctx.expression().size() == 2 || ctx.expression().size() == 3, "Invalid number of arguments for 'if' function", (ParserRuleContext)ctx);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'if' function", (ParserRuleContext)ctx);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for 'if' function", (ParserRuleContext)ctx);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for 'if' function", (ParserRuleContext)ctx);
            Expression elseExpression = null;
            if (ctx.expression().size() == 3) {
                elseExpression = (Expression)this.visit((ParseTree)ctx.expression(2));
            }
            return new IfExpression(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.expression(0)), (Expression)this.visit((ParseTree)ctx.expression(1)), elseExpression);
        }
        if (name.toString().equalsIgnoreCase("nullif")) {
            AstBuilder.check(ctx.expression().size() == 2, "Invalid number of arguments for 'nullif' function", (ParserRuleContext)ctx);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'nullif' function", (ParserRuleContext)ctx);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for 'nullif' function", (ParserRuleContext)ctx);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for 'nullif' function", (ParserRuleContext)ctx);
            return new NullIfExpression(this.getLocation((ParserRuleContext)ctx), (Expression)this.visit((ParseTree)ctx.expression(0)), (Expression)this.visit((ParseTree)ctx.expression(1)));
        }
        if (name.toString().equalsIgnoreCase("coalesce")) {
            AstBuilder.check(ctx.expression().size() >= 2, "The 'coalesce' function must have at least two arguments", (ParserRuleContext)ctx);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'coalesce' function", (ParserRuleContext)ctx);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for 'coalesce' function", (ParserRuleContext)ctx);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for 'coalesce' function", (ParserRuleContext)ctx);
            return new CoalesceExpression(this.getLocation((ParserRuleContext)ctx), this.visit(ctx.expression(), Expression.class));
        }
        Optional<ProcessingMode> mode = Optional.empty();
        if (processingMode != null) {
            if (processingMode.RUNNING() != null) {
                mode = Optional.of(new ProcessingMode(this.getLocation((ParserRuleContext)processingMode), ProcessingMode.Mode.RUNNING));
            } else if (processingMode.FINAL() != null) {
                mode = Optional.of(new ProcessingMode(this.getLocation((ParserRuleContext)processingMode), ProcessingMode.Mode.FINAL));
            }
        }
        Optional<FunctionCall.NullTreatment> nulls = Optional.empty();
        if (nullTreatment != null) {
            if (nullTreatment.IGNORE() != null) {
                nulls = Optional.of(FunctionCall.NullTreatment.IGNORE);
            } else if (nullTreatment.RESPECT() != null) {
                nulls = Optional.of(FunctionCall.NullTreatment.RESPECT);
            }
        }
        ImmutableList arguments = this.visit(ctx.expression(), Expression.class);
        if (ctx.label != null) {
            arguments = ImmutableList.of((Object)new DereferenceExpression(this.getLocation((ParserRuleContext)ctx.label), (Identifier)this.visit((ParseTree)ctx.label)));
        }
        if (name.toString().equalsIgnoreCase("first") || name.toString().equalsIgnoreCase("last")) {
            if (arguments.size() == 1) {
                arguments.add(new Identifier("Time".toLowerCase(Locale.ENGLISH)));
            } else if (arguments.size() == 2) {
                AstBuilder.check(((Expression)arguments.get(1)).toString().equalsIgnoreCase("Time"), "The second argument of 'first' or 'last' function must be 'time'", (ParserRuleContext)ctx);
            }
        } else if (name.toString().equalsIgnoreCase("first_by") || name.toString().equalsIgnoreCase("last_by")) {
            if (arguments.size() == 2) {
                arguments.add(new Identifier("Time".toLowerCase(Locale.ENGLISH)));
            } else if (arguments.size() == 3) {
                AstBuilder.check(((Expression)arguments.get(2)).toString().equalsIgnoreCase("Time"), "The third argument of 'first_by' or 'last_by' function must be 'time'", (ParserRuleContext)ctx);
            }
        } else if (name.toString().equalsIgnoreCase("approx_count_distinct")) {
            if (!(arguments.size() != 2 || arguments.get(1) instanceof DoubleLiteral || arguments.get(1) instanceof LongLiteral || arguments.get(1) instanceof StringLiteral)) {
                throw new SemanticException("The second argument of 'approx_count_distinct' function must be a literal");
            }
        } else if (!(!name.toString().equalsIgnoreCase("approx_most_frequent") || arguments.size() != 3 || arguments.get(1) instanceof LongLiteral && arguments.get(2) instanceof LongLiteral)) {
            throw new SemanticException("The second and third argument of 'approx_most_frequent' function must be positive integer literal");
        }
        return new FunctionCall(this.getLocation((ParserRuleContext)ctx), name, window, nulls, distinct, mode, (List<Expression>)arguments);
    }

    public Node visitDateBinGapFill(RelationalSqlParser.DateBinGapFillContext ctx) {
        TimeDuration timeDuration = DateTimeUtils.constructTimeDuration(ctx.timeDuration().getText());
        if (timeDuration.monthDuration != 0 && timeDuration.nonMonthDuration != 0L) {
            throw new SemanticException("Simultaneous setting of monthly and non-monthly intervals is not supported.");
        }
        LongLiteral monthDuration = new LongLiteral(this.getLocation((ParserRuleContext)ctx.timeDuration()), String.valueOf(timeDuration.monthDuration));
        LongLiteral nonMonthDuration = new LongLiteral(this.getLocation((ParserRuleContext)ctx.timeDuration()), String.valueOf(timeDuration.nonMonthDuration));
        LongLiteral origin = ctx.timeValue() == null ? new LongLiteral("0") : new LongLiteral(this.getLocation((ParserRuleContext)ctx.timeValue()), String.valueOf(this.parseTimeValue(ctx.timeValue(), CommonDateTimeUtils.currentTime())));
        List<Expression> arguments = Arrays.asList(monthDuration, nonMonthDuration, (Expression)this.visit((ParseTree)ctx.valueExpression()), origin, new BooleanLiteral("true"));
        return new FunctionCall(this.getLocation((ParserRuleContext)ctx), QualifiedName.of(TableBuiltinScalarFunction.DATE_BIN.getFunctionName()), arguments);
    }

    public Node visitDateBin(RelationalSqlParser.DateBinContext ctx) {
        TimeDuration timeDuration = DateTimeUtils.constructTimeDuration(ctx.timeDuration().getText());
        if (timeDuration.monthDuration != 0 && timeDuration.nonMonthDuration != 0L) {
            throw new SemanticException("Simultaneous setting of monthly and non-monthly intervals is not supported.");
        }
        LongLiteral monthDuration = new LongLiteral(this.getLocation((ParserRuleContext)ctx.timeDuration()), String.valueOf(timeDuration.monthDuration));
        LongLiteral nonMonthDuration = new LongLiteral(this.getLocation((ParserRuleContext)ctx.timeDuration()), String.valueOf(timeDuration.nonMonthDuration));
        LongLiteral origin = ctx.timeValue() == null ? new LongLiteral("0") : new LongLiteral(this.getLocation((ParserRuleContext)ctx.timeValue()), String.valueOf(this.parseTimeValue(ctx.timeValue(), CommonDateTimeUtils.currentTime())));
        List<Expression> arguments = Arrays.asList(monthDuration, nonMonthDuration, (Expression)this.visit((ParseTree)ctx.valueExpression()), origin);
        return new FunctionCall(this.getLocation((ParserRuleContext)ctx), QualifiedName.of(TableBuiltinScalarFunction.DATE_BIN.getFunctionName()), arguments);
    }

    private long parseTimeValue(RelationalSqlParser.TimeValueContext ctx, long currentTime) {
        if (ctx.INTEGER_VALUE() != null) {
            try {
                if (ctx.MINUS() != null) {
                    return -Long.parseLong(ctx.INTEGER_VALUE().getText());
                }
                return Long.parseLong(ctx.INTEGER_VALUE().getText());
            }
            catch (NumberFormatException e) {
                throw new SemanticException(String.format("Can not parse %s to long value", ctx.INTEGER_VALUE().getText()));
            }
        }
        return this.parseDateExpression(ctx.dateExpression(), currentTime);
    }

    public Node visitColumns(RelationalSqlParser.ColumnsContext ctx) {
        String pattern = null;
        RelationalSqlParser.StringContext context = ctx.pattern;
        if (context != null) {
            pattern = AstBuilder.unquote(context.getText());
        }
        return new Columns(this.getLocation((ParserRuleContext)ctx), pattern);
    }

    public Node visitPatternAlternation(RelationalSqlParser.PatternAlternationContext context) {
        List<RowPattern> parts = this.visit(context.rowPattern(), RowPattern.class);
        return new PatternAlternation(this.getLocation((ParserRuleContext)context), parts);
    }

    public Node visitPatternConcatenation(RelationalSqlParser.PatternConcatenationContext context) {
        List<RowPattern> parts = this.visit(context.rowPattern(), RowPattern.class);
        return new PatternConcatenation(this.getLocation((ParserRuleContext)context), parts);
    }

    public Node visitQuantifiedPrimary(RelationalSqlParser.QuantifiedPrimaryContext context) {
        RowPattern primary = (RowPattern)this.visit((ParseTree)context.patternPrimary());
        if (context.patternQuantifier() != null) {
            return new QuantifiedPattern(this.getLocation((ParserRuleContext)context), primary, (PatternQuantifier)this.visit((ParseTree)context.patternQuantifier()));
        }
        return primary;
    }

    public Node visitPatternVariable(RelationalSqlParser.PatternVariableContext context) {
        return new PatternVariable(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitEmptyPattern(RelationalSqlParser.EmptyPatternContext context) {
        return new EmptyPattern(this.getLocation((ParserRuleContext)context));
    }

    public Node visitPatternPermutation(RelationalSqlParser.PatternPermutationContext context) {
        return new PatternPermutation(this.getLocation((ParserRuleContext)context), this.visit(context.rowPattern(), RowPattern.class));
    }

    public Node visitGroupedPattern(RelationalSqlParser.GroupedPatternContext context) {
        return (Node)this.visit((ParseTree)context.rowPattern());
    }

    public Node visitPartitionStartAnchor(RelationalSqlParser.PartitionStartAnchorContext context) {
        return new AnchorPattern(this.getLocation((ParserRuleContext)context), AnchorPattern.Type.PARTITION_START);
    }

    public Node visitPartitionEndAnchor(RelationalSqlParser.PartitionEndAnchorContext context) {
        return new AnchorPattern(this.getLocation((ParserRuleContext)context), AnchorPattern.Type.PARTITION_END);
    }

    public Node visitExcludedPattern(RelationalSqlParser.ExcludedPatternContext context) {
        return new ExcludedPattern(this.getLocation((ParserRuleContext)context), (RowPattern)this.visit((ParseTree)context.rowPattern()));
    }

    public Node visitZeroOrMoreQuantifier(RelationalSqlParser.ZeroOrMoreQuantifierContext context) {
        boolean greedy = context.reluctant == null;
        return new ZeroOrMoreQuantifier(this.getLocation((ParserRuleContext)context), greedy);
    }

    public Node visitOneOrMoreQuantifier(RelationalSqlParser.OneOrMoreQuantifierContext context) {
        boolean greedy = context.reluctant == null;
        return new OneOrMoreQuantifier(this.getLocation((ParserRuleContext)context), greedy);
    }

    public Node visitZeroOrOneQuantifier(RelationalSqlParser.ZeroOrOneQuantifierContext context) {
        boolean greedy = context.reluctant == null;
        return new ZeroOrOneQuantifier(this.getLocation((ParserRuleContext)context), greedy);
    }

    public Node visitRangeQuantifier(RelationalSqlParser.RangeQuantifierContext context) {
        boolean greedy = context.reluctant == null;
        Optional<Object> atLeast = Optional.empty();
        Optional<LongLiteral> atMost = Optional.empty();
        if (context.exactly != null) {
            atLeast = Optional.of(new LongLiteral(this.getLocation(context.exactly), context.exactly.getText()));
            atMost = Optional.of(new LongLiteral(this.getLocation(context.exactly), context.exactly.getText()));
        }
        if (context.atLeast != null) {
            atLeast = Optional.of(new LongLiteral(this.getLocation(context.atLeast), context.atLeast.getText()));
        }
        if (context.atMost != null) {
            atMost = Optional.of(new LongLiteral(this.getLocation(context.atMost), context.atMost.getText()));
        }
        return new RangeQuantifier(this.getLocation((ParserRuleContext)context), greedy, atLeast, atMost);
    }

    public Node visitNullLiteral(RelationalSqlParser.NullLiteralContext ctx) {
        return new NullLiteral(this.getLocation((ParserRuleContext)ctx));
    }

    public Node visitBasicStringLiteral(RelationalSqlParser.BasicStringLiteralContext ctx) {
        return new StringLiteral(this.getLocation((ParserRuleContext)ctx), AstBuilder.unquote(ctx.STRING().getText()));
    }

    public Node visitUnicodeStringLiteral(RelationalSqlParser.UnicodeStringLiteralContext ctx) {
        return new StringLiteral(this.getLocation((ParserRuleContext)ctx), AstBuilder.decodeUnicodeLiteral(ctx));
    }

    public Node visitBinaryLiteral(RelationalSqlParser.BinaryLiteralContext ctx) {
        String raw = ctx.BINARY_LITERAL().getText();
        return new BinaryLiteral(this.getLocation((ParserRuleContext)ctx), AstBuilder.unquote(raw.substring(1)));
    }

    public Node visitDecimalLiteral(RelationalSqlParser.DecimalLiteralContext ctx) {
        return new DoubleLiteral(this.getLocation((ParserRuleContext)ctx), ctx.getText());
    }

    public Node visitDoubleLiteral(RelationalSqlParser.DoubleLiteralContext ctx) {
        return new DoubleLiteral(this.getLocation((ParserRuleContext)ctx), ctx.getText());
    }

    public Node visitIntegerLiteral(RelationalSqlParser.IntegerLiteralContext ctx) {
        return new LongLiteral(this.getLocation((ParserRuleContext)ctx), ctx.getText());
    }

    public Node visitBooleanLiteral(RelationalSqlParser.BooleanLiteralContext ctx) {
        return new BooleanLiteral(this.getLocation((ParserRuleContext)ctx), ctx.getText());
    }

    public Node visitDatetimeLiteral(RelationalSqlParser.DatetimeLiteralContext ctx) {
        return new LongLiteral(this.getLocation((ParserRuleContext)ctx), String.valueOf(ASTVisitor.parseDateTimeFormat(ctx.getChild(0).getText(), CommonDateTimeUtils.currentTime(), this.zoneId)));
    }

    public Node visitParameter(RelationalSqlParser.ParameterContext ctx) {
        Parameter parameter = new Parameter(this.getLocation((ParserRuleContext)ctx), this.parameterPosition);
        ++this.parameterPosition;
        return parameter;
    }

    public Node visitIdentifierOrString(RelationalSqlParser.IdentifierOrStringContext ctx) {
        String s = null;
        if (ctx.identifier() != null) {
            return (Node)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.string() != null) {
            s = ((StringLiteral)this.visit((ParseTree)ctx.string())).getValue();
        }
        return new Identifier(this.getLocation((ParserRuleContext)ctx), s);
    }

    public Node visitIntervalField(RelationalSqlParser.IntervalFieldContext ctx) {
        return (Node)super.visitIntervalField(ctx);
    }

    public static void validateModelId(String modelId) {
        if (modelId.length() < 2 || modelId.length() > 64) {
            throw new SemanticException("ModelId should be 2-64 characters");
        }
        if (modelId.startsWith("_")) {
            throw new SemanticException("ModelId should not start with '_'");
        }
        if (!modelId.matches("^[-\\w]*$")) {
            throw new SemanticException("ModelId can only contain letters, numbers, and underscores");
        }
    }

    private static List<String> convertToDeviceIdList(String rawDeviceString) {
        String[] deviceIdList = rawDeviceString.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String deviceId : deviceIdList) {
            if ((deviceId = deviceId.trim()).equals("cpu")) {
                result.add("cpu");
                continue;
            }
            try {
                Integer.valueOf(deviceId);
            }
            catch (NumberFormatException e) {
                throw new SemanticException("Device id should be 'cpu' or integer");
            }
            result.add(deviceId);
        }
        return result;
    }

    public Node visitCreateModelStatement(RelationalSqlParser.CreateModelStatementContext ctx) {
        String modelId = ctx.modelId.getText();
        AstBuilder.validateModelId(modelId);
        if (ctx.uriClause() == null) {
            if (ctx.targetData == null) {
                throw new SemanticException("Target data in sql should be set in CREATE MODEL");
            }
            String targetData = ((StringLiteral)this.visit((ParseTree)ctx.targetData)).getValue();
            CreateTraining createTraining = new CreateTraining(modelId, targetData);
            if (ctx.HYPERPARAMETERS() != null) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                for (RelationalSqlParser.HparamPairContext hparamPairContext : ctx.hparamPair()) {
                    parameters.put(hparamPairContext.hparamKey.getText(), hparamPairContext.hyparamValue.getText());
                }
                createTraining.setParameters(parameters);
            }
            if (ctx.existingModelId != null) {
                createTraining.setExistingModelId(ctx.existingModelId.getText());
            }
            return createTraining;
        }
        String uri = ((Identifier)this.visit((ParseTree)ctx.uriClause().uri)).getValue();
        return new CreateModel(modelId, uri);
    }

    public Node visitLoadModelStatement(RelationalSqlParser.LoadModelStatementContext ctx) {
        List<String> deviceIds = AstBuilder.convertToDeviceIdList(AstBuilder.unquote(ctx.deviceIdList.getText()));
        String modelId = ctx.existingModelId.getText();
        AstBuilder.validateModelId(modelId);
        return new LoadModel(modelId, deviceIds);
    }

    public Node visitUnloadModelStatement(RelationalSqlParser.UnloadModelStatementContext ctx) {
        List<String> deviceIds = AstBuilder.convertToDeviceIdList(AstBuilder.unquote(ctx.deviceIdList.getText()));
        String modelId = ctx.existingModelId.getText();
        AstBuilder.validateModelId(modelId);
        return new UnloadModel(modelId, deviceIds);
    }

    public Node visitShowModelsStatement(RelationalSqlParser.ShowModelsStatementContext ctx) {
        ShowModels showModels = new ShowModels();
        if (ctx.modelId != null) {
            String modelId = ctx.modelId.getText();
            AstBuilder.validateModelId(modelId);
            showModels.setModelId(modelId);
        }
        return showModels;
    }

    public Node visitShowLoadedModelsStatement(RelationalSqlParser.ShowLoadedModelsStatementContext ctx) {
        return new ShowLoadedModels(ctx.deviceIdList != null ? AstBuilder.convertToDeviceIdList(AstBuilder.unquote(ctx.deviceIdList.getText())) : null);
    }

    public Node visitShowAIDevicesStatement(RelationalSqlParser.ShowAIDevicesStatementContext ctx) {
        return new ShowAIDevices();
    }

    public Node visitDropModelStatement(RelationalSqlParser.DropModelStatementContext ctx) {
        String modelId = ctx.modelId.getText();
        AstBuilder.validateModelId(modelId);
        return new DropModel(modelId);
    }

    public Node visitGenericType(RelationalSqlParser.GenericTypeContext ctx) {
        List parameters = (List)ctx.typeParameter().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(DataTypeParameter.class::cast).collect(ImmutableList.toImmutableList());
        return new GenericDataType(this.getLocation((ParserRuleContext)ctx), (Identifier)this.visit((ParseTree)ctx.identifier()), parameters);
    }

    public Node visitTypeParameter(RelationalSqlParser.TypeParameterContext ctx) {
        if (ctx.INTEGER_VALUE() != null) {
            return new NumericParameter(this.getLocation((ParserRuleContext)ctx), ctx.getText());
        }
        return new TypeParameter((DataType)this.visit((ParseTree)ctx.type()));
    }

    private static String decodeUnicodeLiteral(RelationalSqlParser.UnicodeStringLiteralContext context) {
        char escape;
        if (context.UESCAPE() != null) {
            String escapeString = AstBuilder.unquote(context.STRING().getText());
            AstBuilder.check(!escapeString.isEmpty(), "Empty Unicode escape character", (ParserRuleContext)context);
            AstBuilder.check(escapeString.length() == 1, "Invalid Unicode escape character: " + escapeString, (ParserRuleContext)context);
            escape = escapeString.charAt(0);
            AstBuilder.check(AstBuilder.isValidUnicodeEscape(escape), "Invalid Unicode escape character: " + escapeString, (ParserRuleContext)context);
        } else {
            escape = '\\';
        }
        String rawContent = AstBuilder.unquote(context.UNICODE_STRING().getText().substring(2));
        StringBuilder unicodeStringBuilder = new StringBuilder();
        StringBuilder escapedCharacterBuilder = new StringBuilder();
        int charactersNeeded = 0;
        UnicodeDecodeState state = UnicodeDecodeState.EMPTY;
        block5: for (int i = 0; i < rawContent.length(); ++i) {
            char ch = rawContent.charAt(i);
            switch (state) {
                case EMPTY: {
                    if (ch == escape) {
                        state = UnicodeDecodeState.ESCAPED;
                        continue block5;
                    }
                    unicodeStringBuilder.append(ch);
                    continue block5;
                }
                case ESCAPED: {
                    if (ch == escape) {
                        unicodeStringBuilder.append(escape);
                        state = UnicodeDecodeState.EMPTY;
                        continue block5;
                    }
                    if (ch == '+') {
                        state = UnicodeDecodeState.UNICODE_SEQUENCE;
                        charactersNeeded = 6;
                        continue block5;
                    }
                    if (AstBuilder.isHexDigit(ch)) {
                        state = UnicodeDecodeState.UNICODE_SEQUENCE;
                        charactersNeeded = 4;
                        escapedCharacterBuilder.append(ch);
                        continue block5;
                    }
                    throw AstBuilder.parseError("Invalid hexadecimal digit: " + ch, (ParserRuleContext)context);
                }
                case UNICODE_SEQUENCE: {
                    AstBuilder.check(AstBuilder.isHexDigit(ch), "Incomplete escape sequence: " + escapedCharacterBuilder, (ParserRuleContext)context);
                    escapedCharacterBuilder.append(ch);
                    if (charactersNeeded == escapedCharacterBuilder.length()) {
                        String currentEscapedCode = escapedCharacterBuilder.toString();
                        escapedCharacterBuilder.setLength(0);
                        int codePoint = Integer.parseInt(currentEscapedCode, 16);
                        AstBuilder.check(Character.isValidCodePoint(codePoint), "Invalid escaped character: " + currentEscapedCode, (ParserRuleContext)context);
                        if (Character.isSupplementaryCodePoint(codePoint)) {
                            unicodeStringBuilder.appendCodePoint(codePoint);
                        } else {
                            char currentCodePoint = (char)codePoint;
                            if (Character.isSurrogate(currentCodePoint)) {
                                throw AstBuilder.parseError(String.format("Invalid escaped character: %s. Escaped character is a surrogate. Use '\\+123456' instead.", currentEscapedCode), (ParserRuleContext)context);
                            }
                            unicodeStringBuilder.append(currentCodePoint);
                        }
                        state = UnicodeDecodeState.EMPTY;
                        charactersNeeded = -1;
                        continue block5;
                    }
                    AstBuilder.check(charactersNeeded > escapedCharacterBuilder.length(), "Unexpected escape sequence length: " + escapedCharacterBuilder.length(), (ParserRuleContext)context);
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        AstBuilder.check(state == UnicodeDecodeState.EMPTY, "Incomplete escape sequence: " + escapedCharacterBuilder.toString(), (ParserRuleContext)context);
        return unicodeStringBuilder.toString();
    }

    private <T> Optional<T> visitIfPresent(ParserRuleContext context, Class<T> clazz) {
        return Optional.ofNullable(context).map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast);
    }

    private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        return contexts.stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast).collect(Collectors.toList());
    }

    private static String unquote(String value) {
        return value.substring(1, value.length() - 1).replace("''", "'");
    }

    private QualifiedName getQualifiedName(RelationalSqlParser.QualifiedNameContext context) {
        return QualifiedName.of(this.visit(context.identifier(), Identifier.class));
    }

    private static boolean isDistinct(RelationalSqlParser.SetQuantifierContext setQuantifier) {
        return setQuantifier != null && setQuantifier.DISTINCT() != null;
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidUnicodeEscape(char c) {
        return c < '\u007f' && c > ' ' && !AstBuilder.isHexDigit(c) && c != '\"' && c != '+' && c != '\'';
    }

    private static Optional<String> getTextIfPresent(ParserRuleContext context) {
        return Optional.ofNullable(context).map(ParseTree::getText);
    }

    private Optional<Identifier> getIdentifierIfPresent(ParserRuleContext context) {
        return Optional.ofNullable(context).map(c -> (Identifier)this.visit((ParseTree)c));
    }

    private static TsTableColumnCategory getColumnCategory(Token category) {
        if (category == null) {
            return TsTableColumnCategory.FIELD;
        }
        switch (category.getType()) {
            case 345: {
                return TsTableColumnCategory.TAG;
            }
            case 32: {
                return TsTableColumnCategory.ATTRIBUTE;
            }
            case 350: {
                return TsTableColumnCategory.TIME;
            }
            case 128: {
                return TsTableColumnCategory.FIELD;
            }
        }
        throw new UnsupportedOperationException("Unsupported ColumnCategory: " + category.getText());
    }

    private static ArithmeticBinaryExpression.Operator getArithmeticBinaryOperator(Token operator) {
        switch (operator.getType()) {
            case 418: {
                return ArithmeticBinaryExpression.Operator.ADD;
            }
            case 419: {
                return ArithmeticBinaryExpression.Operator.SUBTRACT;
            }
            case 420: {
                return ArithmeticBinaryExpression.Operator.MULTIPLY;
            }
            case 421: {
                return ArithmeticBinaryExpression.Operator.DIVIDE;
            }
            case 422: {
                return ArithmeticBinaryExpression.Operator.MODULUS;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator.getText());
    }

    private static ComparisonExpression.Operator getComparisonOperator(Token symbol) {
        switch (symbol.getType()) {
            case 412: {
                return ComparisonExpression.Operator.EQUAL;
            }
            case 413: {
                return ComparisonExpression.Operator.NOT_EQUAL;
            }
            case 414: {
                return ComparisonExpression.Operator.LESS_THAN;
            }
            case 415: {
                return ComparisonExpression.Operator.LESS_THAN_OR_EQUAL;
            }
            case 416: {
                return ComparisonExpression.Operator.GREATER_THAN;
            }
            case 417: {
                return ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + symbol.getText());
    }

    private static CurrentTime.Function getDateTimeFunctionType(Token token) {
        switch (token.getType()) {
            case 75: {
                return CurrentTime.Function.DATE;
            }
            case 80: {
                return CurrentTime.Function.TIME;
            }
            case 81: 
            case 236: {
                return CurrentTime.Function.TIMESTAMP;
            }
            case 200: {
                return CurrentTime.Function.LOCALTIME;
            }
            case 201: {
                return CurrentTime.Function.LOCALTIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Unsupported special function: " + token.getText());
    }

    private static SortItem.NullOrdering getNullOrderingType(Token token) {
        switch (token.getType()) {
            case 133: {
                return SortItem.NullOrdering.FIRST;
            }
            case 186: {
                return SortItem.NullOrdering.LAST;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static SortItem.Ordering getOrderingType(Token token) {
        switch (token.getType()) {
            case 29: {
                return SortItem.Ordering.ASCENDING;
            }
            case 100: {
                return SortItem.Ordering.DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static QuantifiedComparisonExpression.Quantifier getComparisonQuantifier(Token symbol) {
        switch (symbol.getType()) {
            case 22: {
                return QuantifiedComparisonExpression.Quantifier.ALL;
            }
            case 26: {
                return QuantifiedComparisonExpression.Quantifier.ANY;
            }
            case 331: {
                return QuantifiedComparisonExpression.Quantifier.SOME;
            }
        }
        throw new IllegalArgumentException("Unsupported quantifier: " + symbol.getText());
    }

    private List<Identifier> getIdentifiers(List<RelationalSqlParser.IdentifierContext> identifiers) {
        return identifiers.stream().map(context -> (Identifier)this.visit((ParseTree)context)).collect(Collectors.toList());
    }

    private static void check(boolean condition, String message, ParserRuleContext context) {
        if (!condition) {
            throw AstBuilder.parseError(message, context);
        }
    }

    private NodeLocation getLocation(TerminalNode terminalNode) {
        Objects.requireNonNull(terminalNode, "terminalNode is null");
        return this.getLocation(terminalNode.getSymbol());
    }

    private NodeLocation getLocation(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext, "parserRuleContext is null");
        return this.getLocation(parserRuleContext.getStart());
    }

    private NodeLocation getLocation(Token token) {
        Objects.requireNonNull(token, "token is null");
        return this.baseLocation != null ? new NodeLocation(token.getLine() + this.baseLocation.getLineNumber() - 1, token.getCharPositionInLine() + 1 + (token.getLine() == 1 ? this.baseLocation.getColumnNumber() : 0)) : new NodeLocation(token.getLine(), token.getCharPositionInLine() + 1);
    }

    private static ParsingException parseError(String message, ParserRuleContext context) {
        return new ParsingException(message, null, context.getStart().getLine(), context.getStart().getCharPositionInLine() + 1);
    }

    private static void validateArgumentAlias(Identifier alias, ParserRuleContext context) {
        AstBuilder.check(alias.isDelimited() || !alias.getValue().equalsIgnoreCase("COPARTITION"), "The word \"COPARTITION\" is ambiguous in this context. To alias an argument, precede the alias with \"AS\". To specify co-partitioning, change the argument order so that the last argument cannot be aliased.", context);
    }

    private static enum UnicodeDecodeState {
        EMPTY,
        ESCAPED,
        UNICODE_SEQUENCE;

    }
}

