/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedInsertStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.file.metadata.IDeviceID;

public class InsertTablet
extends WrappedInsertStatement {
    private Map<IDeviceID, Integer> deviceID2LastIdxMap = null;

    public InsertTablet(InsertTabletStatement insertTabletStatement, MPPQueryContext context) {
        super(insertTabletStatement, context);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsertTablet(this, context);
    }

    @Override
    public InsertTabletStatement getInnerTreeStatement() {
        return (InsertTabletStatement)super.getInnerTreeStatement();
    }

    @Override
    public void updateAfterSchemaValidation(MPPQueryContext context) throws QueryProcessException {
        this.getInnerTreeStatement().updateAfterSchemaValidation(context);
    }

    @Override
    public String getTableName() {
        return this.getInnerTreeStatement().getDevicePath().getFullPath();
    }

    @Override
    public List<Object[]> getDeviceIdList() {
        this.prepareDeviceID2LastIdxMap();
        ArrayList<Object[]> deviceIdList = new ArrayList<Object[]>();
        for (IDeviceID deviceID : this.deviceID2LastIdxMap.keySet()) {
            Object[] segments = deviceID.getSegments();
            deviceIdList.add(Arrays.copyOfRange(segments, 1, segments.length));
        }
        return deviceIdList;
    }

    @Override
    public List<String> getAttributeColumnNameList() {
        InsertTabletStatement insertTabletStatement = this.getInnerTreeStatement();
        return insertTabletStatement.getAttributeColumnNameList();
    }

    @Override
    public List<Object[]> getAttributeValueList() {
        this.prepareDeviceID2LastIdxMap();
        InsertTabletStatement insertTabletStatement = this.getInnerTreeStatement();
        ArrayList<Object[]> result = new ArrayList<Object[]>(insertTabletStatement.getRowCount());
        List<Integer> attrColumnIndices = insertTabletStatement.getAttrColumnIndices();
        for (Integer rowIndex : this.deviceID2LastIdxMap.values()) {
            Object[] attrValues = new Object[attrColumnIndices.size()];
            for (int attrColNum = 0; attrColNum < attrColumnIndices.size(); ++attrColNum) {
                int columnIndex = attrColumnIndices.get(attrColNum);
                if (insertTabletStatement.isNull(rowIndex, columnIndex)) continue;
                attrValues[attrColNum] = ((Object[])insertTabletStatement.getColumns()[columnIndex])[rowIndex];
            }
            result.add(attrValues);
        }
        return result;
    }

    private void prepareDeviceID2LastIdxMap() {
        if (this.deviceID2LastIdxMap != null) {
            return;
        }
        InsertTabletStatement insertTabletStatement = this.getInnerTreeStatement();
        this.deviceID2LastIdxMap = new LinkedHashMap<IDeviceID, Integer>(insertTabletStatement.getRowCount());
        for (int i = 0; i < insertTabletStatement.getRowCount(); ++i) {
            IDeviceID deviceID = insertTabletStatement.getTableDeviceID(i);
            this.deviceID2LastIdxMap.put(deviceID, i);
        }
        if (this.deviceID2LastIdxMap.size() == 1) {
            insertTabletStatement.setSingleDevice();
        }
    }
}

