/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.adapter;

import org.apache.iotdb.commons.udf.utils.UDFBinaryTransformer;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;

public class ElasticSerializableRowRecordListBackedMultiColumnRow
implements Row {
    private final TSDataType[] dataTypes;
    private final int size;
    private Object[] rowRecord;

    public ElasticSerializableRowRecordListBackedMultiColumnRow(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
        this.size = dataTypes.length;
    }

    public long getTime() {
        return (Long)this.rowRecord[this.size];
    }

    public int getInt(int columnIndex) {
        return (Integer)this.rowRecord[columnIndex];
    }

    public long getLong(int columnIndex) {
        return (Long)this.rowRecord[columnIndex];
    }

    public float getFloat(int columnIndex) {
        return ((Float)this.rowRecord[columnIndex]).floatValue();
    }

    public double getDouble(int columnIndex) {
        return (Double)this.rowRecord[columnIndex];
    }

    public boolean getBoolean(int columnIndex) {
        return (Boolean)this.rowRecord[columnIndex];
    }

    public org.apache.iotdb.udf.api.type.Binary getBinary(int columnIndex) {
        return UDFBinaryTransformer.transformToUDFBinary((Binary)((Binary)this.rowRecord[columnIndex]));
    }

    public String getString(int columnIndex) {
        return ((Binary)this.rowRecord[columnIndex]).getStringValue(TSFileConfig.STRING_CHARSET);
    }

    public Type getDataType(int columnIndex) {
        return UDFDataTypeTransformer.transformToUDFDataType((TSDataType)this.dataTypes[columnIndex]);
    }

    public boolean isNull(int columnIndex) {
        return this.rowRecord[columnIndex] == null;
    }

    public int size() {
        return this.size;
    }

    public Row setRowRecord(Object[] rowRecord) {
        this.rowRecord = rowRecord;
        return this;
    }
}

