/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.protocol.airgap;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.pipe.receiver.protocol.airgap.IoTDBAirGapReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBAirGapReceiverAgent
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBAirGapReceiverAgent.class);
    private final ExecutorService listenExecutor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)ThreadName.PIPE_RECEIVER_AIR_GAP_AGENT.getName());
    private final AtomicBoolean allowSubmitListen = new AtomicBoolean(false);
    private ServerSocket serverSocket;
    private final AtomicLong receiverId = new AtomicLong(0L);

    public void listen() {
        try {
            Socket socket = this.serverSocket.accept();
            long airGapReceiverId = this.receiverId.incrementAndGet();
            Thread airGapReceiverThread = new Thread((Runnable)((Object)new IoTDBAirGapReceiver(socket, airGapReceiverId)));
            airGapReceiverThread.setName(ThreadName.PIPE_AIR_GAP_RECEIVER.getName() + "-" + airGapReceiverId);
            airGapReceiverThread.start();
        }
        catch (IOException e) {
            LOGGER.warn("Unhandled exception during pipe air gap receiver listening", (Throwable)e);
        }
        if (this.allowSubmitListen.get()) {
            this.listenExecutor.submit(this::listen);
        }
    }

    public void start() throws StartupException {
        try {
            this.serverSocket = new ServerSocket(PipeConfig.getInstance().getPipeAirGapReceiverPort());
        }
        catch (IOException e) {
            throw new StartupException((Throwable)e);
        }
        this.allowSubmitListen.set(true);
        this.listenExecutor.submit(this::listen);
        LOGGER.info("IoTDBAirGapReceiverAgent {} started.", (Object)this.serverSocket);
    }

    public void stop() {
        try {
            if (Objects.nonNull(this.serverSocket)) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close IoTDBAirGapReceiverAgent's server socket", (Throwable)e);
        }
        this.allowSubmitListen.set(false);
        this.listenExecutor.shutdown();
        LOGGER.info("IoTDBAirGapReceiverAgent {} stopped.", (Object)this.serverSocket);
    }

    public ServiceType getID() {
        return ServiceType.AIR_GAP_SERVICE;
    }
}

