/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import org.apache.iotdb.db.queryengine.execution.aggregation.LastValueAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.BitMap;

public class LastValueDescAccumulator
extends LastValueAccumulator {
    public LastValueDescAccumulator(TSDataType seriesDataType) {
        super(seriesDataType);
    }

    @Override
    public boolean hasFinalResult() {
        return this.initResult;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    protected void addIntInput(Column[] column, BitMap needSkip) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (needSkip != null && needSkip.isMarked(i) || column[1].isNull(i)) continue;
            this.updateIntLastValue(column[1].getInt(i), column[0].getLong(i));
            return;
        }
    }

    @Override
    protected void addLongInput(Column[] column, BitMap needSkip) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (needSkip != null && needSkip.isMarked(i) || column[1].isNull(i)) continue;
            this.updateLongLastValue(column[1].getLong(i), column[0].getLong(i));
            return;
        }
    }

    @Override
    protected void addFloatInput(Column[] column, BitMap needSkip) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (needSkip != null && needSkip.isMarked(i) || column[1].isNull(i)) continue;
            this.updateFloatLastValue(column[1].getFloat(i), column[0].getLong(i));
            return;
        }
    }

    @Override
    protected void addDoubleInput(Column[] column, BitMap needSkip) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (needSkip != null && needSkip.isMarked(i) || column[1].isNull(i)) continue;
            this.updateDoubleLastValue(column[1].getDouble(i), column[0].getLong(i));
            return;
        }
    }

    @Override
    protected void addBooleanInput(Column[] column, BitMap needSkip) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (needSkip != null && needSkip.isMarked(i) || column[1].isNull(i)) continue;
            this.updateBooleanLastValue(column[1].getBoolean(i), column[0].getLong(i));
            return;
        }
    }

    @Override
    protected void addBinaryInput(Column[] column, BitMap needSkip) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (needSkip != null && needSkip.isMarked(i) || column[1].isNull(i)) continue;
            this.updateBinaryLastValue(column[1].getBinary(i), column[0].getLong(i));
            return;
        }
    }
}

