/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.server.DivisionProperties;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;

class DivisionPropertiesImpl
implements DivisionProperties {
    private final TimeDuration rpcTimeoutMin;
    private final TimeDuration rpcTimeoutMax;
    private final TimeDuration rpcSleepTime;
    private final TimeDuration rpcSlownessTimeout;

    DivisionPropertiesImpl(RaftProperties properties) {
        this.rpcTimeoutMin = RaftServerConfigKeys.Rpc.timeoutMin((RaftProperties)properties);
        this.rpcTimeoutMax = RaftServerConfigKeys.Rpc.timeoutMax((RaftProperties)properties);
        Preconditions.assertTrue((this.rpcTimeoutMax.compareTo(this.rpcTimeoutMin) >= 0 ? 1 : 0) != 0, (String)"rpcTimeoutMax = %s < rpcTimeoutMin = %s", (Object[])new Object[]{this.rpcTimeoutMax, this.rpcTimeoutMin});
        this.rpcSleepTime = RaftServerConfigKeys.Rpc.sleepTime((RaftProperties)properties);
        this.rpcSlownessTimeout = RaftServerConfigKeys.Rpc.slownessTimeout((RaftProperties)properties);
    }

    public TimeDuration minRpcTimeout() {
        return this.rpcTimeoutMin;
    }

    public TimeDuration maxRpcTimeout() {
        return this.rpcTimeoutMax;
    }

    public TimeDuration rpcSleepTime() {
        return this.rpcSleepTime;
    }

    public TimeDuration rpcSlownessTimeout() {
        return this.rpcSlownessTimeout;
    }
}

