/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Objects;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SubscriptionCommitContext
implements Comparable<SubscriptionCommitContext> {
    private final int dataNodeId;
    private final int rebootTimes;
    private final String topicName;
    private final String consumerGroupId;
    private final long commitId;
    public static final long INVALID_COMMIT_ID = -1L;

    public SubscriptionCommitContext(int dataNodeId, int rebootTimes, String topicName, String consumerGroupId, long commitId) {
        this.dataNodeId = dataNodeId;
        this.rebootTimes = rebootTimes;
        this.topicName = topicName;
        this.consumerGroupId = consumerGroupId;
        this.commitId = commitId;
    }

    public int getDataNodeId() {
        return this.dataNodeId;
    }

    public int getRebootTimes() {
        return this.rebootTimes;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public long getCommitId() {
        return this.commitId;
    }

    public static ByteBuffer serialize(SubscriptionCommitContext commitContext) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                commitContext.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.dataNodeId, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.rebootTimes, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.topicName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.consumerGroupId, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.commitId, (OutputStream)stream);
    }

    public static SubscriptionCommitContext deserialize(ByteBuffer buffer) {
        int dataNodeId = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        int rebootTimes = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        String topicName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String consumerGroupId = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        long commitId = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        return new SubscriptionCommitContext(dataNodeId, rebootTimes, topicName, consumerGroupId, commitId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionCommitContext that = (SubscriptionCommitContext)obj;
        return this.dataNodeId == that.dataNodeId && this.rebootTimes == that.rebootTimes && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.consumerGroupId, that.consumerGroupId) && Objects.equals(this.commitId, that.commitId);
    }

    public int hashCode() {
        return Objects.hash(this.dataNodeId, this.rebootTimes, this.topicName, this.consumerGroupId, this.commitId);
    }

    public String toString() {
        return "SubscriptionCommitContext{dataNodeId=" + this.dataNodeId + ", rebootTimes=" + this.rebootTimes + ", topicName=" + this.topicName + ", consumerGroupId=" + this.consumerGroupId + ", commitId=" + this.commitId + "}";
    }

    @Override
    public int compareTo(SubscriptionCommitContext that) {
        return Comparator.comparingInt(SubscriptionCommitContext::getDataNodeId).thenComparingInt(SubscriptionCommitContext::getRebootTimes).thenComparing(SubscriptionCommitContext::getTopicName).thenComparing(SubscriptionCommitContext::getConsumerGroupId).thenComparingLong(SubscriptionCommitContext::getCommitId).compare(this, that);
    }
}

