/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IChunkHandle;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class DiskChunkHandleImpl
implements IChunkHandle {
    private final boolean tsFileClosed;
    private final IDeviceID deviceID;
    private final String measurement;
    private final String filePath;
    protected ChunkHeader currentChunkHeader;
    protected PageHeader currentPageHeader;
    protected ByteBuffer currentChunkDataBuffer;
    protected long offset;
    private final Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    protected final Statistics<? extends Serializable> chunkStatistic;

    public DiskChunkHandleImpl(IDeviceID deviceID, String measurement, String filePath, boolean isTsFileClosed, long offset, Statistics<? extends Serializable> chunkStatistics) {
        this.deviceID = deviceID;
        this.measurement = measurement;
        this.chunkStatistic = chunkStatistics;
        this.offset = offset;
        this.filePath = filePath;
        this.tsFileClosed = isTsFileClosed;
    }

    protected void init(TsFileSequenceReader reader) throws IOException {
        if (this.currentChunkDataBuffer != null) {
            return;
        }
        Chunk chunk = reader.readMemChunk(this.offset);
        this.currentChunkDataBuffer = chunk.getData();
        this.currentChunkHeader = chunk.getHeader();
    }

    @Override
    public boolean hasNextPage() throws IOException {
        return this.currentChunkDataBuffer == null || this.currentChunkDataBuffer.hasRemaining();
    }

    @Override
    public void nextPage() throws IOException {
        if (this.currentChunkDataBuffer == null) {
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(this.filePath, this.tsFileClosed);
            this.init(reader);
        }
        if (this.currentChunkDataBuffer.hasRemaining()) {
            this.currentPageHeader = (byte)(this.currentChunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)this.currentChunkDataBuffer, this.chunkStatistic) : PageHeader.deserializeFrom((ByteBuffer)this.currentChunkDataBuffer, (TSDataType)this.currentChunkHeader.getDataType());
        }
    }

    @Override
    public void skipCurrentPage() {
        this.currentChunkDataBuffer.position(this.currentChunkDataBuffer.position() + this.currentPageHeader.getCompressedSize());
    }

    @Override
    public long[] getPageStatisticsTime() {
        return new long[]{this.currentPageHeader.getStartTime(), this.currentPageHeader.getEndTime()};
    }

    @Override
    public long[] getDataTime() throws IOException {
        ByteBuffer currentPageDataBuffer = ChunkReader.deserializePageData((PageHeader)this.currentPageHeader, (ByteBuffer)this.currentChunkDataBuffer, (ChunkHeader)this.currentChunkHeader);
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt((ByteBuffer)currentPageDataBuffer);
        ByteBuffer timeBuffer = currentPageDataBuffer.slice();
        timeBuffer.limit(timeBufferLength);
        return this.convertToTimeArray(timeBuffer);
    }

    @Override
    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    @Override
    public String getMeasurement() {
        return this.measurement;
    }

    private long[] convertToTimeArray(ByteBuffer timeBuffer) throws IOException {
        long[] timeArray = new long[(int)this.currentPageHeader.getNumOfValues()];
        int index = 0;
        while (this.defaultTimeDecoder.hasNext(timeBuffer)) {
            timeArray[index++] = this.defaultTimeDecoder.readLong(timeBuffer);
        }
        return timeArray;
    }
}

