/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.DiskChunkHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.utils.SharedTimeDataBuffer;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DiskAlignedChunkHandleImpl
extends DiskChunkHandleImpl {
    private static final int MASK = 128;
    private final SharedTimeDataBuffer sharedTimeDataBuffer;
    private int pageIndex = 0;

    public DiskAlignedChunkHandleImpl(IDeviceID deviceID, String measurement, String filePath, boolean isTsFileClosed, long offset, Statistics<? extends Serializable> chunkStatistic, SharedTimeDataBuffer sharedTimeDataBuffer) {
        super(deviceID, measurement, filePath, isTsFileClosed, offset, chunkStatistic);
        this.sharedTimeDataBuffer = sharedTimeDataBuffer;
    }

    @Override
    protected void init(TsFileSequenceReader reader) throws IOException {
        this.sharedTimeDataBuffer.init(reader);
        super.init(reader);
    }

    @Override
    public long[] getDataTime() throws IOException {
        ByteBuffer currentPageDataBuffer = ChunkReader.deserializePageData((PageHeader)this.currentPageHeader, (ByteBuffer)this.currentChunkDataBuffer, (ChunkHeader)this.currentChunkHeader);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)currentPageDataBuffer);
        byte[] bitmap = new byte[(size + 7) / 8];
        currentPageDataBuffer.get(bitmap);
        long[] timeData = this.sharedTimeDataBuffer.getPageTime(this.pageIndex);
        if (timeData.length != size) {
            throw new UnsupportedOperationException("Time data size not match");
        }
        long[] validTimeList = new long[(int)this.currentPageHeader.getNumOfValues()];
        int index = 0;
        for (int i = 0; i < timeData.length; ++i) {
            if ((bitmap[i / 8] & 0xFF & 128 >>> i % 8) == 0) continue;
            validTimeList[index++] = timeData[i];
        }
        ++this.pageIndex;
        return validTimeList;
    }
}

