/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.downsampling;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.AtomicDouble;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.utils.MemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartialPathLastObjectCache<T>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartialPathLastObjectCache.class);
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final AtomicDouble memoryUsageCheatFactor = new AtomicDouble(1.0);
    private final Cache<String, T> partialPath2ObjectCache;

    protected PartialPathLastObjectCache(long memoryLimitInBytes) {
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate(memoryLimitInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 1L)).setShrinkCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.updateAndGet(factor -> factor * ((double)oldMemory.longValue() / (double)newMemory.longValue()));
            LOGGER.info("PartialPathLastObjectCache.allocatedMemoryBlock has shrunk from {} to {}.", oldMemory, newMemory);
        }).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, memoryLimitInBytes)).setExpandCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.updateAndGet(factor -> factor / ((double)newMemory.longValue() / (double)oldMemory.longValue()));
            LOGGER.info("PartialPathLastObjectCache.allocatedMemoryBlock has expanded from {} to {}.", oldMemory, newMemory);
        });
        this.partialPath2ObjectCache = Caffeine.newBuilder().maximumWeight(this.allocatedMemoryBlock.getMemoryUsageInBytes()).weigher((partialPath, object) -> {
            long weightInLong = (long)((double)(MemUtils.getStringMem(partialPath) + this.calculateMemoryUsage(object)) * this.memoryUsageCheatFactor.get());
            if (weightInLong <= 0L) {
                return Integer.MAX_VALUE;
            }
            int weightInInt = (int)weightInLong;
            return (long)weightInInt != weightInLong ? Integer.MAX_VALUE : weightInInt;
        }).build();
    }

    protected abstract long calculateMemoryUsage(T var1);

    public T getPartialPathLastObject(String partialPath) {
        return (T)this.partialPath2ObjectCache.getIfPresent((Object)partialPath);
    }

    public void setPartialPathLastObject(String partialPath, T object) {
        this.partialPath2ObjectCache.put((Object)partialPath, object);
    }

    @Override
    public void close() throws Exception {
        this.partialPath2ObjectCache.invalidateAll();
        this.allocatedMemoryBlock.close();
    }
}

