/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import java.util.List;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.services.NodeManagementServices;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResult;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;

public class DefaultNodeManagementServiceSet
implements NodeManagementServiceSet {
    public void onAddNodes(ServiceRequest service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        AddNodesRequest request = (AddNodesRequest)service.getRequest();
        List nodesToAdd = ConversionUtil.l((Object[])request.getNodesToAdd());
        if (nodesToAdd.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)nodesToAdd.size() > server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        NodeManagementServices.AddNodesContext context = new NodeManagementServices.AddNodesContext(server, session, new DiagnosticsContext<AddNodesItem>());
        server.getAddressSpaceManager().addNodes(context, nodesToAdd);
        context.getFuture().thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            AddNodesResponse response = new AddNodesResponse(header, (AddNodesResult[])ConversionUtil.a((List)results, AddNodesResult.class), new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        });
    }

    public void onDeleteNodes(ServiceRequest service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        DeleteNodesRequest request = (DeleteNodesRequest)service.getRequest();
        List nodesToDelete = ConversionUtil.l((Object[])request.getNodesToDelete());
        if (nodesToDelete.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)nodesToDelete.size() > server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        NodeManagementServices.DeleteNodesContext context = new NodeManagementServices.DeleteNodesContext(server, session, new DiagnosticsContext<DeleteNodesItem>());
        server.getAddressSpaceManager().deleteNodes(context, nodesToDelete);
        context.getFuture().thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            DeleteNodesResponse response = new DeleteNodesResponse(header, (StatusCode[])ConversionUtil.a((List)results, StatusCode.class), new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        });
    }

    public void onAddReferences(ServiceRequest service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        AddReferencesRequest request = (AddReferencesRequest)service.getRequest();
        List referencesToAdd = ConversionUtil.l((Object[])request.getReferencesToAdd());
        if (referencesToAdd.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)referencesToAdd.size() > server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        NodeManagementServices.AddReferencesContext context = new NodeManagementServices.AddReferencesContext(server, session, new DiagnosticsContext<AddReferencesItem>());
        server.getAddressSpaceManager().addReferences(context, referencesToAdd);
        context.getFuture().thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            AddReferencesResponse response = new AddReferencesResponse(header, (StatusCode[])ConversionUtil.a((List)results, StatusCode.class), new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        });
    }

    public void onDeleteReferences(ServiceRequest service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        DeleteReferencesRequest request = (DeleteReferencesRequest)service.getRequest();
        List referencesToDelete = ConversionUtil.l((Object[])request.getReferencesToDelete());
        if (referencesToDelete.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)referencesToDelete.size() > server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        NodeManagementServices.DeleteReferencesContext context = new NodeManagementServices.DeleteReferencesContext(server, session, new DiagnosticsContext<DeleteReferencesItem>());
        server.getAddressSpaceManager().deleteReferences(context, referencesToDelete);
        context.getFuture().thenAccept(results -> {
            ResponseHeader header = service.createResponseHeader();
            DeleteReferencesResponse response = new DeleteReferencesResponse(header, (StatusCode[])ConversionUtil.a((List)results, StatusCode.class), new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        });
    }
}

