/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.consumer.runtime;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.confignode.consensus.request.write.subscription.consumer.runtime.ConsumerGroupHandleMetaChangePlan;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.subscription.AbstractOperateSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupMetaSyncProcedure
extends AbstractOperateSubscriptionProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerGroupMetaSyncProcedure.class);
    private static final long MIN_EXECUTION_INTERVAL_MS = PipeConfig.getInstance().getPipeMetaSyncerSyncIntervalMinutes() * 60L * 1000L / 2L;
    private static final AtomicLong LAST_EXECUTION_TIME = new AtomicLong(0L);

    @Override
    protected AtomicReference<SubscriptionInfo> acquireLockInternal(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        return configNodeProcedureEnv.getConfigManager().getSubscriptionManager().getSubscriptionCoordinator().tryLock();
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        if (System.currentTimeMillis() - LAST_EXECUTION_TIME.get() < MIN_EXECUTION_INTERVAL_MS) {
            this.subscriptionInfo = null;
            LOGGER.info("ConsumerGroupMetaSyncProcedure: acquireLock, skip the procedure due to the last execution time {}", (Object)LAST_EXECUTION_TIME.get());
            return ProcedureLockState.LOCK_ACQUIRED;
        }
        return super.acquireLock(configNodeProcedureEnv);
    }

    @Override
    protected SubscriptionOperation getOperation() {
        return SubscriptionOperation.SYNC_CONSUMER_GROUP_META;
    }

    @Override
    public boolean executeFromValidate(ConfigNodeProcedureEnv env) {
        LOGGER.info("ConsumerGroupMetaSyncProcedure: executeFromValidate");
        LAST_EXECUTION_TIME.set(System.currentTimeMillis());
        return true;
    }

    @Override
    public void executeFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) throws SubscriptionException {
        TSStatus response;
        LOGGER.info("ConsumerGroupMetaSyncProcedure: executeFromOperateOnConfigNodes");
        ArrayList<ConsumerGroupMeta> consumerGroupMetaList = new ArrayList<ConsumerGroupMeta>(((SubscriptionInfo)this.subscriptionInfo.get()).getAllConsumerGroupMeta());
        try {
            response = env.getConfigManager().getConsensusManager().write(new ConsumerGroupHandleMetaChangePlan(consumerGroupMetaList));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new SubscriptionException(response.getMessage());
        }
    }

    @Override
    public void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws SubscriptionException, IOException {
        LOGGER.info("ConsumerGroupMetaSyncProcedure: executeFromOperateOnDataNodes");
        Map<Integer, TPushConsumerGroupMetaResp> respMap = this.pushConsumerGroupMetaToDataNodes(env);
        if (ConsumerGroupMetaSyncProcedure.pushConsumerGroupMetaHasException(respMap)) {
            throw new SubscriptionException(String.format("Failed to push consumer group meta to dataNodes, details: %s", respMap));
        }
    }

    @Override
    public void rollbackFromValidate(ConfigNodeProcedureEnv env) {
        LOGGER.info("ConsumerGroupMetaSyncProcedure: rollbackFromValidate");
    }

    @Override
    public void rollbackFromOperateOnConfigNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("ConsumerGroupMetaSyncProcedure: rollbackFromOperateOnConfigNodes");
    }

    @Override
    public void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("ConsumerGroupMetaSyncProcedure: rollbackFromOperateOnDataNodes");
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CONSUMER_GROUP_META_SYNC_PROCEDURE.getTypeCode());
        super.serialize(stream);
    }

    public boolean equals(Object o) {
        return o instanceof ConsumerGroupMetaSyncProcedure;
    }

    public int hashCode() {
        return 0;
    }
}

