/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.util;

import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.UrlUtils;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class SessionUtils {
    private static final byte TYPE_NULL = -2;

    public static ByteBuffer getTimeBuffer(Tablet tablet) {
        ByteBuffer timeBuffer = ByteBuffer.allocate(tablet.getTimeBytesSize());
        for (int i = 0; i < tablet.rowSize; ++i) {
            timeBuffer.putLong(tablet.timestamps[i]);
        }
        timeBuffer.flip();
        return timeBuffer;
    }

    public static ByteBuffer getValueBuffer(Tablet tablet) {
        ByteBuffer valueBuffer = ByteBuffer.allocate(tablet.getTotalValueOccupation());
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            MeasurementSchema schema = (MeasurementSchema)tablet.getSchemas().get(i);
            SessionUtils.getValueBufferOfDataType(schema.getType(), tablet, i, valueBuffer);
        }
        if (tablet.bitMaps != null) {
            for (BitMap bitMap : tablet.bitMaps) {
                boolean columnHasNull = bitMap != null && !bitMap.isAllUnmarked();
                valueBuffer.put(BytesUtils.boolToByte((boolean)columnHasNull));
                if (!columnHasNull) continue;
                byte[] bytes = bitMap.getByteArray();
                for (int j = 0; j < tablet.rowSize / 8 + 1; ++j) {
                    valueBuffer.put(bytes[j]);
                }
            }
        }
        valueBuffer.flip();
        return valueBuffer;
    }

    public static ByteBuffer getValueBuffer(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        ByteBuffer buffer = ByteBuffer.allocate(SessionUtils.calculateLength(types, values));
        SessionUtils.putValues(types, values, buffer);
        return buffer;
    }

    private static int calculateLength(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        int res = 0;
        block9: for (int i = 0; i < types.size(); ++i) {
            ++res;
            switch (types.get(i)) {
                case BOOLEAN: {
                    ++res;
                    continue block9;
                }
                case INT32: 
                case DATE: {
                    res += 4;
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    res += 8;
                    continue block9;
                }
                case FLOAT: {
                    res += 4;
                    continue block9;
                }
                case DOUBLE: {
                    res += 8;
                    continue block9;
                }
                case TEXT: 
                case STRING: {
                    res += 4;
                    if (values.get(i) instanceof Binary) {
                        res += ((Binary)values.get(i)).getValues().length;
                        continue block9;
                    }
                    res += ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET).length;
                    continue block9;
                }
                case BLOB: {
                    res += 4;
                    res += ((Binary)values.get(i)).getValues().length;
                    continue block9;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                }
            }
        }
        return res;
    }

    private static void putValues(List<TSDataType> types, List<Object> values, ByteBuffer buffer) throws IoTDBConnectionException {
        block10: for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) {
                ReadWriteIOUtils.write((byte)-2, (ByteBuffer)buffer);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)types.get(i), (ByteBuffer)buffer);
            switch (types.get(i)) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)values.get(i)), (ByteBuffer)buffer);
                    continue block10;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)values.get(i)), (ByteBuffer)buffer);
                    continue block10;
                }
                case DATE: {
                    ReadWriteIOUtils.write((int)DateUtils.parseDateExpressionToInt((LocalDate)((LocalDate)values.get(i))), (ByteBuffer)buffer);
                    continue block10;
                }
                case INT64: 
                case TIMESTAMP: {
                    ReadWriteIOUtils.write((long)((Long)values.get(i)), (ByteBuffer)buffer);
                    continue block10;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)values.get(i)).floatValue(), (ByteBuffer)buffer);
                    continue block10;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)values.get(i)), (ByteBuffer)buffer);
                    continue block10;
                }
                case TEXT: 
                case STRING: {
                    byte[] bytes = values.get(i) instanceof Binary ? ((Binary)values.get(i)).getValues() : ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET);
                    ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
                    buffer.put(bytes);
                    continue block10;
                }
                case BLOB: {
                    byte[] bytes = ((Binary)values.get(i)).getValues();
                    ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
                    buffer.put(bytes);
                    continue block10;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                }
            }
        }
        buffer.flip();
    }

    private static void getValueBufferOfDataType(TSDataType dataType, Tablet tablet, int i, ByteBuffer valueBuffer) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putInt(intValues[index]);
                        continue;
                    }
                    valueBuffer.putInt(Integer.MIN_VALUE);
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putLong(longValues[index]);
                        continue;
                    }
                    valueBuffer.putLong(Long.MIN_VALUE);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putFloat(floatValues[index]);
                        continue;
                    }
                    valueBuffer.putFloat(Float.MIN_VALUE);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putDouble(doubleValues[index]);
                        continue;
                    }
                    valueBuffer.putDouble(Double.MIN_VALUE);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.put(BytesUtils.boolToByte((boolean)boolValues[index]));
                        continue;
                    }
                    valueBuffer.put(BytesUtils.boolToByte((boolean)false));
                }
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                Binary[] binaryValues = (Binary[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    valueBuffer.putInt(binaryValues[index].getLength());
                    valueBuffer.put(binaryValues[index].getValues());
                }
                break;
            }
            case DATE: {
                LocalDate[] dateValues = (LocalDate[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    valueBuffer.putInt(DateUtils.parseDateExpressionToInt((LocalDate)dateValues[index]));
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
            }
        }
    }

    public static List<TEndPoint> parseSeedNodeUrls(List<String> nodeUrls) {
        if (nodeUrls == null) {
            throw new NumberFormatException("nodeUrls is null");
        }
        ArrayList<TEndPoint> endPointsList = new ArrayList<TEndPoint>();
        for (String nodeUrl : nodeUrls) {
            TEndPoint endPoint = UrlUtils.parseTEndPointIpv4AndIpv6Url((String)nodeUrl);
            endPointsList.add(endPoint);
        }
        return endPointsList;
    }

    private SessionUtils() {
    }
}

