/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.task;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.FileIO;

public class TaskUtils {
    public static boolean exists(String path, FileIO fileIO) {
        try {
            return fileIO.newInputFile(path).exists();
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeManifestFile(ManifestFile mf) {
        try {
            byte[] encodedBytes = ManifestFiles.encode((ManifestFile)mf);
            return new String(Base64.getEncoder().encode(encodedBytes), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode binary data in memory", e);
        }
    }

    public static ManifestFile decodeManifestFileData(String manifestFileData) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(manifestFileData.getBytes(StandardCharsets.UTF_8));
            return ManifestFiles.decode((byte[])decodedBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to decode base64 encoded manifest", e);
        }
    }
}

