/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.admin.model.AddGrantRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.RevokeGrantRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRoleRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.admin.api.PolarisCatalogsApiService;

@Decorator
@Priority(value=1000)
public class PolarisCatalogsEventServiceDelegator
implements PolarisCatalogsApiService {
    @Inject
    @Delegate
    PolarisCatalogsApiService delegate;

    public Response createCatalog(CreateCatalogRequest request, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.createCatalog(request, realmContext, securityContext);
    }

    public Response deleteCatalog(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.deleteCatalog(catalogName, realmContext, securityContext);
    }

    public Response getCatalog(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.getCatalog(catalogName, realmContext, securityContext);
    }

    public Response updateCatalog(String catalogName, UpdateCatalogRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.updateCatalog(catalogName, updateRequest, realmContext, securityContext);
    }

    public Response listCatalogs(RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listCatalogs(realmContext, securityContext);
    }

    public Response createCatalogRole(String catalogName, CreateCatalogRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.createCatalogRole(catalogName, request, realmContext, securityContext);
    }

    public Response deleteCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.deleteCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
    }

    public Response getCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.getCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
    }

    public Response updateCatalogRole(String catalogName, String catalogRoleName, UpdateCatalogRoleRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.updateCatalogRole(catalogName, catalogRoleName, updateRequest, realmContext, securityContext);
    }

    public Response listCatalogRoles(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listCatalogRoles(catalogName, realmContext, securityContext);
    }

    public Response addGrantToCatalogRole(String catalogName, String catalogRoleName, AddGrantRequest grantRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.addGrantToCatalogRole(catalogName, catalogRoleName, grantRequest, realmContext, securityContext);
    }

    public Response revokeGrantFromCatalogRole(String catalogName, String catalogRoleName, Boolean cascade, RevokeGrantRequest grantRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.revokeGrantFromCatalogRole(catalogName, catalogRoleName, cascade, grantRequest, realmContext, securityContext);
    }

    public Response listAssigneePrincipalRolesForCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listAssigneePrincipalRolesForCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
    }

    public Response listGrantsForCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listGrantsForCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
    }
}

