/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import jakarta.annotation.Nonnull;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import org.apache.polaris.core.persistence.bootstrap.SchemaOptions;
import org.apache.polaris.persistence.relational.jdbc.DatasourceOperations;

public enum DatabaseType {
    POSTGRES("postgres"),
    H2("h2");

    private final String displayName;

    private DatabaseType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static DatabaseType fromDisplayName(String displayName) {
        return switch (displayName.toLowerCase(Locale.ROOT)) {
            case "h2" -> H2;
            case "postgresql" -> POSTGRES;
            default -> throw new IllegalStateException("Unsupported DatabaseType: '" + displayName + "'");
        };
    }

    public InputStream openInitScriptResource(@Nonnull SchemaOptions schemaOptions) {
        if (schemaOptions.schemaFile() != null) {
            try {
                return new FileInputStream(schemaOptions.schemaFile());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to load file " + schemaOptions.schemaFile(), e);
            }
        }
        Integer n = schemaOptions.schemaVersion();
        int n2 = 0;
        String schemaSuffix = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{1, 2}, (Object)n, n2)) {
            case -1 -> "schema-v2.sql";
            case 0 -> "schema-v1.sql";
            case 1 -> "schema-v2.sql";
            default -> throw new IllegalArgumentException("Unknown schema version " + schemaOptions.schemaVersion());
        };
        ClassLoader classLoader = DatasourceOperations.class.getClassLoader();
        return classLoader.getResourceAsStream(this.getDisplayName() + "/" + schemaSuffix);
    }
}

