/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.auth.external.mapping;

import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
class ClaimsLocator {
    ClaimsLocator() {
    }

    @Nullable
    public Object locateClaim(String claimPath, JsonWebToken token) {
        Object object;
        if (claimPath == null || claimPath.isEmpty() || token == null) {
            throw new IllegalArgumentException("Claim path cannot be empty");
        }
        String[] segments = ClaimsLocator.parseClaimPath(claimPath);
        if (segments.length == 0) {
            throw new IllegalArgumentException("Claim path cannot be empty");
        }
        Object currentValue = token.getClaim(segments[0]);
        for (int i = 1; i < segments.length; ++i) {
            if (!(currentValue instanceof Map)) {
                return null;
            }
            Map map = (Map)currentValue;
            currentValue = map.get(segments[i]);
        }
        if (currentValue instanceof JsonValue) {
            JsonValue jsonValue = (JsonValue)currentValue;
            object = ClaimsLocator.convert(jsonValue);
        } else {
            object = currentValue;
        }
        return object;
    }

    private static String[] parseClaimPath(String claimPath) {
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder currentSegment = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < claimPath.length(); ++i) {
            char c = claimPath.charAt(i);
            if (c == '\"') {
                if (i > 0 && claimPath.charAt(i - 1) == '\\') {
                    currentSegment.setLength(currentSegment.length() - 1);
                    currentSegment.append(c);
                    continue;
                }
                inQuotes = !inQuotes;
                continue;
            }
            if (c == '/' && !inQuotes) {
                if (currentSegment.isEmpty()) {
                    throw new IllegalArgumentException("Empty segment in claim path: " + claimPath);
                }
                segments.add(currentSegment.toString());
                currentSegment.setLength(0);
                continue;
            }
            currentSegment.append(c);
        }
        if (currentSegment.isEmpty()) {
            throw new IllegalArgumentException("Empty segment in claim path: " + claimPath);
        }
        segments.add(currentSegment.toString());
        if (inQuotes) {
            throw new IllegalArgumentException("Unclosed quotes in claim path: " + claimPath);
        }
        return segments.toArray(new String[0]);
    }

    private static Object convert(JsonValue jsonValue) {
        return switch (jsonValue.getValueType()) {
            default -> throw new MatchException(null, null);
            case JsonValue.ValueType.TRUE -> true;
            case JsonValue.ValueType.FALSE -> false;
            case JsonValue.ValueType.NULL -> null;
            case JsonValue.ValueType.STRING -> ((JsonString)jsonValue).getString();
            case JsonValue.ValueType.NUMBER -> {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                if (jsonNumber.isIntegral()) {
                    yield jsonNumber.longValue();
                }
                yield jsonNumber.doubleValue();
            }
            case JsonValue.ValueType.ARRAY -> jsonValue.asJsonArray().stream().map(ClaimsLocator::convert).toList();
            case JsonValue.ValueType.OBJECT -> jsonValue.asJsonObject().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>((String)e.getKey(), ClaimsLocator.convert((JsonValue)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        };
    }
}

