/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.BackendWritableBroadcastState;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.CompressibleFSDataOutputStream;
import org.apache.flink.runtime.state.OperatorBackendSerializationProxy;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.PartitionableListState;
import org.apache.flink.runtime.state.SnapshotResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.SnapshotStrategy;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.filemerging.EmptyFileMergingOperatorStreamStateHandle;
import org.apache.flink.runtime.state.filemerging.FileMergingOperatorStreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FsMergingCheckpointStorageLocation;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.CollectionUtil;

class DefaultOperatorStateBackendSnapshotStrategy
implements SnapshotStrategy<OperatorStateHandle, DefaultOperatorStateBackendSnapshotResources> {
    private final ClassLoader userClassLoader;
    private final Map<String, PartitionableListState<?>> registeredOperatorStates;
    private final Map<String, BackendWritableBroadcastState<?, ?>> registeredBroadcastStates;
    private final StreamCompressionDecorator compressionDecorator;

    protected DefaultOperatorStateBackendSnapshotStrategy(ClassLoader userClassLoader, Map<String, PartitionableListState<?>> registeredOperatorStates, Map<String, BackendWritableBroadcastState<?, ?>> registeredBroadcastStates, StreamCompressionDecorator compressionDecorator) {
        this.userClassLoader = userClassLoader;
        this.registeredOperatorStates = registeredOperatorStates;
        this.registeredBroadcastStates = registeredBroadcastStates;
        this.compressionDecorator = compressionDecorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultOperatorStateBackendSnapshotResources syncPrepareResources(long checkpointId) {
        if (this.registeredOperatorStates.isEmpty() && this.registeredBroadcastStates.isEmpty()) {
            return new DefaultOperatorStateBackendSnapshotResources(Collections.emptyMap(), Collections.emptyMap());
        }
        HashMap registeredOperatorStatesDeepCopies = CollectionUtil.newHashMapWithExpectedSize((int)this.registeredOperatorStates.size());
        HashMap registeredBroadcastStatesDeepCopies = CollectionUtil.newHashMapWithExpectedSize((int)this.registeredBroadcastStates.size());
        ClassLoader snapshotClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.userClassLoader);
        try {
            if (!this.registeredOperatorStates.isEmpty()) {
                for (Map.Entry<String, PartitionableListState<?>> entry : this.registeredOperatorStates.entrySet()) {
                    PartitionableListState<?> listState = entry.getValue();
                    if (null != listState) {
                        listState = listState.deepCopy();
                    }
                    registeredOperatorStatesDeepCopies.put(entry.getKey(), listState);
                }
            }
            if (!this.registeredBroadcastStates.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.registeredBroadcastStates.entrySet()) {
                    BackendWritableBroadcastState broadcastState = (BackendWritableBroadcastState)entry.getValue();
                    if (null != broadcastState) {
                        broadcastState = broadcastState.deepCopy();
                    }
                    registeredBroadcastStatesDeepCopies.put(entry.getKey(), broadcastState);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(snapshotClassLoader);
        }
        return new DefaultOperatorStateBackendSnapshotResources(registeredOperatorStatesDeepCopies, registeredBroadcastStatesDeepCopies);
    }

    @Override
    public SnapshotStrategy.SnapshotResultSupplier<OperatorStateHandle> asyncSnapshot(DefaultOperatorStateBackendSnapshotResources syncPartResource, long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) {
        Map<String, PartitionableListState<?>> registeredOperatorStatesDeepCopies = syncPartResource.getRegisteredOperatorStatesDeepCopies();
        Map<String, BackendWritableBroadcastState<?, ?>> registeredBroadcastStatesDeepCopies = syncPartResource.getRegisteredBroadcastStatesDeepCopies();
        if (registeredBroadcastStatesDeepCopies.isEmpty() && registeredOperatorStatesDeepCopies.isEmpty()) {
            if (streamFactory instanceof FsMergingCheckpointStorageLocation) {
                FsMergingCheckpointStorageLocation location = (FsMergingCheckpointStorageLocation)streamFactory;
                return snapshotCloseableRegistry -> SnapshotResult.of(EmptyFileMergingOperatorStreamStateHandle.create(location.getExclusiveStateHandle(), location.getSharedStateHandle()));
            }
            return snapshotCloseableRegistry -> SnapshotResult.empty();
        }
        return snapshotCloseableRegistry -> {
            CheckpointStateOutputStream localOut = streamFactory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
            snapshotCloseableRegistry.registerCloseable((AutoCloseable)((Object)localOut));
            ArrayList<StateMetaInfoSnapshot> operatorMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(registeredOperatorStatesDeepCopies.size());
            for (Map.Entry entry : registeredOperatorStatesDeepCopies.entrySet()) {
                operatorMetaInfoSnapshots.add(((PartitionableListState)entry.getValue()).getStateMetaInfo().snapshot());
            }
            ArrayList<StateMetaInfoSnapshot> broadcastMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(registeredBroadcastStatesDeepCopies.size());
            for (Map.Entry entry : registeredBroadcastStatesDeepCopies.entrySet()) {
                broadcastMetaInfoSnapshots.add(((BackendWritableBroadcastState)entry.getValue()).getStateMetaInfo().snapshot());
            }
            DataOutputViewStreamWrapper dataOutputViewStreamWrapper = new DataOutputViewStreamWrapper((OutputStream)((Object)localOut));
            OperatorBackendSerializationProxy operatorBackendSerializationProxy = new OperatorBackendSerializationProxy(operatorMetaInfoSnapshots, broadcastMetaInfoSnapshots, !Objects.equals(UncompressedStreamCompressionDecorator.INSTANCE, this.compressionDecorator));
            operatorBackendSerializationProxy.write((DataOutputView)dataOutputViewStreamWrapper);
            int initialMapCapacity = registeredOperatorStatesDeepCopies.size() + registeredBroadcastStatesDeepCopies.size();
            HashMap writtenStatesMetaData = CollectionUtil.newHashMapWithExpectedSize((int)initialMapCapacity);
            try (CompressibleFSDataOutputStream compressedLocalOut = new CompressibleFSDataOutputStream(localOut, this.compressionDecorator);){
                OperatorStateHandle.Mode mode;
                long[] partitionOffsets;
                Object value;
                for (Map.Entry entry : registeredOperatorStatesDeepCopies.entrySet()) {
                    value = (PartitionableListState)entry.getValue();
                    partitionOffsets = ((PartitionableListState)value).write(compressedLocalOut);
                    mode = ((PartitionableListState)value).getStateMetaInfo().getAssignmentMode();
                    writtenStatesMetaData.put(entry.getKey(), new OperatorStateHandle.StateMetaInfo(partitionOffsets, mode));
                }
                for (Map.Entry entry : registeredBroadcastStatesDeepCopies.entrySet()) {
                    value = (BackendWritableBroadcastState)entry.getValue();
                    partitionOffsets = new long[]{value.write(compressedLocalOut)};
                    mode = value.getStateMetaInfo().getAssignmentMode();
                    writtenStatesMetaData.put(entry.getKey(), new OperatorStateHandle.StateMetaInfo(partitionOffsets, mode));
                }
            }
            OperatorStreamStateHandle retValue = null;
            if (snapshotCloseableRegistry.unregisterCloseable((AutoCloseable)((Object)localOut))) {
                StreamStateHandle stateHandle = localOut.closeAndGetHandle();
                if (stateHandle != null) {
                    retValue = streamFactory instanceof FsMergingCheckpointStorageLocation ? new FileMergingOperatorStreamStateHandle(((FsMergingCheckpointStorageLocation)streamFactory).getExclusiveStateHandle(), ((FsMergingCheckpointStorageLocation)streamFactory).getSharedStateHandle(), writtenStatesMetaData, stateHandle) : new OperatorStreamStateHandle(writtenStatesMetaData, stateHandle);
                }
                return SnapshotResult.of(retValue);
            }
            throw new IOException("Stream was already unregistered.");
        };
    }

    static class DefaultOperatorStateBackendSnapshotResources
    implements SnapshotResources {
        private final Map<String, PartitionableListState<?>> registeredOperatorStatesDeepCopies;
        private final Map<String, BackendWritableBroadcastState<?, ?>> registeredBroadcastStatesDeepCopies;

        DefaultOperatorStateBackendSnapshotResources(Map<String, PartitionableListState<?>> registeredOperatorStatesDeepCopies, Map<String, BackendWritableBroadcastState<?, ?>> registeredBroadcastStatesDeepCopies) {
            this.registeredOperatorStatesDeepCopies = registeredOperatorStatesDeepCopies;
            this.registeredBroadcastStatesDeepCopies = registeredBroadcastStatesDeepCopies;
        }

        public Map<String, PartitionableListState<?>> getRegisteredOperatorStatesDeepCopies() {
            return this.registeredOperatorStatesDeepCopies;
        }

        public Map<String, BackendWritableBroadcastState<?, ?>> getRegisteredBroadcastStatesDeepCopies() {
            return this.registeredBroadcastStatesDeepCopies;
        }

        @Override
        public void release() {
        }
    }
}

