/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.thrift.protocol;

import java.util.BitSet;
import org.apache.kyuubi.shade.org.apache.thrift.TException;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocol;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocolFactory;
import org.apache.kyuubi.shade.org.apache.thrift.scheme.IScheme;
import org.apache.kyuubi.shade.org.apache.thrift.scheme.TupleScheme;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TTupleProtocol
extends TCompactProtocol {
    public TTupleProtocol(TTransport transport) {
        super(transport);
    }

    @Override
    public Class<? extends IScheme> getScheme() {
        return TupleScheme.class;
    }

    public void writeBitSet(BitSet bs, int vectorWidth) throws TException {
        byte[] bytes;
        for (byte b : bytes = TTupleProtocol.toByteArray(bs, vectorWidth)) {
            this.writeByte(b);
        }
    }

    public BitSet readBitSet(int i) throws TException {
        int length = (int)Math.ceil((double)i / 8.0);
        byte[] bytes = new byte[length];
        for (int j = 0; j < length; ++j) {
            bytes[j] = this.readByte();
        }
        BitSet bs = TTupleProtocol.fromByteArray(bytes);
        return bs;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits, int vectorWidth) {
        byte[] bytes = new byte[(int)Math.ceil((double)vectorWidth / 8.0)];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static class Factory
    implements TProtocolFactory {
        public TProtocol getProtocol(TTransport trans) {
            return new TTupleProtocol(trans);
        }
    }
}

