/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

@Internal
public class MapPartitionIterator<IN>
implements Iterator<IN> {
    public static final int DEFAULT_MAX_CACHE_NUM = 100;
    private final Lock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    private final Queue<IN> cacheQueue = new LinkedList<IN>();
    private final Condition cacheNotEmpty = this.lock.newCondition();
    private final Condition cacheNotFull = this.lock.newCondition();
    private final Condition udfFinish = this.lock.newCondition();
    private final ExecutorService udfExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("TaskUDFExecutor"));
    @GuardedBy(value="lock")
    private boolean udfFinished = false;
    @GuardedBy(value="lock")
    private boolean closed = false;

    public MapPartitionIterator(Consumer<Iterator<IN>> udf) {
        this.udfExecutor.execute(() -> {
            udf.accept(this);
            this.runWithLock(() -> {
                this.udfFinished = true;
                this.udfFinish.signalAll();
                this.cacheNotFull.signalAll();
            });
        });
    }

    @Override
    public boolean hasNext() {
        return this.supplyWithLock(() -> {
            if (this.cacheQueue.size() > 0) {
                return true;
            }
            if (this.closed) {
                return false;
            }
            this.waitCacheNotEmpty();
            return this.hasNext();
        });
    }

    @Override
    public IN next() {
        return (IN)this.supplyWithLock(() -> {
            if (this.cacheQueue.size() > 0) {
                if (!this.closed && this.cacheQueue.size() == 100) {
                    this.cacheNotFull.signalAll();
                }
                IN record = this.cacheQueue.poll();
                return record;
            }
            if (this.closed) {
                return null;
            }
            this.waitCacheNotEmpty();
            return this.cacheQueue.poll();
        });
    }

    public void addRecord(IN record) {
        this.runWithLock(() -> {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            if (this.udfFinished) {
                return;
            }
            if (this.cacheQueue.size() < 100) {
                this.cacheQueue.add(record);
                if (this.cacheQueue.size() == 1) {
                    this.cacheNotEmpty.signalAll();
                }
            } else {
                this.waitCacheNotFull();
                this.addRecord(record);
            }
        });
    }

    public void close() {
        this.runWithLock(() -> {
            this.closed = true;
            if (!this.udfFinished) {
                this.cacheNotEmpty.signalAll();
                this.waitUDFFinished();
            }
            this.udfExecutor.shutdown();
        });
    }

    private void waitCacheNotEmpty() {
        try {
            this.cacheNotEmpty.await();
        }
        catch (InterruptedException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private void waitCacheNotFull() {
        try {
            this.cacheNotFull.await();
        }
        catch (InterruptedException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private void waitUDFFinished() {
        try {
            this.udfFinish.await();
        }
        catch (InterruptedException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private void runWithLock(Runnable runnable) {
        try {
            this.lock.lock();
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    private <ANY> ANY supplyWithLock(Supplier<ANY> supplier) {
        ANY result;
        try {
            this.lock.lock();
            result = supplier.get();
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }
}

