/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.data;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;

public class PrimaryKeyData
implements StructLike,
Serializable {
    private final PrimaryKeySpec primaryKeySpec;
    private final int size;
    private final Object[] primaryTuple;
    private final Accessor<StructLike>[] accessors;

    public PrimaryKeyData(PrimaryKeySpec primaryKeySpec, Schema inputSchema) {
        this.primaryKeySpec = primaryKeySpec;
        List<PrimaryKeySpec.PrimaryKeyField> fields = primaryKeySpec.fields();
        this.size = fields.size();
        this.primaryTuple = new Object[this.size];
        this.accessors = (Accessor[])Array.newInstance(Accessor.class, this.size);
        Schema schema = primaryKeySpec.getSchema();
        for (int i = 0; i < this.size; ++i) {
            PrimaryKeySpec.PrimaryKeyField field = fields.get(i);
            Accessor accessor = inputSchema.accessorForField(inputSchema.findField(field.fieldName()).fieldId());
            Preconditions.checkArgument((accessor != null ? 1 : 0) != 0, (Object)("Cannot build accessor for field: " + schema.findField(field.fieldName())));
            this.accessors[i] = accessor;
        }
    }

    private PrimaryKeyData(PrimaryKeyData toCopy) {
        this.primaryKeySpec = toCopy.primaryKeySpec;
        this.size = toCopy.size;
        this.primaryTuple = new Object[toCopy.primaryTuple.length];
        this.accessors = toCopy.accessors;
        System.arraycopy(toCopy.primaryTuple, 0, this.primaryTuple, 0, this.primaryTuple.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.primaryTuple.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.primaryTuple[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public PrimaryKeyData copy() {
        return new PrimaryKeyData(this);
    }

    public void primaryKey(StructLike row) {
        for (int i = 0; i < this.primaryTuple.length; ++i) {
            this.primaryTuple[i] = this.accessors[i].get((Object)row);
        }
    }

    public int size() {
        return this.size;
    }

    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.primaryTuple[pos]);
    }

    public <T> void set(int pos, T value) {
        this.primaryTuple[pos] = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimaryKeyData)) {
            return false;
        }
        PrimaryKeyData that = (PrimaryKeyData)o;
        return Arrays.equals(this.primaryTuple, that.primaryTuple);
    }

    public int hashCode() {
        int hashcode = Math.abs(Arrays.hashCode(this.primaryTuple));
        return hashcode == Integer.MIN_VALUE ? Integer.MAX_VALUE : hashcode;
    }

    public DataTreeNode treeNode(long mask) {
        return DataTreeNode.of(mask, (long)Math.abs(this.hashCode()) & mask);
    }
}

