/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.recovery.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="Migrate nodes to new cluster.")
public class MigrateRequest {
    @Schema(description="Names of the CMG node names.")
    @IgniteToStringInclude
    private final List<String> cmgNodes;
    @Schema(description="Names of the Metastorage node names.")
    @IgniteToStringInclude
    private final List<String> metaStorageNodes;
    @Schema(description="Ignite version.")
    private final String version;
    @Schema(description="ID of the cluster.")
    private final UUID clusterId;
    @Schema(description="Name of the cluster.")
    private final String clusterName;
    @Schema(description="IDs the cluster had before. If CMG/Metastorage group were never repaired, this is null.")
    @Nullable
    private final List<UUID> formerClusterIds;

    @JsonCreator
    public MigrateRequest(@JsonProperty(value="cmgNodes") List<String> cmgNodes, @JsonProperty(value="metaStorageNodes") List<String> metaStorageNodes, @JsonProperty(value="version") String version, @JsonProperty(value="clusterId") UUID clusterId, @JsonProperty(value="clusterName") String clusterName, @JsonProperty(value="formerClusterIds") @Nullable List<UUID> formerClusterIds) {
        Objects.requireNonNull(cmgNodes);
        Objects.requireNonNull(metaStorageNodes);
        Objects.requireNonNull(version);
        Objects.requireNonNull(clusterId);
        Objects.requireNonNull(clusterName);
        this.cmgNodes = List.copyOf(cmgNodes);
        this.metaStorageNodes = List.copyOf(metaStorageNodes);
        this.version = version;
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.formerClusterIds = formerClusterIds == null ? null : List.copyOf(formerClusterIds);
    }

    @JsonGetter(value="cmgNodes")
    public List<String> cmgNodes() {
        return this.cmgNodes;
    }

    @JsonGetter(value="metaStorageNodes")
    public List<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    @JsonGetter(value="version")
    public String version() {
        return this.version;
    }

    @JsonGetter(value="clusterId")
    public UUID clusterId() {
        return this.clusterId;
    }

    @JsonGetter(value="clusterName")
    public String clusterName() {
        return this.clusterName;
    }

    @JsonGetter(value="formerClusterIds")
    @Nullable
    public List<UUID> formerClusterIds() {
        return this.formerClusterIds;
    }

    public String toString() {
        return S.toString(this);
    }
}

