/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.core;

import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.Closure;
import org.apache.ignite.raft.jraft.StateMachine;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.entity.LeaderChangeContext;
import org.apache.ignite.raft.jraft.error.RaftException;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotWriter;

public abstract class StateMachineAdapter
implements StateMachine {
    protected volatile long leaderTerm = -1L;
    private static final IgniteLogger LOG = Loggers.forClass(StateMachineAdapter.class);

    @Override
    public void onShutdown() {
        LOG.info("onShutdown.", new Object[0]);
    }

    @Override
    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        this.error("onSnapshotSave");
        this.runClosure(done, "onSnapshotSave");
    }

    @Override
    public boolean onSnapshotLoad(SnapshotReader reader) {
        this.error("onSnapshotLoad", "while a snapshot is saved in " + reader.getPath());
        return false;
    }

    public long getLeaderTerm() {
        return this.leaderTerm;
    }

    @Override
    public void onLeaderStart(long term) {
        this.leaderTerm = term;
        LOG.info("onLeaderStart: term={}.", new Object[]{term});
    }

    @Override
    public void onLeaderStop(Status status) {
        LOG.info("onLeaderStop: status={}.", new Object[]{status});
    }

    @Override
    public void onError(RaftException e) {
        LOG.error("Encountered an error={} on StateMachine {}, it's highly recommended to implement this method as raft stops working since some error occurs, you should figure out the cause and repair or remove this node.", (Throwable)e, new Object[]{e.getStatus(), this.getClassName()});
    }

    @Override
    public void onConfigurationCommitted(Configuration conf) {
        LOG.info("onConfigurationCommitted: {}.", new Object[]{conf});
    }

    @Override
    public void onStopFollowing(LeaderChangeContext ctx) {
        LOG.info("onStopFollowing: {}.", new Object[]{ctx});
    }

    @Override
    public void onStartFollowing(LeaderChangeContext ctx) {
        LOG.info("onStartFollowing: {}.", new Object[]{ctx});
    }

    private void runClosure(Closure done, String methodName) {
        done.run(new Status(-1, "%s doesn't implement %s", this.getClassName(), methodName));
    }

    private String getClassName() {
        return this.getClass().getName();
    }

    private void error(String methodName) {
        this.error(methodName, "");
    }

    private void error(String methodName, String msg) {
        LOG.error("{} doesn't implement {} {}.", new Object[]{this.getClassName(), methodName, msg});
    }
}

