/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class RpcOptions
extends OptionHolder {
    private static volatile RpcOptions instance;
    public static final ConfigOption<String> RPC_SERVER_HOST;
    public static final ConfigOption<Integer> RPC_SERVER_PORT;
    public static final ConfigOption<Boolean> RPC_ADAPTIVE_PORT;
    public static final ConfigOption<Integer> RPC_SERVER_TIMEOUT;
    public static final ConfigOption<String> RPC_REMOTE_URL;
    public static final ConfigOption<Integer> RPC_CLIENT_CONNECT_TIMEOUT;
    public static final ConfigOption<Integer> RPC_CLIENT_RECONNECT_PERIOD;
    public static final ConfigOption<Integer> RPC_CLIENT_READ_TIMEOUT;
    public static final ConfigOption<Integer> RPC_CLIENT_RETRIES;
    public static final ConfigOption<String> RPC_CLIENT_LOAD_BALANCER;
    public static final ConfigOption<String> RPC_PROTOCOL;
    public static final ConfigOption<String> RPC_SERIALIZATION;
    public static final ConfigOption<Integer> RPC_CONFIG_ORDER;
    public static final ConfigOption<String> RPC_LOGGER_IMPL;

    private RpcOptions() {
    }

    public static synchronized RpcOptions instance() {
        if (instance == null) {
            instance = new RpcOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        RPC_SERVER_HOST = new ConfigOption("rpc.server_host", "The hosts/ips bound by rpc server to provide services, empty value means not enabled.", null, (Object)"");
        RPC_SERVER_PORT = new ConfigOption("rpc.server_port", "The port bound by rpc server to provide services.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)8090);
        RPC_ADAPTIVE_PORT = new ConfigOption("rpc.server_adaptive_port", "Whether the bound port is adaptive, if it's enabled, when the port is in use, automatically +1 to detect the next available port. Note that this process is not atomic, so there may still be port conflicts.", OptionChecker.disallowEmpty(), (Object)false);
        RPC_SERVER_TIMEOUT = new ConfigOption("rpc.server_timeout", "The timeout(in seconds) of rpc server execution.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)30);
        RPC_REMOTE_URL = new ConfigOption("rpc.remote_url", "The remote urls of rpc peers, it can be set to multiple addresses, which are concat by ',', empty value means not enabled.", null, (Object)"");
        RPC_CLIENT_CONNECT_TIMEOUT = new ConfigOption("rpc.client_connect_timeout", "The timeout(in seconds) of rpc client connect to rpc server.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)20);
        RPC_CLIENT_RECONNECT_PERIOD = new ConfigOption("rpc.client_reconnect_period", "The period(in seconds) of rpc client reconnect to rpc server.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)10);
        RPC_CLIENT_READ_TIMEOUT = new ConfigOption("rpc.client_read_timeout", "The timeout(in seconds) of rpc client read from RPC server.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)40);
        RPC_CLIENT_RETRIES = new ConfigOption("rpc.client_retries", "Failed retry number of rpc client calls to rpc server.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)3);
        RPC_CLIENT_LOAD_BALANCER = new ConfigOption("rpc.client_load_balancer", "The RPC client uses a load-balancing algorithm to access multiple rpc servers in one cluster. Default value is 'consistentHash', means forwarding by request parameters.", OptionChecker.allowValues((Object[])new String[]{"random", "localPref", "roundRobin", "consistentHash", "weightRoundRobin"}), (Object)"consistentHash");
        RPC_PROTOCOL = new ConfigOption("rpc.protocol", "RPC communication protocol, client and server need to be specified the same value.", OptionChecker.allowValues((Object[])new String[]{"bolt", "rest", "dubbo", "h2c", "http"}), (Object)"bolt");
        RPC_SERIALIZATION = new ConfigOption("rpc.serialization", "RPC serialization type, client and server must set the same value.Note: If you choose 'protobuf', you need to add the relative IDL file. (Could refer PD/Store *.proto)", OptionChecker.allowValues((Object[])new String[]{"hessian2", "protobuf"}), (Object)"hessian2");
        RPC_CONFIG_ORDER = new ConfigOption("rpc.config_order", "Sofa-RPC configuration file loading order, the larger the more later loading.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)999);
        RPC_LOGGER_IMPL = new ConfigOption("rpc.logger_impl", "Sofa-RPC log implementation class.", OptionChecker.disallowEmpty(), (Object)"com.alipay.sofa.rpc.log.SLF4JLoggerImpl");
    }
}

