/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Provider
@Singleton
@PreMatching
public class GraphSpaceFilter
implements ContainerRequestFilter {
    private static final Logger LOG = Log.logger(GraphSpaceFilter.class);
    private static final String GRAPHSPACES_PATH = "graphspaces/";
    @Context
    private jakarta.inject.Provider<HugeConfig> configProvider;

    public void filter(ContainerRequestContext context) throws IOException {
        URI requestUri;
        HugeConfig config = (HugeConfig)this.configProvider.get();
        if (!((Boolean)config.get(ServerOptions.REST_SERVER_ENABLE_GRAPHSPACES_FILTER)).booleanValue()) {
            return;
        }
        URI baseUri = context.getUriInfo().getBaseUri();
        URI relativePath = baseUri.relativize(requestUri = context.getUriInfo().getRequestUri());
        String relativePathStr = relativePath.getPath();
        if (!relativePathStr.startsWith(GRAPHSPACES_PATH)) {
            return;
        }
        String[] parts = relativePathStr.split("/");
        if (parts.length <= 1) {
            return;
        }
        String ignoredPart = Arrays.stream(parts).limit(2L).collect(Collectors.joining("/"));
        String newPath = Arrays.stream(parts).skip(2L).collect(Collectors.joining("/"));
        URI newUri = UriBuilder.fromUri((URI)baseUri).path(newPath).replaceQuery(requestUri.getRawQuery()).build(new Object[0]);
        context.setRequestUri(newUri);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignored graphspaces segment: {}", (Object)ignoredPart);
        }
    }
}

