/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

import java.util.HashMap;
import java.util.Map;

public class StringUtil {
    public static final int EN_LETTER = 0;
    public static final int EN_NUMERIC = 1;
    public static final int EN_PUNCTUATION = 2;
    public static final int EN_WHITESPACE = 3;
    public static final int EN_UNKNOW = -1;
    private static final String EN_KEEP_PUNCS = "@/-_=?%&.'#+:";
    private static final String EN_NO_TAILING_PUNCS = ".?@:'";
    private static final Character[] PAIR_PUNCTUATION = new Character[]{Character.valueOf('\u300a'), Character.valueOf('\u300b'), Character.valueOf('\u300e'), Character.valueOf('\u300f'), Character.valueOf('\u3010'), Character.valueOf('\u3011')};
    private static Map<Character, Character> pairPunctuation = null;

    public static boolean isCJKChar(int c) {
        return c == 183 || Character.getType(c) == 5;
    }

    public static boolean isEnChar(int c) {
        return StringUtil.isHWEnChar(c) || StringUtil.isFWEnChar(c);
    }

    public static boolean isLetterNumber(int c) {
        return Character.getType(c) == 10;
    }

    public static boolean isOtherNumber(int c) {
        return Character.getType(c) == 11;
    }

    public static boolean isENKeepPunctuaton(char c) {
        return EN_KEEP_PUNCS.indexOf(c) > -1;
    }

    public static boolean isNoTailingPunctuation(char c) {
        return EN_NO_TAILING_PUNCS.indexOf(c) > -1;
    }

    public static boolean isUpperCaseLetter(int u) {
        return u >= 65 && u <= 90;
    }

    public static boolean isLowerCaseLetter(int u) {
        return u >= 97 && u <= 122;
    }

    public static int toLowerCase(int u) {
        return u + 32;
    }

    public static int toUpperCase(int u) {
        return u - 32;
    }

    public static boolean isEnLetter(int u) {
        if (u > 65280) {
            u -= 65248;
        }
        return u >= 65 && u <= 90 || u >= 97 && u <= 122;
    }

    public static boolean isEnNumeric(int u) {
        if (u > 65280) {
            u -= 65248;
        }
        return u >= 48 && u <= 57;
    }

    public static int getEnCharType(int u) {
        if (u > 126) {
            return -1;
        }
        if (u == 32) {
            return 3;
        }
        if (u >= 48 && u <= 57) {
            return 1;
        }
        if (u >= 65 && u <= 90) {
            return 0;
        }
        if (u >= 97 && u <= 122) {
            return 0;
        }
        return 2;
    }

    public static boolean isHWEnChar(int c) {
        return c >= 32 && c <= 126;
    }

    public static boolean isFWEnChar(int c) {
        return c >= 65296 && c <= 65305 || c >= 65313 && c <= 65338 || c >= 65345 && c < 65370;
    }

    public static boolean isEnPunctuation(int c) {
        return c > 32 && c < 48 || c > 57 && c < 65 || c > 90 && c < 97 || c > 122 && c < 127;
    }

    public static boolean isCnPunctuation(int c) {
        return c > 65280 && c < 65296 || c > 65305 && c < 65312 || c > 65338 && c < 65345 || c > 65370 && c < 65382 || c >= 12289 && c <= 12319;
    }

    public static boolean isPunctuation(int c) {
        return StringUtil.isEnPunctuation(c) || StringUtil.isCnPunctuation(c);
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 12288;
    }

    public static boolean isDigit(String str, int beginIndex, int endIndex) {
        for (int j = beginIndex; j < endIndex; ++j) {
            char c = str.charAt(j);
            if (c > '\uff00') {
                c = (char)(c - 65248);
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(String str) {
        return StringUtil.isDigit(str, 0, str.length());
    }

    public static boolean isDecimal(String str, int beginIndex, int endIndex) {
        if (str.charAt(str.length() - 1) == '.' || str.charAt(0) == '.') {
            return false;
        }
        int p = 0;
        for (int j = 1; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (c == '.') {
                ++p;
                continue;
            }
            if (c > '\uff00') {
                c = (char)(c - 65248);
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return p == 1;
    }

    public static boolean isDecimal(String str) {
        return StringUtil.isDecimal(str, 0, str.length());
    }

    public static boolean isLatin(String str, int beginIndex, int endIndex) {
        for (int j = beginIndex; j < endIndex; ++j) {
            if (StringUtil.isEnChar(str.charAt(j))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLatin(String str) {
        return StringUtil.isLatin(str, 0, str.length());
    }

    public static boolean isCJK(String str, int beginIndex, int endIndex) {
        for (int j = beginIndex; j < endIndex; ++j) {
            if (StringUtil.isCJKChar(str.charAt(j))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCJK(String str) {
        return StringUtil.isCJK(str, 0, str.length());
    }

    public static boolean isLetterOrNumeric(String str, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            char chr = str.charAt(i);
            if (StringUtil.isEnLetter(chr) || StringUtil.isEnNumeric(chr)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterOrNumeric(String str) {
        return StringUtil.isLetterOrNumeric(str, 0, str.length());
    }

    public static boolean isLetter(String str, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            char chr = str.charAt(i);
            if (StringUtil.isEnLetter(chr)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetter(String str) {
        return StringUtil.isLetter(str, 0, str.length());
    }

    public static boolean isNumeric(String str, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            char chr = str.charAt(i);
            if (StringUtil.isEnNumeric(chr)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        return StringUtil.isNumeric(str, 0, str.length());
    }

    public static int latinIndexOf(String str, int offset) {
        for (int j = offset; j < str.length(); ++j) {
            if (!StringUtil.isEnChar(str.charAt(j))) continue;
            return j;
        }
        return -1;
    }

    public static int latinIndexOf(String str) {
        return StringUtil.latinIndexOf(str, 0);
    }

    public static int CJKIndexOf(String str, int offset) {
        for (int j = offset; j < str.length(); ++j) {
            if (!StringUtil.isCJKChar(str.charAt(j))) continue;
            return j;
        }
        return -1;
    }

    public static int CJKIndexOf(String str) {
        return StringUtil.CJKIndexOf(str, 0);
    }

    public static String fwsTohws(String str) {
        char[] chars = str.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            if (chars[j] == '\u3000') {
                chars[j] = 32;
                continue;
            }
            if (chars[j] <= '\uff00' || chars[j] >= '\uff5f') continue;
            chars[j] = (char)(chars[j] - 65248);
        }
        return new String(chars);
    }

    public static String hwsTofws(String str) {
        char[] chars = str.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            if (chars[j] == ' ') {
                chars[j] = 12288;
                continue;
            }
            if (chars[j] >= '\u007f') continue;
            chars[j] = (char)(chars[j] + 65248);
        }
        return new String(chars);
    }

    public static boolean isPairPunctuation(char c) {
        return pairPunctuation.containsKey(Character.valueOf(c));
    }

    public static char getPunctuationPair(char c) {
        return pairPunctuation.get(Character.valueOf(c)).charValue();
    }

    public static boolean isPunctuation(String str, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            char chr = str.charAt(i);
            if (StringUtil.isEnPunctuation(chr) && StringUtil.isCnPunctuation(chr)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPunctuation(String str) {
        return StringUtil.isPunctuation(str, 0, str.length());
    }

    static {
        pairPunctuation = new HashMap<Character, Character>((int)((double)PAIR_PUNCTUATION.length / 1.7) + 1, 0.85f);
        for (int j = 0; j < PAIR_PUNCTUATION.length; j += 2) {
            pairPunctuation.put(PAIR_PUNCTUATION[j], PAIR_PUNCTUATION[j + 1]);
        }
    }
}

