/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;

public class Steps {
    protected final Map<Id, StepEntity> edgeSteps;
    protected final Map<Id, StepEntity> vertexSteps;
    protected final Directions direction;
    protected final long degree;
    protected final long skipDegree;

    public Steps(HugeGraph graph, Directions direction, Map<String, Map<String, Object>> vSteps, Map<String, Map<String, Object>> eSteps, long degree, long skipDegree) {
        E.checkArgument((degree == -1L || degree > 0L ? 1 : 0) != 0, (String)"The max degree must be > 0 or == -1, but got: %s", (Object[])new Object[]{degree});
        HugeTraverser.checkSkipDegree(skipDegree, degree, -1L);
        this.direction = direction;
        this.vertexSteps = new HashMap<Id, StepEntity>();
        if (vSteps != null && !vSteps.isEmpty()) {
            this.initVertexFilter(graph, vSteps);
        }
        this.edgeSteps = new HashMap<Id, StepEntity>();
        if (eSteps != null && !eSteps.isEmpty()) {
            this.initEdgeFilter(graph, eSteps);
        }
        this.degree = degree;
        this.skipDegree = skipDegree;
    }

    private void initVertexFilter(HugeGraph graph, Map<String, Map<String, Object>> vSteps) {
        for (Map.Entry<String, Map<String, Object>> entry : vSteps.entrySet()) {
            if (this.checkEntryEmpty(entry)) continue;
            E.checkArgument((entry.getKey() != null && !entry.getKey().isEmpty() ? 1 : 0) != 0, (String)"The vertex step label could not be null", (Object[])new Object[0]);
            VertexLabel vertexLabel = graph.vertexLabel(entry.getKey());
            StepEntity stepEntity = this.handleStepEntity(graph, entry, vertexLabel.id());
            this.vertexSteps.put(vertexLabel.id(), stepEntity);
        }
    }

    private void initEdgeFilter(HugeGraph graph, Map<String, Map<String, Object>> eSteps) {
        for (Map.Entry<String, Map<String, Object>> entry : eSteps.entrySet()) {
            if (this.checkEntryEmpty(entry)) continue;
            E.checkArgument((entry.getKey() != null && !entry.getKey().isEmpty() ? 1 : 0) != 0, (String)"The edge step label could not be null", (Object[])new Object[0]);
            EdgeLabel edgeLabel = graph.edgeLabel(entry.getKey());
            StepEntity stepEntity = this.handleStepEntity(graph, entry, edgeLabel.id());
            this.edgeSteps.put(edgeLabel.id(), stepEntity);
        }
    }

    private StepEntity handleStepEntity(HugeGraph graph, Map.Entry<String, Map<String, Object>> entry, Id id) {
        Map<Id, Object> properties = null;
        if (entry.getValue() != null) {
            properties = TraversalUtil.transProperties(graph, entry.getValue());
        }
        return new StepEntity(id, entry.getKey(), properties);
    }

    private boolean checkEntryEmpty(Map.Entry<String, Map<String, Object>> entry) {
        return !(entry.getKey() != null && !entry.getKey().isEmpty() || entry.getValue() != null && !entry.getValue().isEmpty());
    }

    public long degree() {
        return this.degree;
    }

    public Map<Id, StepEntity> edgeSteps() {
        return this.edgeSteps;
    }

    public Map<Id, StepEntity> vertexSteps() {
        return this.vertexSteps;
    }

    public long skipDegree() {
        return this.skipDegree;
    }

    public Directions direction() {
        return this.direction;
    }

    public long limit() {
        return this.skipDegree > 0L ? this.skipDegree : this.degree;
    }

    public List<Id> edgeLabels() {
        return new ArrayList<Id>(this.edgeSteps.keySet());
    }

    public boolean isEdgeEmpty() {
        return this.edgeSteps.isEmpty();
    }

    public boolean isVertexEmpty() {
        return this.vertexSteps.isEmpty();
    }

    public String toString() {
        return "Steps{edgeSteps=" + this.edgeSteps + ", vertexSteps=" + this.vertexSteps + ", direction=" + this.direction + ", degree=" + this.degree + ", skipDegree=" + this.skipDegree + "}";
    }

    public static class StepEntity {
        protected final Id id;
        protected final String label;
        protected final Map<Id, Object> properties;

        public StepEntity(Id id, String label, Map<Id, Object> properties) {
            this.id = id;
            this.label = label;
            this.properties = properties;
        }

        public Id id() {
            return this.id;
        }

        public String label() {
            return this.label;
        }

        public Map<Id, Object> properties() {
            return this.properties;
        }

        public String toString() {
            return String.format("StepEntity{id=%s,label=%s,properties=%s}", this.id, this.label, this.properties);
        }
    }
}

