/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.comm;

import java.util.Collection;
import java.util.Map;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.comm.AbstractCommAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.LouvainTraverser;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.util.ParameterUtil;

public class LouvainAlgorithm
extends AbstractCommAlgorithm {
    public static final String ALGO_NAME = "louvain";

    @Override
    public String name() {
        return ALGO_NAME;
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        LouvainAlgorithm.times(parameters);
        LouvainAlgorithm.stableTimes(parameters);
        LouvainAlgorithm.precision(parameters);
        LouvainAlgorithm.degree(parameters);
        LouvainAlgorithm.sourceLabel(parameters);
        LouvainAlgorithm.sourceCLabel(parameters);
        LouvainAlgorithm.showModularity(parameters);
        LouvainAlgorithm.showCommunity(parameters);
        LouvainAlgorithm.exportCommunity(parameters);
        LouvainAlgorithm.skipIsolated(parameters);
        LouvainAlgorithm.clearPass(parameters);
        LouvainAlgorithm.workers(parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        String label = LouvainAlgorithm.sourceLabel(parameters);
        String clabel = LouvainAlgorithm.sourceCLabel(parameters);
        long degree = LouvainAlgorithm.degree(parameters);
        boolean skipIsolated = LouvainAlgorithm.skipIsolated(parameters);
        int workers = LouvainAlgorithm.workers(parameters);
        Long clearPass = LouvainAlgorithm.clearPass(parameters);
        Long modPass = LouvainAlgorithm.showModularity(parameters);
        String showComm = LouvainAlgorithm.showCommunity(parameters);
        Long exportPass = LouvainAlgorithm.exportCommunity(parameters);
        try (LouvainTraverser traverser = new LouvainTraverser(job, workers, degree, label, clabel, skipIsolated);){
            if (clearPass != null) {
                Long l = traverser.clearPass(clearPass.intValue());
                return l;
            }
            if (modPass != null) {
                Double d = traverser.modularity(modPass.intValue());
                return d;
            }
            if (exportPass != null) {
                boolean vertexFirst = showComm == null;
                int pass = exportPass.intValue();
                Long l = traverser.exportCommunity(pass, vertexFirst);
                return l;
            }
            if (showComm != null) {
                Collection<Object> collection = traverser.showCommunity(showComm);
                return collection;
            }
            Object object = traverser.louvain(LouvainAlgorithm.times(parameters), LouvainAlgorithm.stableTimes(parameters), LouvainAlgorithm.precision(parameters));
            return object;
        }
        catch (Throwable e) {
            job.graph().tx().rollback();
            throw e;
        }
    }

    protected static Long clearPass(Map<String, Object> parameters) {
        if (!parameters.containsKey("clear")) {
            return null;
        }
        long pass = ParameterUtil.parameterLong(parameters, "clear");
        HugeTraverser.checkNonNegativeOrNoLimit(pass, "clear");
        return pass;
    }

    protected static Long showModularity(Map<String, Object> parameters) {
        if (!parameters.containsKey("show_modularity")) {
            return null;
        }
        long pass = ParameterUtil.parameterLong(parameters, "show_modularity");
        HugeTraverser.checkNonNegative(pass, "show_modularity");
        return pass;
    }

    protected static Long exportCommunity(Map<String, Object> parameters) {
        if (!parameters.containsKey("export_community")) {
            return null;
        }
        long pass = ParameterUtil.parameterLong(parameters, "export_community");
        HugeTraverser.checkNonNegative(pass, "export_community");
        return pass;
    }

    protected static boolean skipIsolated(Map<String, Object> parameters) {
        if (!parameters.containsKey("skip_isolated")) {
            return true;
        }
        return ParameterUtil.parameterBoolean(parameters, "skip_isolated");
    }
}

