/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.raft.RaftBackendStore;
import org.apache.hugegraph.backend.store.raft.RaftContext;
import org.apache.hugegraph.backend.store.raft.RaftNode;
import org.apache.hugegraph.backend.store.raft.RaftStoreClosure;
import org.apache.hugegraph.backend.store.raft.StoreCommand;
import org.apache.hugegraph.backend.store.raft.StoreSerializer;
import org.apache.hugegraph.backend.store.raft.StoreSnapshotFile;
import org.apache.hugegraph.backend.store.raft.rpc.RaftRequests;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.LZ4Util;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class StoreStateMachine
extends StateMachineAdapter {
    private static final Logger LOG = Log.logger(StoreStateMachine.class);
    private final RaftContext context;
    private final StoreSnapshotFile snapshotFile;

    public StoreStateMachine(RaftContext context) {
        this.context = context;
        this.snapshotFile = new StoreSnapshotFile(context.stores());
    }

    private BackendStore store(RaftRequests.StoreType type) {
        return this.context.originStore(type);
    }

    private RaftNode node() {
        return this.context.node();
    }

    public void onApply(Iterator iter) {
        LOG.debug("Node role: {}", (Object)(this.node().selfIsLeader() ? "leader" : "follower"));
        ArrayList futures = new ArrayList(64);
        try {
            while (iter.hasNext()) {
                RaftStoreClosure closure = (RaftStoreClosure)iter.done();
                if (closure != null) {
                    futures.add(this.onApplyLeader(closure));
                } else {
                    futures.add(this.onApplyFollower(iter.getData()));
                }
                iter.next();
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Throwable e) {
            String string = "StateMachine occurred critical error";
            LOG.error("{}", (Object)string, (Object)e);
            Status status = new Status(RaftError.ESTATEMACHINE, "%s: %s", new Object[]{string, e.getMessage()});
            iter.setErrorAndRollback(1L, status);
        }
    }

    private Future<?> onApplyLeader(RaftStoreClosure closure) {
        StoreCommand command = closure.command();
        BytesBuffer buffer = BytesBuffer.wrap(command.data());
        RaftRequests.StoreType type = RaftRequests.StoreType.valueOf(buffer.read());
        RaftRequests.StoreAction action = RaftRequests.StoreAction.valueOf(buffer.read());
        boolean forwarded = command.forwarded();
        CompletableFuture future = new CompletableFuture();
        closure.complete(Status.OK(), () -> {
            Object result;
            try {
                result = this.applyCommand(type, action, buffer, forwarded);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                throw e;
            }
            future.complete(result);
            return result;
        });
        return future;
    }

    private Future<?> onApplyFollower(ByteBuffer data) {
        byte[] bytes = data.array();
        return this.context.backendExecutor().submit(() -> {
            BytesBuffer buffer = LZ4Util.decompress(bytes, 8192);
            buffer.forReadWritten();
            RaftRequests.StoreType type = RaftRequests.StoreType.valueOf(buffer.read());
            RaftRequests.StoreAction action = RaftRequests.StoreAction.valueOf(buffer.read());
            try {
                return this.applyCommand(type, action, buffer, false);
            }
            catch (Throwable e) {
                String title = "Failed to execute backend command";
                LOG.error("{}: {}", new Object[]{title, action, e});
                throw new BackendException(title, e);
            }
        });
    }

    private Object applyCommand(RaftRequests.StoreType type, RaftRequests.StoreAction action, BytesBuffer buffer, boolean forwarded) {
        E.checkState((type != RaftRequests.StoreType.ALL ? 1 : 0) != 0, (String)"Can't apply command for all store at one time", (Object[])new Object[0]);
        BackendStore store = this.store(type);
        switch (action) {
            case CLEAR: {
                boolean clearSpace = buffer.read() > 0;
                store.clear(clearSpace);
                this.context.clearCache();
                break;
            }
            case TRUNCATE: {
                store.truncate();
                this.context.clearCache();
                break;
            }
            case SNAPSHOT: {
                assert (store == null);
                return this.node().snapshot();
            }
            case BEGIN_TX: {
                store.beginTx();
                break;
            }
            case COMMIT_TX: {
                List<BackendMutation> mutations = StoreSerializer.readMutations(buffer);
                store.beginTx();
                for (BackendMutation mutation : mutations) {
                    store.mutate(mutation);
                    this.context.updateCacheIfNeeded(mutation, forwarded);
                }
                store.commitTx();
                break;
            }
            case ROLLBACK_TX: {
                store.rollbackTx();
                break;
            }
            case INCR_COUNTER: {
                RaftBackendStore.IncrCounter counter = StoreSerializer.readIncrCounter(buffer);
                store.increaseCounter(counter.type(), counter.increment());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid action " + action);
            }
        }
        return null;
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        LOG.info("The node {} start snapshot saving", (Object)this.node().nodeId());
        this.snapshotFile.save(writer, done, this.context.snapshotExecutor());
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        if (this.node() != null && this.node().selfIsLeader()) {
            LOG.warn("Leader is not supposed to load snapshot.");
            return false;
        }
        LOG.info("The node {} start snapshot loading", (Object)this.context.endpoint());
        return this.snapshotFile.load(reader);
    }

    public void onLeaderStart(long term) {
        LOG.info("The node {} become to leader", (Object)this.context.endpoint());
        this.node().onLeaderInfoChange(this.context.endpoint(), true);
        super.onLeaderStart(term);
    }

    public void onLeaderStop(Status status) {
        LOG.info("The node {} abdicated from leader", (Object)this.node().nodeId());
        this.node().onLeaderInfoChange(null, false);
        super.onLeaderStop(status);
    }

    public void onStartFollowing(LeaderChangeContext ctx) {
        LOG.info("The node {} become to follower", (Object)this.node().nodeId());
        this.node().onLeaderInfoChange(ctx.getLeaderId(), false);
        super.onStartFollowing(ctx);
    }

    public void onStopFollowing(LeaderChangeContext ctx) {
        LOG.info("The node {} abdicated from follower", (Object)this.node().nodeId());
        this.node().onLeaderInfoChange(null, false);
        super.onStopFollowing(ctx);
    }

    public void onConfigurationCommitted(Configuration conf) {
        super.onConfigurationCommitted(conf);
    }

    public void onError(RaftException e) {
        LOG.error("Raft error: {}", (Object)e.getMessage(), (Object)e);
    }
}

