/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.util;

import com.alipay.remoting.util.StringUtils;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class RemotingUtil {
    public static String parseRemoteAddress(Channel channel) {
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        return RemotingUtil.doParse(remote != null ? remote.toString().trim() : "");
    }

    public static String parseLocalAddress(Channel channel) {
        if (null == channel) {
            return "";
        }
        SocketAddress local = channel.localAddress();
        return RemotingUtil.doParse(local != null ? local.toString().trim() : "");
    }

    public static String parseRemoteIP(Channel channel) {
        if (null == channel) {
            return "";
        }
        InetSocketAddress remote = (InetSocketAddress)channel.remoteAddress();
        if (remote != null) {
            return remote.getAddress().getHostAddress();
        }
        return "";
    }

    public static String parseRemoteHostName(Channel channel) {
        if (null == channel) {
            return "";
        }
        InetSocketAddress remote = (InetSocketAddress)channel.remoteAddress();
        if (remote != null) {
            return remote.getAddress().getHostName();
        }
        return "";
    }

    public static String parseLocalIP(Channel channel) {
        if (null == channel) {
            return "";
        }
        InetSocketAddress local = (InetSocketAddress)channel.localAddress();
        if (local != null) {
            return local.getAddress().getHostAddress();
        }
        return "";
    }

    public static int parseRemotePort(Channel channel) {
        if (null == channel) {
            return -1;
        }
        InetSocketAddress remote = (InetSocketAddress)channel.remoteAddress();
        if (remote != null) {
            return remote.getPort();
        }
        return -1;
    }

    public static int parseLocalPort(Channel channel) {
        if (null == channel) {
            return -1;
        }
        InetSocketAddress local = (InetSocketAddress)channel.localAddress();
        if (local != null) {
            return local.getPort();
        }
        return -1;
    }

    public static String parseSocketAddressToString(SocketAddress socketAddress) {
        if (socketAddress != null) {
            return RemotingUtil.doParse(socketAddress.toString().trim());
        }
        return "";
    }

    public static String parseSocketAddressToHostIp(SocketAddress socketAddress) {
        InetAddress addr;
        InetSocketAddress addrs = (InetSocketAddress)socketAddress;
        if (addrs != null && null != (addr = addrs.getAddress())) {
            return addr.getHostAddress();
        }
        return "";
    }

    private static String doParse(String addr) {
        if (StringUtils.isBlank(addr)) {
            return "";
        }
        if (addr.charAt(0) == '/') {
            return addr.substring(1);
        }
        int len = addr.length();
        for (int i = 1; i < len; ++i) {
            if (addr.charAt(i) != '/') continue;
            return addr.substring(i + 1);
        }
        return addr;
    }
}

