/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.palo;

import org.apache.hugegraph.backend.LocalCounter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.mysql.MysqlStoreProvider;
import org.apache.hugegraph.backend.store.palo.PaloFeatures;
import org.apache.hugegraph.backend.store.palo.PaloStore;
import org.apache.hugegraph.backend.store.palo.PaloTables;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;

public class PaloStoreProvider
extends MysqlStoreProvider {
    private static final BackendFeatures FEATURES = new PaloFeatures();

    protected BackendStore newSchemaStore(HugeConfig config, String store) {
        return new PaloSchemaStore((BackendStoreProvider)this, this.database(), store);
    }

    protected BackendStore newGraphStore(HugeConfig config, String store) {
        return new PaloGraphStore((BackendStoreProvider)this, this.database(), store);
    }

    public String type() {
        return "palo";
    }

    public String driverVersion() {
        return "1.10";
    }

    public static class PaloGraphStore
    extends PaloStore {
        public PaloGraphStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX, new PaloTables.Vertex(store));
            this.registerTableManager(HugeType.EDGE_OUT, new PaloTables.Edge(store, Directions.OUT));
            this.registerTableManager(HugeType.EDGE_IN, new PaloTables.Edge(store, Directions.IN));
            this.registerTableManager(HugeType.SECONDARY_INDEX, new PaloTables.SecondaryIndex(store));
            this.registerTableManager(HugeType.RANGE_INT_INDEX, new PaloTables.RangeIntIndex(store));
            this.registerTableManager(HugeType.RANGE_FLOAT_INDEX, new PaloTables.RangeFloatIndex(store));
            this.registerTableManager(HugeType.RANGE_LONG_INDEX, new PaloTables.RangeLongIndex(store));
            this.registerTableManager(HugeType.RANGE_DOUBLE_INDEX, new PaloTables.RangeDoubleIndex(store));
            this.registerTableManager(HugeType.SEARCH_INDEX, new PaloTables.SearchIndex(store));
            this.registerTableManager(HugeType.SHARD_INDEX, new PaloTables.ShardIndex(store));
            this.registerTableManager(HugeType.UNIQUE_INDEX, new PaloTables.UniqueIndex(store));
        }

        public BackendFeatures features() {
            return FEATURES;
        }

        public boolean isSchemaStore() {
            return false;
        }

        public Id nextId(HugeType type) {
            throw new UnsupportedOperationException("PaloGraphStore.nextId()");
        }

        public void increaseCounter(HugeType type, long num) {
            throw new UnsupportedOperationException("PaloGraphStore.increaseCounter()");
        }

        public long getCounter(HugeType type) {
            throw new UnsupportedOperationException("PaloGraphStore.getCounter()");
        }
    }

    public static class PaloSchemaStore
    extends PaloStore {
        private final LocalCounter counter = new LocalCounter();

        public PaloSchemaStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX_LABEL, new PaloTables.VertexLabel());
            this.registerTableManager(HugeType.EDGE_LABEL, new PaloTables.EdgeLabel());
            this.registerTableManager(HugeType.PROPERTY_KEY, new PaloTables.PropertyKey());
            this.registerTableManager(HugeType.INDEX_LABEL, new PaloTables.IndexLabel());
        }

        public BackendFeatures features() {
            return FEATURES;
        }

        public Id nextId(HugeType type) {
            return this.counter.nextId(type);
        }

        public void increaseCounter(HugeType type, long increment) {
            this.counter.increaseCounter(type, increment);
        }

        public long getCounter(HugeType type) {
            return this.counter.getCounter(type);
        }

        public boolean isSchemaStore() {
            return true;
        }
    }
}

