/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.file;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hugegraph.loader.exception.InitException;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.progress.InputItemProgress;
import org.apache.hugegraph.loader.reader.AbstractReader;
import org.apache.hugegraph.loader.reader.Readable;
import org.apache.hugegraph.loader.reader.file.FileLineFetcher;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class FileReader
extends AbstractReader {
    private static final Logger LOG = Log.logger(FileReader.class);
    private final FileSource source;
    private Iterator<Readable> readables;
    private Readable readable;
    private FileLineFetcher fetcher;
    private Line nextLine;

    public FileReader(FileSource source) {
        this.source = source;
        this.readables = null;
        this.readable = null;
        this.fetcher = null;
        this.nextLine = null;
    }

    public FileSource source() {
        return this.source;
    }

    protected abstract List<Readable> scanReadables() throws IOException;

    protected abstract FileLineFetcher createLineFetcher();

    @Override
    public void init(LoadContext context, InputStruct struct) throws InitException {
        List<Readable> readableList;
        this.progress(context, struct);
        try {
            readableList = this.scanReadables();
            readableList.sort(Comparator.comparing(Readable::name));
        }
        catch (IOException e) {
            throw new InitException("Failed to scan readable files for '%s'", (Throwable)e, this.source);
        }
        this.readables = readableList.iterator();
        this.fetcher = this.createLineFetcher();
        this.fetcher.readHeaderIfNeeded(readableList);
    }

    @Override
    public void confirmOffset() {
        this.newProgress.confirmOffset();
    }

    @Override
    public boolean hasNext() {
        if (this.nextLine != null) {
            return true;
        }
        try {
            this.nextLine = this.readNextLine();
        }
        catch (IOException e) {
            throw new LoadException("Error while reading the next line", e);
        }
        return this.nextLine != null;
    }

    @Override
    public Line next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Reached the end of file");
        }
        Line line = this.nextLine;
        this.nextLine = null;
        return line;
    }

    @Override
    public void close() {
        if (this.readable == null) {
            return;
        }
        LOG.debug("Ready to close '{}'", (Object)this.readable);
        try {
            this.fetcher.closeReader();
        }
        catch (IOException e) {
            LOG.warn("Failed to close reader for {} with exception {}", (Object)this.source, (Object)e);
        }
    }

    private Line readNextLine() throws IOException {
        Line line;
        if (!this.fetcher.ready() && !this.openNextReadable()) {
            return null;
        }
        try {
            while ((line = this.fetcher.fetch()) == null) {
                this.fetcher.closeReader();
                if (this.openNextReadable()) continue;
                Line line2 = null;
                return line2;
            }
        }
        finally {
            this.newProgress.loadingItem().offset(this.fetcher.offset());
        }
        return line;
    }

    private boolean openNextReadable() {
        while (this.moveToNextReadable()) {
            LoadStatus status = this.checkLastLoadStatus(this.readable);
            if (status == LoadStatus.LOADED) continue;
            LOG.info("In loading '{}'", (Object)this.readable);
            this.fetcher.openReader(this.readable);
            if (status == LoadStatus.LOADED_HALF) {
                long offset = this.oldProgress.loadingOffset();
                this.fetcher.skipOffset(this.readable, offset);
            }
            return true;
        }
        return false;
    }

    private boolean moveToNextReadable() {
        boolean hasNext = this.readables.hasNext();
        if (hasNext) {
            this.readable = this.readables.next();
        }
        return hasNext;
    }

    private LoadStatus checkLastLoadStatus(Readable readable) {
        InputItemProgress input = readable.inputItemProgress();
        InputItemProgress loaded = this.oldProgress.matchLoadedItem(input);
        if (loaded != null) {
            this.newProgress.addLoadedItem(loaded);
            return LoadStatus.LOADED;
        }
        InputItemProgress loading = this.oldProgress.matchLoadingItem(input);
        if (loading != null) {
            this.newProgress.addLoadingItem(loading);
            return LoadStatus.LOADED_HALF;
        }
        this.newProgress.addLoadingItem(input);
        return LoadStatus.NOT_LOADED;
    }

    private static enum LoadStatus {
        LOADED,
        LOADED_HALF,
        NOT_LOADED;

    }
}

