/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Create View", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateViewDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = LoggerFactory.getLogger(CreateViewDesc.class);
    private String viewName;
    private String originalText;
    private String expandedText;
    private boolean rewriteEnabled;
    private List<FieldSchema> schema;
    private Map<String, String> tblProps;
    private List<String> partColNames;
    private List<FieldSchema> partCols;
    private String comment;
    private boolean ifNotExists;
    private boolean replace;
    private boolean isAlterViewAs;
    private boolean isMaterialized;
    private String inputFormat;
    private String outputFormat;
    private String location;
    private String serde;
    private String storageHandler;
    private Map<String, String> serdeProps;
    private Set<String> tablesUsed;
    private ReplicationSpec replicationSpec = null;

    public CreateViewDesc() {
    }

    public CreateViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> tblProps, List<String> partColNames, boolean ifNotExists, boolean replace, boolean rewriteEnabled, boolean isAlterViewAs, String inputFormat, String outputFormat, String location, String serde, String storageHandler, Map<String, String> serdeProps) {
        this.viewName = viewName;
        this.schema = schema;
        this.tblProps = tblProps;
        this.partColNames = partColNames;
        this.comment = comment;
        this.ifNotExists = ifNotExists;
        this.replace = replace;
        this.isMaterialized = true;
        this.rewriteEnabled = rewriteEnabled;
        this.isAlterViewAs = isAlterViewAs;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.location = location;
        this.serde = serde;
        this.storageHandler = storageHandler;
        this.serdeProps = serdeProps;
    }

    public CreateViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> tblProps, List<String> partColNames, boolean ifNotExists, boolean orReplace, boolean isAlterViewAs, String inputFormat, String outputFormat, String serde) {
        this.viewName = viewName;
        this.schema = schema;
        this.tblProps = tblProps;
        this.partColNames = partColNames;
        this.comment = comment;
        this.ifNotExists = ifNotExists;
        this.replace = orReplace;
        this.isAlterViewAs = isAlterViewAs;
        this.isMaterialized = false;
        this.rewriteEnabled = false;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.serde = serde;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Explain(displayName="original text", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewOriginalText() {
        return this.originalText;
    }

    public void setViewOriginalText(String originalText) {
        this.originalText = originalText;
    }

    @Explain(displayName="expanded text")
    public String getViewExpandedText() {
        return this.expandedText;
    }

    public void setViewExpandedText(String expandedText) {
        this.expandedText = expandedText;
    }

    @Explain(displayName="rewrite enabled", displayOnlyOnTrue=true)
    public boolean isRewriteEnabled() {
        return this.rewriteEnabled;
    }

    public void setRewriteEnabled(boolean rewriteEnabled) {
        this.rewriteEnabled = rewriteEnabled;
    }

    @Explain(displayName="columns")
    public List<String> getSchemaString() {
        return Utilities.getFieldSchemaString(this.schema);
    }

    public List<FieldSchema> getSchema() {
        return this.schema;
    }

    public void setSchema(List<FieldSchema> schema) {
        this.schema = schema;
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.partCols);
    }

    public List<FieldSchema> getPartCols() {
        return this.partCols;
    }

    public void setPartCols(List<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    public List<String> getPartColNames() {
        return this.partColNames;
    }

    public void setPartColNames(List<String> partColNames) {
        this.partColNames = partColNames;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public Set<String> getTablesUsed() {
        return this.tablesUsed;
    }

    public void setTablesUsed(Set<String> tablesUsed) {
        this.tablesUsed = tablesUsed;
    }

    @Explain(displayName="replace", displayOnlyOnTrue=true)
    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    @Explain(displayName="is alter view as select", displayOnlyOnTrue=true)
    public boolean getIsAlterViewAs() {
        return this.isAlterViewAs;
    }

    public void setIsAlterViewAs(boolean isAlterViewAs) {
        this.isAlterViewAs = isAlterViewAs;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSerde() {
        return this.serde;
    }

    public String getStorageHandler() {
        return this.storageHandler;
    }

    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    public Table toTable(HiveConf conf) throws HiveException {
        String[] names = Utilities.getDbTableName(this.getViewName());
        String databaseName = names[0];
        String tableName = names[1];
        Table tbl = new Table(databaseName, tableName);
        tbl.setViewOriginalText(this.getViewOriginalText());
        tbl.setViewExpandedText(this.getViewExpandedText());
        if (this.isMaterialized()) {
            tbl.setRewriteEnabled(this.isRewriteEnabled());
            tbl.setTableType(TableType.MATERIALIZED_VIEW);
        } else {
            tbl.setTableType(TableType.VIRTUAL_VIEW);
        }
        tbl.setSerializationLib(null);
        tbl.clearSerDeInfo();
        tbl.setFields(this.getSchema());
        if (this.getComment() != null) {
            tbl.setProperty("comment", this.getComment());
        }
        if (this.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(this.getTblProps());
        }
        if (this.getPartCols() != null) {
            tbl.setPartCols(this.getPartCols());
        }
        if (this.getInputFormat() != null) {
            tbl.setInputFormatClass(this.getInputFormat());
        }
        if (this.getOutputFormat() != null) {
            tbl.setOutputFormatClass(this.getOutputFormat());
        }
        if (this.isMaterialized()) {
            String serDeClassName;
            if (this.getLocation() != null) {
                tbl.setDataLocation(new Path(this.getLocation()));
            }
            if (this.getStorageHandler() != null) {
                tbl.setProperty("storage_handler", this.getStorageHandler());
            }
            HiveStorageHandler storageHandler = tbl.getStorageHandler();
            if (this.getSerde() == null) {
                if (storageHandler == null) {
                    serDeClassName = PlanUtils.getDefaultSerDe().getName();
                    LOG.info("Default to {} for materialized view {}", (Object)serDeClassName, (Object)this.getViewName());
                } else {
                    serDeClassName = storageHandler.getSerDeClass().getName();
                    LOG.info("Use StorageHandler-supplied {} for materialized view {}", (Object)serDeClassName, (Object)this.getViewName());
                }
            } else {
                serDeClassName = this.getSerde();
                DDLTask.validateSerDe(serDeClassName, conf);
            }
            tbl.setSerializationLib(serDeClassName);
            tbl.setInputFormatClass(this.getInputFormat());
            tbl.setOutputFormatClass(this.getOutputFormat());
            if (this.getInputFormat() != null && !this.getInputFormat().isEmpty()) {
                tbl.getSd().setInputFormat(tbl.getInputFormatClass().getName());
            }
            if (this.getOutputFormat() != null && !this.getOutputFormat().isEmpty()) {
                tbl.getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
            }
        }
        return tbl;
    }
}

