/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprStringScalarStringScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int arg1Column;
    private final byte[] arg2Scalar;
    private final byte[] arg3Scalar;

    public IfExprStringScalarStringScalar(int arg1Column, byte[] arg2Scalar, byte[] arg3Scalar, int outputColumnNum) {
        super(outputColumnNum);
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Scalar = arg3Scalar;
    }

    public IfExprStringScalarStringScalar() {
        this.arg1Column = -1;
        this.arg2Scalar = null;
        this.arg3Scalar = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.initBuffer();
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.setRef(0, this.arg2Scalar, 0, this.arg2Scalar.length);
            } else {
                outputColVector.setRef(0, this.arg3Scalar, 0, this.arg3Scalar.length);
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    if (vector1[i] == 1L) {
                        outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                        continue;
                    }
                    outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
                }
            } else {
                Arrays.fill(outputIsNull, 0, n, false);
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                        continue;
                    }
                    outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputIsNull[i] = false;
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                    continue;
                }
                outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
            }
        } else {
            Arrays.fill(outputIsNull, 0, n, false);
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                    continue;
                }
                outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.arg1Column) + ", val " + IfExprStringScalarStringScalar.displayUtf8Bytes(this.arg2Scalar) + ", val " + IfExprStringScalarStringScalar.displayUtf8Bytes(this.arg3Scalar);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING, VectorExpressionDescriptor.ArgumentType.STRING).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

