/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.DefaultFetchFormatter;
import org.apache.hadoop.hive.serde2.FetchFormatter;
import org.apache.hadoop.util.ReflectionUtils;

public class ListSinkOperator
extends Operator<ListSinkDesc> {
    private transient List res;
    private transient FetchFormatter fetcher;
    private transient int numRows;

    protected ListSinkOperator() {
    }

    public ListSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        try {
            this.fetcher = this.initializeFetcher(hconf);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private FetchFormatter initializeFetcher(Configuration conf) throws Exception {
        FetchFormatter<String> fetcher;
        String formatterName = conf.get("list.sink.output.formatter");
        if (formatterName != null && !formatterName.isEmpty()) {
            Class<FetchFormatter> fetcherClass = Class.forName(formatterName, true, Utilities.getSessionSpecifiedClassLoader()).asSubclass(FetchFormatter.class);
            fetcher = (FetchFormatter)ReflectionUtils.newInstance(fetcherClass, null);
        } else {
            fetcher = new DefaultFetchFormatter();
        }
        Properties props = new Properties();
        props.put("serialization.format", "9");
        props.put("serialization.null.format", ((ListSinkDesc)this.getConf()).getSerializationNullFormat());
        fetcher.initialize(conf, props);
        return fetcher;
    }

    public void reset(List res) {
        this.res = res;
        this.numRows = 0;
    }

    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            this.res.add(this.fetcher.convert(row, this.inputObjInspectors[0]));
            ++this.numRows;
            ++this.runTimeNumRows;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FORWARD;
    }

    @Override
    public String getName() {
        return ListSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "LIST_SINK";
    }

    @Override
    public boolean logicalEquals(Operator other) {
        return this.getClass().getName().equals(other.getClass().getName());
    }
}

