/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.base.HdfsDirectory;
import org.apache.hugegraph.base.LocalDirectory;
import org.apache.hugegraph.base.Printer;
import org.apache.hugegraph.base.ToolClient;
import org.apache.hugegraph.cmd.SubCommands;
import org.apache.hugegraph.constant.AuthRestoreConflictStrategy;
import org.apache.hugegraph.exception.ToolsException;
import org.apache.hugegraph.manager.BackupRestoreBaseManager;
import org.apache.hugegraph.structure.auth.Access;
import org.apache.hugegraph.structure.auth.Belong;
import org.apache.hugegraph.structure.auth.Group;
import org.apache.hugegraph.structure.auth.Target;
import org.apache.hugegraph.structure.auth.User;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.logging.log4j.util.Strings;

public class AuthBackupRestoreManager
extends BackupRestoreBaseManager {
    private static final String AUTH_BACKUP_RESTORE = "auth-backup-restore";
    private static final int NO_CONFLICT = 0;
    private AuthRestoreConflictStrategy strategy;
    private String initPassword;
    private Map<String, String> idsMap;
    private Map<String, User> usersByName;
    private Map<String, Group> groupsByName;
    private Map<String, Target> targetsByName;
    private Map<String, Belong> belongsByName;
    private Map<String, Access> accessesByName;

    public AuthBackupRestoreManager(ToolClient.ConnectionInfo info) {
        super(info, AUTH_BACKUP_RESTORE);
    }

    public void init(SubCommands.AuthBackup authBackup) {
        this.retry(authBackup.retry());
        this.directory(authBackup.directory(), authBackup.hdfsConf());
        this.ensureDirectoryExist(true);
    }

    public void init(SubCommands.AuthRestore authRestore) {
        this.retry(authRestore.retry());
        this.directory(authRestore.directory(), authRestore.hdfsConf());
        this.ensureDirectoryExist(false);
        this.strategy = authRestore.strategy();
        this.initPassword(authRestore.types(), authRestore.initPassword());
        this.idsMap = Maps.newHashMap();
        this.usersByName = Maps.newHashMap();
        this.groupsByName = Maps.newHashMap();
        this.targetsByName = Maps.newHashMap();
        this.belongsByName = Maps.newHashMap();
        this.accessesByName = Maps.newHashMap();
    }

    public void backup(List<HugeType> types) {
        try {
            this.doBackup(this.addAuthManagers(types));
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.shutdown(this.type());
        }
    }

    private void doBackup(List<AuthManager> authManagers) {
        E.checkState((boolean)CollectionUtils.isNotEmpty(authManagers), (String)"Backup data is empty, please check the type", (Object[])new Object[0]);
        for (AuthManager authManager : authManagers) {
            authManager.backup();
        }
    }

    public void restore(List<HugeType> types) {
        List<HugeType> sortedHugeTypes = this.sortListByCode(types);
        try {
            this.doRestore(this.addAuthManagers(sortedHugeTypes));
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.shutdown(this.type());
        }
    }

    private void doRestore(List<AuthManager> authManagers) {
        E.checkState((boolean)CollectionUtils.isNotEmpty(authManagers), (String)"Restore data is empty, please check the type", (Object[])new Object[0]);
        ArrayList allConflicts = Lists.newArrayList();
        for (AuthManager authManager : authManagers) {
            allConflicts.addAll(authManager.checkConflict());
        }
        E.checkState((boolean)CollectionUtils.isEmpty((Collection)allConflicts), (String)"Restore conflict with STOP strategy, conflicting data is s%", (Object[])new Object[]{JsonUtil.toJson((Object)allConflicts)});
        for (AuthManager authManager : authManagers) {
            authManager.restore();
        }
    }

    private List<AuthManager> addAuthManagers(List<HugeType> types) {
        ArrayList authManagers = Lists.newArrayList();
        block7: for (HugeType type : types) {
            switch (type) {
                case USER: {
                    authManagers.add(new UserManager());
                    continue block7;
                }
                case GROUP: {
                    authManagers.add(new GroupManager());
                    continue block7;
                }
                case TARGET: {
                    authManagers.add(new TargetManager());
                    continue block7;
                }
                case BELONG: {
                    authManagers.add(new BelongManager());
                    continue block7;
                }
                case ACCESS: {
                    authManagers.add(new AccessManager());
                    continue block7;
                }
            }
            throw new AssertionError((Object)String.format("Bad auth restore type: %s", type));
        }
        return authManagers;
    }

    private boolean checkAllExistInIdMaps(String oneId, String otherId) {
        return this.idsMap.containsKey(oneId) && this.idsMap.containsKey(otherId);
    }

    private List<String> readRestoreData(HugeType type) {
        ArrayList resultList = Lists.newArrayList();
        InputStream is = this.inputStream(type.string());
        try (InputStreamReader isr = new InputStreamReader(is, "UTF-8");
             BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                resultList.add(line);
            }
        }
        catch (IOException e) {
            throw new ToolsException("Failed to deserialize %s from %s", (Throwable)e, type.string(), resultList);
        }
        return resultList;
    }

    private long writeBackupData(HugeType type, List<?> list) {
        long count = 0L;
        try {
            OutputStream os = this.outputStream(type.string(), false);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            StringBuilder builder = new StringBuilder(1024);
            for (Object e : list) {
                ++count;
                builder.append(JsonUtil.toJson(e)).append("\n");
            }
            baos.write(builder.toString().getBytes("UTF-8"));
            os.write(baos.toByteArray());
        }
        catch (Throwable e) {
            throw new ToolsException("Failed to serialize %s to %s", e, list, type.string());
        }
        return count;
    }

    @Override
    protected void directory(String dir, Map<String, String> hdfsConf) {
        this.directory = hdfsConf == null || hdfsConf.isEmpty() ? LocalDirectory.constructDir(dir, AUTH_BACKUP_RESTORE) : HdfsDirectory.constructDir(dir, AUTH_BACKUP_RESTORE, hdfsConf);
    }

    private List<HugeType> sortListByCode(List<HugeType> hugeTypes) {
        return hugeTypes.stream().sorted(Comparator.comparing(HugeType::code)).collect(Collectors.toList());
    }

    private void initPassword(List<HugeType> types, String password) {
        E.checkState((!types.contains(HugeType.USER) || Strings.isNotEmpty((CharSequence)password) ? 1 : 0) != 0, (String)"The following option is required: [--init-password]", (Object[])new Object[0]);
        this.initPassword = password;
    }

    private class AccessManager
    implements AuthManager {
        private AccessManager() {
        }

        @Override
        public void backup() {
            Printer.print("Accesses backup started...");
            List accesses = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listAccesses(), "querying accesses of authority");
            long writeLines = AuthBackupRestoreManager.this.writeBackupData(HugeType.ACCESS, accesses);
            Printer.print("Accesses backup finished, write lines: %d", writeLines);
        }

        @Override
        public List<String> checkConflict() {
            List accesses = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listAccesses(), "querying accesses of authority");
            HashMap accessMap = Maps.newHashMap();
            for (Access access : accesses) {
                String accessKey = access.group() + ":" + access.target();
                accessMap.put(accessKey, access);
            }
            List accessJsons = AuthBackupRestoreManager.this.readRestoreData(HugeType.ACCESS);
            ArrayList conflicts = Lists.newArrayList();
            for (String access : accessJsons) {
                Access restoreAccess = (Access)JsonUtil.fromJson((String)access, Access.class);
                if (!AuthBackupRestoreManager.this.checkAllExistInIdMaps(restoreAccess.group().toString(), restoreAccess.target().toString())) continue;
                String ids = (String)AuthBackupRestoreManager.this.idsMap.get(restoreAccess.group()) + ":" + (String)AuthBackupRestoreManager.this.idsMap.get(restoreAccess.target());
                if (accessMap.containsKey(ids)) {
                    E.checkState((AuthBackupRestoreManager.this.strategy.isStopStrategy() || AuthBackupRestoreManager.this.strategy.isIgnoreStrategy() ? 1 : 0) != 0, (String)"Restore accesses strategy is not found", (Object[])new Object[0]);
                    if (!AuthBackupRestoreManager.this.strategy.isStopStrategy()) continue;
                    conflicts.add(restoreAccess.toString());
                    continue;
                }
                AuthBackupRestoreManager.this.accessesByName.put(restoreAccess.id().toString(), restoreAccess);
            }
            return conflicts;
        }

        @Override
        public void restore() {
            int count = 0;
            for (Map.Entry entry : AuthBackupRestoreManager.this.accessesByName.entrySet()) {
                Access restoreAccess = (Access)entry.getValue();
                restoreAccess.target(AuthBackupRestoreManager.this.idsMap.get(restoreAccess.target().toString()));
                restoreAccess.group(AuthBackupRestoreManager.this.idsMap.get(restoreAccess.group().toString()));
                AuthBackupRestoreManager.this.retry(() -> AuthBackupRestoreManager.this.client.authManager().createAccess(restoreAccess), "restore accesses of authority");
                ++count;
            }
            Printer.print("Restore accesses finished, total count is %d", count);
        }
    }

    private class BelongManager
    implements AuthManager {
        private BelongManager() {
        }

        @Override
        public void backup() {
            Printer.print("Belongs backup started...");
            List belongs = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listBelongs(), "querying belongs of authority");
            long writeLines = AuthBackupRestoreManager.this.writeBackupData(HugeType.BELONG, belongs);
            Printer.print("Belongs backup finished, write lines: %d", writeLines);
        }

        @Override
        public List<String> checkConflict() {
            List belongs = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listBelongs(), "querying belongs of authority");
            HashMap belongMap = Maps.newHashMap();
            for (Belong belong : belongs) {
                String belongKey = belong.user() + ":" + belong.group();
                belongMap.put(belongKey, belong);
            }
            List belongJsons = AuthBackupRestoreManager.this.readRestoreData(HugeType.BELONG);
            ArrayList conflicts = Lists.newArrayList();
            for (String belong : belongJsons) {
                Belong restoreBelong = (Belong)JsonUtil.fromJson((String)belong, Belong.class);
                if (!AuthBackupRestoreManager.this.checkAllExistInIdMaps(restoreBelong.user().toString(), restoreBelong.group().toString())) continue;
                String ids = (String)AuthBackupRestoreManager.this.idsMap.get(restoreBelong.user()) + ":" + (String)AuthBackupRestoreManager.this.idsMap.get(restoreBelong.group());
                if (belongMap.containsKey(ids)) {
                    E.checkState((AuthBackupRestoreManager.this.strategy.isStopStrategy() || AuthBackupRestoreManager.this.strategy.isIgnoreStrategy() ? 1 : 0) != 0, (String)"Restore belongs strategy is not found", (Object[])new Object[0]);
                    if (!AuthBackupRestoreManager.this.strategy.isStopStrategy()) continue;
                    conflicts.add(restoreBelong.toString());
                    continue;
                }
                AuthBackupRestoreManager.this.belongsByName.put(restoreBelong.id().toString(), restoreBelong);
            }
            return conflicts;
        }

        @Override
        public void restore() {
            int count = 0;
            for (Map.Entry entry : AuthBackupRestoreManager.this.belongsByName.entrySet()) {
                Belong restoreBelong = (Belong)entry.getValue();
                restoreBelong.user(AuthBackupRestoreManager.this.idsMap.get(restoreBelong.user().toString()));
                restoreBelong.group(AuthBackupRestoreManager.this.idsMap.get(restoreBelong.group().toString()));
                AuthBackupRestoreManager.this.retry(() -> AuthBackupRestoreManager.this.client.authManager().createBelong(restoreBelong), "restore belongs of authority");
                ++count;
            }
            Printer.print("Restore belongs finished, total count is %d", count);
        }
    }

    private class TargetManager
    implements AuthManager {
        private TargetManager() {
        }

        @Override
        public void backup() {
            Printer.print("Targets backup started...");
            List targets = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listTargets(), "querying targets of authority");
            long writeLines = AuthBackupRestoreManager.this.writeBackupData(HugeType.TARGET, targets);
            Printer.print("Targets backup finished, write lines: %d", writeLines);
        }

        @Override
        public List<String> checkConflict() {
            List targets = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listTargets(), "querying targets of authority");
            HashMap targetMap = Maps.newHashMap();
            for (Target target : targets) {
                targetMap.put(target.name(), target);
            }
            List targetJsons = AuthBackupRestoreManager.this.readRestoreData(HugeType.TARGET);
            ArrayList conflicts = Lists.newArrayList();
            for (String target : targetJsons) {
                int conflict = 0;
                Target restoreTarget = (Target)JsonUtil.fromJson((String)target, Target.class);
                if (!targetMap.containsKey(restoreTarget.name())) {
                    this.prepareTargetForRestore(restoreTarget);
                    continue;
                }
                Target existTarget = (Target)targetMap.get(restoreTarget.name());
                if (!StringUtils.equals((CharSequence)existTarget.graph(), (CharSequence)restoreTarget.graph())) {
                    ++conflict;
                }
                if (!StringUtils.equals((CharSequence)existTarget.url(), (CharSequence)restoreTarget.url())) {
                    ++conflict;
                }
                if (conflict > 0) {
                    E.checkState((AuthBackupRestoreManager.this.strategy.isStopStrategy() || AuthBackupRestoreManager.this.strategy.isIgnoreStrategy() ? 1 : 0) != 0, (String)"Restore targets strategy is not found", (Object[])new Object[0]);
                    if (!AuthBackupRestoreManager.this.strategy.isStopStrategy()) continue;
                    conflicts.add(restoreTarget.toString());
                    continue;
                }
                AuthBackupRestoreManager.this.idsMap.put(restoreTarget.id().toString(), existTarget.id().toString());
            }
            return conflicts;
        }

        @Override
        public void restore() {
            int count = 0;
            for (Map.Entry entry : AuthBackupRestoreManager.this.targetsByName.entrySet()) {
                Target restoreTarget = (Target)entry.getValue();
                Target target = AuthBackupRestoreManager.this.retry(() -> AuthBackupRestoreManager.this.client.authManager().createTarget(restoreTarget), "restore targets of authority");
                AuthBackupRestoreManager.this.idsMap.put(restoreTarget.id().toString(), target.id().toString());
                ++count;
            }
            Printer.print("Restore targets finished, total count is %d", count);
        }

        private void prepareTargetForRestore(Target restoreTarget) {
            AuthBackupRestoreManager.this.idsMap.put(restoreTarget.id().toString(), restoreTarget.id().toString());
            AuthBackupRestoreManager.this.targetsByName.put(restoreTarget.name(), restoreTarget);
        }
    }

    private class GroupManager
    implements AuthManager {
        private GroupManager() {
        }

        @Override
        public void backup() {
            Printer.print("Groups backup started...");
            List groups = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listGroups(), "querying groups of authority");
            long writeLines = AuthBackupRestoreManager.this.writeBackupData(HugeType.GROUP, groups);
            Printer.print("Groups backup finished, write lines: %d", writeLines);
        }

        @Override
        public List<String> checkConflict() {
            List groups = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listGroups(), "querying groups of authority");
            HashMap groupMap = Maps.newHashMap();
            for (Group group : groups) {
                groupMap.put(group.name(), group);
            }
            List groupJsons = AuthBackupRestoreManager.this.readRestoreData(HugeType.GROUP);
            ArrayList conflicts = Lists.newArrayList();
            for (String group : groupJsons) {
                int conflict = 0;
                Group restoreGroup = (Group)JsonUtil.fromJson((String)group, Group.class);
                if (!groupMap.containsKey(restoreGroup.name())) {
                    this.prepareGroupForRestore(restoreGroup);
                    continue;
                }
                Group existGroup = (Group)groupMap.get(restoreGroup.name());
                if (!StringUtils.equals((CharSequence)existGroup.description(), (CharSequence)restoreGroup.description())) {
                    ++conflict;
                }
                if (conflict > 0) {
                    E.checkState((AuthBackupRestoreManager.this.strategy.isStopStrategy() || AuthBackupRestoreManager.this.strategy.isIgnoreStrategy() ? 1 : 0) != 0, (String)"Restore groups strategy is not found", (Object[])new Object[0]);
                    if (!AuthBackupRestoreManager.this.strategy.isStopStrategy()) continue;
                    conflicts.add(restoreGroup.toString());
                    continue;
                }
                AuthBackupRestoreManager.this.idsMap.put(restoreGroup.id().toString(), existGroup.id().toString());
            }
            return conflicts;
        }

        @Override
        public void restore() {
            int count = 0;
            for (Map.Entry entry : AuthBackupRestoreManager.this.groupsByName.entrySet()) {
                Group restoreGroup = (Group)entry.getValue();
                Group group = AuthBackupRestoreManager.this.retry(() -> AuthBackupRestoreManager.this.client.authManager().createGroup(restoreGroup), "restore groups of authority");
                AuthBackupRestoreManager.this.idsMap.put(restoreGroup.id().toString(), group.id().toString());
                ++count;
            }
            Printer.print("Restore groups finished, total count is %d", count);
        }

        private void prepareGroupForRestore(Group restoreGroup) {
            AuthBackupRestoreManager.this.idsMap.put(restoreGroup.id().toString(), restoreGroup.id().toString());
            AuthBackupRestoreManager.this.groupsByName.put(restoreGroup.name(), restoreGroup);
        }
    }

    private class UserManager
    implements AuthManager {
        private UserManager() {
        }

        @Override
        public void backup() {
            Printer.print("Users backup started...");
            List users = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listUsers(), "querying users of authority");
            long writeLines = AuthBackupRestoreManager.this.writeBackupData(HugeType.USER, users);
            Printer.print("Users backup finished, write lines: %d", writeLines);
        }

        @Override
        public List<String> checkConflict() {
            List users = AuthBackupRestoreManager.this.retry(() -> ((org.apache.hugegraph.driver.AuthManager)AuthBackupRestoreManager.this.client.authManager()).listUsers(), "querying users of authority");
            HashMap userMap = Maps.newHashMap();
            for (User user : users) {
                userMap.put(user.name(), user);
            }
            List userJsons = AuthBackupRestoreManager.this.readRestoreData(HugeType.USER);
            ArrayList conflicts = Lists.newArrayList();
            for (String user : userJsons) {
                int conflict = 0;
                User restoreUser = (User)JsonUtil.fromJson((String)user, User.class);
                if (!userMap.containsKey(restoreUser.name())) {
                    this.prepareUserForRestore(restoreUser);
                    continue;
                }
                User existUser = (User)userMap.get(restoreUser.name());
                if (!StringUtils.equals((CharSequence)existUser.phone(), (CharSequence)restoreUser.phone())) {
                    ++conflict;
                }
                if (!StringUtils.equals((CharSequence)existUser.email(), (CharSequence)restoreUser.email())) {
                    ++conflict;
                }
                if (!StringUtils.equals((CharSequence)existUser.avatar(), (CharSequence)restoreUser.avatar())) {
                    ++conflict;
                }
                if (conflict > 0) {
                    E.checkState((AuthBackupRestoreManager.this.strategy.isStopStrategy() || AuthBackupRestoreManager.this.strategy.isIgnoreStrategy() ? 1 : 0) != 0, (String)"Restore users strategy is not found", (Object[])new Object[0]);
                    if (!AuthBackupRestoreManager.this.strategy.isStopStrategy()) continue;
                    conflicts.add(restoreUser.toString());
                    continue;
                }
                AuthBackupRestoreManager.this.idsMap.put(restoreUser.id().toString(), existUser.id().toString());
            }
            return conflicts;
        }

        @Override
        public void restore() {
            int count = 0;
            for (Map.Entry entry : AuthBackupRestoreManager.this.usersByName.entrySet()) {
                User restoreUser = (User)entry.getValue();
                restoreUser.password(AuthBackupRestoreManager.this.initPassword);
                User user = AuthBackupRestoreManager.this.retry(() -> AuthBackupRestoreManager.this.client.authManager().createUser(restoreUser), "restore users of authority");
                AuthBackupRestoreManager.this.idsMap.put(restoreUser.id().toString(), user.id().toString());
                ++count;
            }
            Printer.print("Restore users finished, total count is %d", count);
        }

        private void prepareUserForRestore(User restoreUser) {
            AuthBackupRestoreManager.this.idsMap.put(restoreUser.id().toString(), restoreUser.id().toString());
            AuthBackupRestoreManager.this.usersByName.put(restoreUser.name(), restoreUser);
        }
    }

    private static interface AuthManager {
        public void backup();

        public List<String> checkConflict();

        public void restore();
    }
}

