/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.formatter.kgdumper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hugegraph.formatter.kgdumper.SignFS64;

public class ComputeSign {
    private Map<String, Integer> tradeValue2Num;
    private LinkedHashMap<String, String> entPlain2Id;
    private String inputEncoding;

    public ComputeSign(String tradeValueFile, String inputEncode) throws IOException {
        File file = new File(tradeValueFile);
        Long fileLen = file.length();
        byte[] fileBytes = new byte[fileLen.intValue()];
        try (FileInputStream in = new FileInputStream(file);){
            in.read(fileBytes);
        }
        this.tradeValue2Num = new HashMap<String, Integer>();
        String fileContent = new String(fileBytes);
        String[] lines = fileContent.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] cols = lines[i].split("\t");
            if (cols.length < 2) continue;
            this.tradeValue2Num.put(cols[0], Integer.valueOf(cols[1]));
        }
        this.inputEncoding = inputEncode;
        int cacheSize = 1000;
        int capacity = (int)Math.ceil(1333.3333740234375) + 1;
        this.entPlain2Id = new LinkedHashMap<String, String>(capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> e) {
                return this.size() > 1000;
            }
        };
    }

    public synchronized String computeSeqNum(String entPlain) throws UnsupportedEncodingException {
        String seqNum = "0";
        if (this.entPlain2Id.containsKey(entPlain)) {
            seqNum = this.entPlain2Id.get(entPlain);
            return seqNum;
        }
        String[] entSpa = entPlain.split("__");
        if (entSpa.length != 3) {
            return seqNum;
        }
        ArrayList<String> trans = new ArrayList<String>();
        if (this.tradeValue2Num.containsKey(entSpa[0])) {
            trans.add(this.tradeValue2Num.get(entSpa[0]).toString());
        } else {
            trans.add(entSpa[0]);
        }
        trans.add(entSpa[1]);
        if (entSpa[1].contains("trade") && this.tradeValue2Num.containsKey(entSpa[2])) {
            trans.add(this.tradeValue2Num.get(entSpa[2]).toString());
        } else {
            trans.add(entSpa[2]);
        }
        if (trans.contains("common") && trans.contains("regioncode")) {
            seqNum = (String)trans.get(2);
        } else {
            String text = String.join((CharSequence)"__", trans);
            seqNum = SignFS64.createSignFs64(text, this.inputEncoding);
        }
        this.entPlain2Id.put(entPlain, seqNum);
        return seqNum;
    }
}

