/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.schema.ConflictCheckEntity;
import org.apache.hugegraph.entity.schema.ConflictDetail;
import org.apache.hugegraph.entity.schema.ConflictStatus;
import org.apache.hugegraph.entity.schema.EdgeLabelEntity;
import org.apache.hugegraph.entity.schema.EdgeLabelStyle;
import org.apache.hugegraph.entity.schema.EdgeLabelUpdateEntity;
import org.apache.hugegraph.entity.schema.Property;
import org.apache.hugegraph.entity.schema.PropertyIndex;
import org.apache.hugegraph.entity.schema.SchemaConflict;
import org.apache.hugegraph.entity.schema.SchemaEntity;
import org.apache.hugegraph.entity.schema.SchemaType;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.service.schema.PropertyIndexService;
import org.apache.hugegraph.service.schema.PropertyKeyService;
import org.apache.hugegraph.service.schema.SchemaService;
import org.apache.hugegraph.service.schema.VertexLabelService;
import org.apache.hugegraph.structure.SchemaElement;
import org.apache.hugegraph.structure.constant.Frequency;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.IndexLabel;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.structure.schema.SchemaLabel;
import org.apache.hugegraph.structure.schema.VertexLabel;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EdgeLabelService
extends SchemaService {
    private static final Logger log = LogManager.getLogger(EdgeLabelService.class);
    @Autowired
    private PropertyKeyService pkService;
    @Autowired
    private VertexLabelService vlService;
    @Autowired
    private PropertyIndexService piService;

    public List<EdgeLabelEntity> list(int connId) {
        return this.list(Collections.emptyList(), connId);
    }

    public List<EdgeLabelEntity> list(Collection<String> names, int connId) {
        return this.list(names, connId, true);
    }

    public List<EdgeLabelEntity> list(Collection<String> names, int connId, boolean emptyAsAll) {
        HugeClient client = this.client(connId);
        List edgeLabels = CollectionUtils.isEmpty(names) ? (emptyAsAll ? client.schema().getEdgeLabels() : new ArrayList()) : client.schema().getEdgeLabels(new ArrayList<String>(names));
        List indexLabels = client.schema().getIndexLabels();
        ArrayList<EdgeLabelEntity> results = new ArrayList<EdgeLabelEntity>(edgeLabels.size());
        edgeLabels.forEach(edgeLabel -> results.add(EdgeLabelService.convert(edgeLabel, indexLabels)));
        return results;
    }

    public EdgeLabelEntity get(String name, int connId) {
        HugeClient client = this.client(connId);
        try {
            EdgeLabel edgeLabel = client.schema().getEdgeLabel(name);
            List indexLabels = client.schema().getIndexLabels();
            return EdgeLabelService.convert(edgeLabel, indexLabels);
        }
        catch (ServerException e) {
            if (e.status() == 404) {
                throw new ExternalException("schema.edgelabel.not-exist", (Throwable)e, name);
            }
            throw new ExternalException("schema.edgelabel.get.failed", (Throwable)e, name);
        }
    }

    public void checkExist(String name, int connId) {
        this.get(name, connId);
    }

    public void checkNotExist(String name, int connId) {
        try {
            this.get(name, connId);
        }
        catch (ExternalException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServerException && ((ServerException)cause).status() == 404) {
                return;
            }
            throw e;
        }
        throw new ExternalException("schema.edgelabel.exist", name);
    }

    public void add(EdgeLabelEntity entity, int connId) {
        HugeClient client = this.client(connId);
        EdgeLabel edgeLabel = EdgeLabelService.convert(entity, client);
        try {
            client.schema().addEdgeLabel(edgeLabel);
        }
        catch (Exception e) {
            throw new ExternalException("schema.edgelabel.create.failed", (Throwable)e, entity.getName());
        }
        List<IndexLabel> indexLabels = EdgeLabelService.collectIndexLabels(entity, client);
        this.piService.addBatch(indexLabels, client);
    }

    public void update(EdgeLabelUpdateEntity entity, int connId) {
        HugeClient client = this.client(connId);
        EdgeLabel edgeLabel = EdgeLabelService.convert(entity, client);
        List existedIndexLabels = client.schema().getIndexLabels();
        List<String> existedIndexLabelNames = EdgeLabelService.collectNames(existedIndexLabels);
        List<String> addedIndexLabelNames = entity.getAppendPropertyIndexNames();
        List<IndexLabel> addedIndexLabels = EdgeLabelService.convertIndexLabels(entity.getAppendPropertyIndexes(), client, false, entity.getName());
        List<String> removedIndexLabelNames = entity.getRemovePropertyIndexes();
        if (addedIndexLabelNames != null) {
            for (String name : addedIndexLabelNames) {
                if (!existedIndexLabelNames.contains(name)) continue;
                throw new ExternalException("schema.edgelabel.update.append-index-existed", entity.getName(), name);
            }
        }
        if (removedIndexLabelNames != null) {
            for (String name : removedIndexLabelNames) {
                if (existedIndexLabelNames.contains(name)) continue;
                throw new ExternalException("schema.edgelabel.update.remove-index-unexisted", entity.getName(), name);
            }
        }
        try {
            client.schema().appendEdgeLabel(edgeLabel);
        }
        catch (Exception e) {
            throw new ExternalException("schema.edgelabel.update.failed", (Throwable)e, entity.getName());
        }
        this.piService.addBatch(addedIndexLabels, client);
        this.piService.removeBatch(removedIndexLabelNames, client);
    }

    public void remove(String name, int connId) {
        HugeClient client = this.client(connId);
        client.schema().removeEdgeLabelAsync(name);
    }

    public ConflictDetail checkConflict(ConflictCheckEntity entity, int connId, boolean compareEachOther) {
        ConflictDetail detail = new ConflictDetail(SchemaType.EDGE_LABEL);
        if (CollectionUtils.isEmpty(entity.getElEntities())) {
            return detail;
        }
        HashMap<String, EdgeLabelEntity> originElEntities = new HashMap<String, EdgeLabelEntity>();
        for (EdgeLabelEntity e : this.list(connId)) {
            originElEntities.put(e.getName(), e);
        }
        this.pkService.checkConflict(entity.getPkEntities(), detail, connId, compareEachOther);
        this.piService.checkConflict(entity.getPiEntities(), detail, connId, compareEachOther);
        this.vlService.checkConflict(entity.getVlEntities(), detail, connId, compareEachOther);
        for (EdgeLabelEntity elEntity : entity.getElEntities()) {
            if (detail.anyPropertyKeyConflict(elEntity.getPropNames())) {
                detail.add(elEntity, ConflictStatus.DEP_CONFLICT);
                continue;
            }
            if (detail.anyPropertyIndexConflict(elEntity.getIndexProps())) {
                detail.add(elEntity, ConflictStatus.DEP_CONFLICT);
                continue;
            }
            if (detail.anyVertexLabelConflict(elEntity.getLinkLabels())) {
                detail.add(elEntity, ConflictStatus.DEP_CONFLICT);
                continue;
            }
            EdgeLabelEntity originElEntity = (EdgeLabelEntity)originElEntities.get(elEntity.getName());
            ConflictStatus status = SchemaEntity.compare(elEntity, originElEntity);
            detail.add(elEntity, status);
        }
        if (compareEachOther) {
            EdgeLabelService.compareWithEachOther(detail, SchemaType.EDGE_LABEL);
        }
        return detail;
    }

    public void reuse(ConflictDetail detail, int connId) {
        List<IndexLabel> indexLabels;
        List<EdgeLabel> edgeLabels;
        List<VertexLabel> vertexLabels;
        Ex.check(!detail.hasConflict(), "schema.cannot-reuse-conflict", new Object[0]);
        HugeClient client = this.client(connId);
        List<PropertyKey> propertyKeys = this.pkService.filter(detail, client);
        if (!propertyKeys.isEmpty()) {
            try {
                this.pkService.addBatch(propertyKeys, client);
            }
            catch (Exception e) {
                throw new ExternalException("schema.propertykey.reuse.failed", (Throwable)e, new Object[0]);
            }
        }
        if (!(vertexLabels = this.vlService.filter(detail, client)).isEmpty()) {
            try {
                this.vlService.addBatch(vertexLabels, client);
            }
            catch (Exception e) {
                this.pkService.removeBatch(propertyKeys, client);
                throw new ExternalException("schema.vertexlabel.reuse.failed", (Throwable)e, new Object[0]);
            }
        }
        if (!(edgeLabels = this.filter(detail, client)).isEmpty()) {
            try {
                this.addBatch(edgeLabels, client);
            }
            catch (Exception e) {
                this.vlService.removeBatch(vertexLabels, client);
                this.pkService.removeBatch(propertyKeys, client);
                throw new ExternalException("schema.edgelabel.reuse.failed", (Throwable)e, new Object[0]);
            }
        }
        if (!(indexLabels = this.piService.filter(detail, client)).isEmpty()) {
            try {
                this.piService.addBatch(indexLabels, client);
            }
            catch (Exception e) {
                this.removeBatch(edgeLabels, client);
                this.vlService.removeBatch(vertexLabels, client);
                this.pkService.removeBatch(propertyKeys, client);
                throw new ExternalException("schema.propertyindex.reuse.failed", (Throwable)e, new Object[0]);
            }
        }
    }

    public List<EdgeLabel> filter(ConflictDetail detail, HugeClient client) {
        return detail.getElConflicts().stream().filter(c -> c.getStatus() == ConflictStatus.PASSED).map(SchemaConflict::getEntity).map(e -> EdgeLabelService.convert(e, client)).collect(Collectors.toList());
    }

    public void addBatch(List<EdgeLabel> edgeLabels, HugeClient client) {
        BiConsumer<HugeClient, EdgeLabel> consumer = (hugeClient, el) -> hugeClient.schema().addEdgeLabel(el);
        EdgeLabelService.addBatch(edgeLabels, client, consumer, SchemaType.EDGE_LABEL);
    }

    public void removeBatch(List<EdgeLabel> edgeLabels, HugeClient client) {
        List<String> names = EdgeLabelService.collectNames(edgeLabels);
        BiFunction<HugeClient, String, Long> func = (hugeClient, name) -> hugeClient.schema().removeEdgeLabelAsync(name);
        EdgeLabelService.removeBatch(names, client, func, SchemaType.EDGE_LABEL);
    }

    private static EdgeLabelEntity convert(EdgeLabel edgeLabel, List<IndexLabel> indexLabels) {
        if (edgeLabel == null) {
            return null;
        }
        Set<Property> properties = EdgeLabelService.collectProperties((SchemaLabel)edgeLabel);
        List<PropertyIndex> propertyIndexes = EdgeLabelService.collectPropertyIndexes((SchemaLabel)edgeLabel, indexLabels);
        boolean linkMultiTimes = edgeLabel.frequency() == Frequency.MULTIPLE;
        return EdgeLabelEntity.builder().name(edgeLabel.name()).sourceLabel(edgeLabel.sourceLabel()).targetLabel(edgeLabel.targetLabel()).linkMultiTimes(linkMultiTimes).properties(properties).sortKeys(edgeLabel.sortKeys()).propertyIndexes(propertyIndexes).openLabelIndex(edgeLabel.enableLabelIndex()).style(EdgeLabelService.getStyle((SchemaElement)edgeLabel)).createTime(EdgeLabelService.getCreateTime((SchemaElement)edgeLabel)).build();
    }

    private static EdgeLabelStyle getStyle(SchemaElement element) {
        String styleValue = (String)element.userdata().get("~style");
        if (styleValue != null) {
            return (EdgeLabelStyle)JsonUtil.fromJson((String)styleValue, EdgeLabelStyle.class);
        }
        return new EdgeLabelStyle();
    }

    private static EdgeLabel convert(EdgeLabelEntity entity, HugeClient client) {
        if (entity == null) {
            return null;
        }
        Frequency frequency = entity.isLinkMultiTimes() ? Frequency.MULTIPLE : Frequency.SINGLE;
        EdgeLabelStyle style = entity.getStyle();
        return (EdgeLabel)client.schema().edgeLabel(entity.getName()).sourceLabel(entity.getSourceLabel()).targetLabel(entity.getTargetLabel()).frequency(frequency).properties(EdgeLabelService.toStringArray(entity.getPropNames())).sortKeys(EdgeLabelService.toStringArray(entity.getSortKeys())).nullableKeys(EdgeLabelService.toStringArray(entity.getNullableProps())).enableLabelIndex(entity.isOpenLabelIndex()).userdata("~create_time", (Object)entity.getCreateTime()).userdata("~style", (Object)JsonUtil.toJson((Object)style)).build();
    }

    private static EdgeLabel convert(EdgeLabelUpdateEntity entity, HugeClient client) {
        if (entity == null) {
            return null;
        }
        HashSet<String> properties = new HashSet<String>();
        if (entity.getAppendProperties() != null) {
            entity.getAppendProperties().forEach(p -> properties.add(p.getName()));
        }
        EdgeLabel.Builder builder = client.schema().edgeLabel(entity.getName()).properties(EdgeLabelService.toStringArray(properties)).nullableKeys(EdgeLabelService.toStringArray(properties));
        EdgeLabel edgeLabel = (EdgeLabel)builder.build();
        Map userdata = edgeLabel.userdata();
        EdgeLabelStyle style = entity.getStyle();
        if (style != null) {
            userdata.put("~style", JsonUtil.toJson((Object)style));
        }
        return edgeLabel;
    }
}

