/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.ExecutionContextThreadedImpl;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.util.NucleusLogger;

public class ExecutionContextPool {
    private PersistenceNucleusContext nucCtx;
    private long maxIdle = 20L;
    private long expirationTime;
    private Map<ExecutionContext, Long> recyclableECs;
    private CleanUpThread cleaner;

    public ExecutionContextPool(PersistenceNucleusContext nucCtx) {
        this.maxIdle = nucCtx.getConfiguration().getIntProperty("datanucleus.executionContext.maxIdle");
        this.nucCtx = nucCtx;
        this.expirationTime = 30000L;
        this.recyclableECs = new ConcurrentHashMap<ExecutionContext, Long>();
        if (nucCtx.getConfiguration().getBooleanProperty("datanucleus.executionContext.reaperThread")) {
            this.cleaner = new CleanUpThread(this, this.expirationTime * 2L);
            this.cleaner.start();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("Started pool of ExecutionContext (maxPool=" + this.maxIdle + ", reaperThread=" + (this.cleaner != null) + ")");
        }
    }

    protected ExecutionContext create(Object owner, Map<String, Object> options) {
        if (this.nucCtx.getConfiguration().getBooleanProperty("datanucleus.Multithreaded")) {
            return new ExecutionContextThreadedImpl(this.nucCtx, owner, options);
        }
        return new ExecutionContextImpl(this.nucCtx, owner, options);
    }

    public boolean validate(ExecutionContext ec) {
        return true;
    }

    public void expire(ExecutionContext ec) {
    }

    public synchronized ExecutionContext checkOut(Object owner, Map<String, Object> options) {
        ExecutionContext ec2;
        long now = System.currentTimeMillis();
        if (this.recyclableECs.size() > 0) {
            Set<ExecutionContext> e = this.recyclableECs.keySet();
            for (ExecutionContext ec2 : e) {
                if (now - this.recyclableECs.get(ec2) > this.expirationTime) {
                    this.recyclableECs.remove(ec2);
                    this.expire(ec2);
                    ec2 = null;
                    continue;
                }
                if (this.validate(ec2)) {
                    this.recyclableECs.remove(ec2);
                    ec2.initialise(owner, options);
                    return ec2;
                }
                this.recyclableECs.remove(ec2);
                this.expire(ec2);
                ec2 = null;
            }
        }
        ec2 = this.create(owner, options);
        return ec2;
    }

    public synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        Set<ExecutionContext> e = this.recyclableECs.keySet();
        for (ExecutionContext ec : e) {
            if (now - this.recyclableECs.get(ec) <= this.expirationTime) continue;
            this.recyclableECs.remove(ec);
            this.expire(ec);
            ec = null;
        }
        System.gc();
    }

    public synchronized void checkIn(ExecutionContext ec) {
        if ((long)this.recyclableECs.size() < this.maxIdle) {
            this.recyclableECs.put(ec, System.currentTimeMillis());
        }
    }

    class CleanUpThread
    extends Thread {
        private ExecutionContextPool pool;
        private long sleepTime;

        CleanUpThread(ExecutionContextPool pool, long sleepTime) {
            this.pool = pool;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    CleanUpThread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.pool.cleanUp();
            }
        }
    }
}

